/*
** This module test checks the config code, when built to use Xrm.
*/

/* $XConsortium: config-test.c /main/2 1996/12/30 16:35:23 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdio.h>
#include "../dia/config.h"

typedef struct _TestRec {
    char	*comment;	/* description of test */
    int		argc;		/* number of strings in argv */
    char	**argv;		/* command line */
    char	*file;		/* config file name */
    char	*appClass;	/* class of application */
    XaConfigUnkown warn;	/* error level for leftover arguments */

    char 	*strName;	/* name of string resource */
    XaBoolean	strSuccess;	/* whether get should succeed for string */
    char	*strResult;	/* expected value of sting on success */

    char 	*boolName;	/* name of boolean resource */
    XaBoolean	boolSuccess;	/* whether get should succeed for string */
    XaBoolean	boolResult;	/* expected value of sting on success */

    char 	*intName;	/* name of integer resource */
    XaBoolean	intSuccess;	/* whether get should succeed for string */
    int		intResult;	/* expected value of sting on success */
} TestRec;

#define COUNT(foo)	(sizeof(foo)/sizeof(foo[0]))

char *argvNone[] =	{ "test1"  };
char *argvGood[] =	{ "test2", "-port", "portnumber", "-noauth" };
char *argvBad[]  =	{ "test3", "-foodForRent" };
char *argvHelp[] =	{ "testHelp", "-help", "me" };
char *argvTight[] =	{ "tight", };
char *argvConfig[] =	{ "test1", "-config", "config.cfg" };
char *argvName[] =	{ "test1", "-name", "tight" };
char *argvXrm[] =	{ "test1", "-xrm", "*timeout:325" };
char *argvPath[] =	{ "/some/long.path/tight.ext", };

TestRec tests[] =
{
    {
	"Test no config, no command opts",
	COUNT(argvNone), argvNone, 
	"config-test-not", "Not", XaConfigUnknownWarn,
	".port",	XaFalse,	"", 
	".noauth",	XaFalse,	XaFalse, 
	".timeout",	XaFalse,	0
    },
    {
	"Test no config, with good command opts",
	COUNT(argvGood), argvGood, 
	"config-test-not", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"portnumber", 
	".noauth",	XaTrue,		XaTrue, 
	".timeout",	XaFalse,	0
    },
    {
	"Test loose config, no command opts",
	COUNT(argvNone), argvNone, 
	"config.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"POBox1", 
	".noauth",	XaTrue,		XaTrue, 
	".timeout",	XaTrue,		42
    },
    {
	"Test loose config, good command opts",
	COUNT(argvGood), argvGood, 
	"config.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"portnumber", 
	".noauth",	XaTrue,		XaTrue, 
	".timeout",	XaTrue,		42
    },
    {
	"Test tight config, no command opts",
	COUNT(argvTight), argvTight, 
	"config.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"Tripoli", 
	".noauth",	XaTrue,		XaFalse, 
	".timeout",	XaTrue,		82
    },
    {
	"Test prefix (with config, no command opts)",
	COUNT(argvNone), argvNone, 
	"config.cfg", "Not", 	XaConfigUnknownWarn,
	"tight2.port",		XaTrue,		"wine", 
	"tight2.noauth",	XaTrue,		XaTrue, 
	"tight2.timeout",	XaTrue,		96
    },
    {
	"Test -config option",
	COUNT(argvConfig), argvConfig, 
	"moo.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"POBox1", 
	".noauth",	XaTrue,		XaTrue, 
	".timeout",	XaTrue,		42
    },
    {
	"Test -name option",
	COUNT(argvName), argvName, 
	"config.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"Tripoli", 
	".noauth",	XaTrue,		XaFalse, 
	".timeout",	XaTrue,		82
    },
    {
	"Test -xrm option",
	COUNT(argvXrm), argvXrm, 
	"config-not", "Not", XaConfigUnknownWarn,
	".port",	XaFalse,	"", 
	".noauth",	XaFalse,	XaFalse, 
	".timeout",	XaTrue,		325
    },
    {
	"Test cull of app name from path",
	COUNT(argvPath), argvPath, 
	"config.cfg", "Not", XaConfigUnknownWarn,
	".port",	XaTrue,		"Tripoli", 
	".noauth",	XaTrue,		XaFalse, 
	".timeout",	XaTrue,		82
    },
#ifdef BY_HAND
    {
	"Test no config, with bad command opts - should claim error",
	COUNT(argvBad), argvBad, 
	"config-test-not", "Not", XaConfigUnknownWarn,
	".port",	XaFalse, 	"", 
	".noauth",	XaFalse, 	XaFalse, 
	".timeout",	XaFalse, 	0
    },
    {
	"Test help option - will exit",
	COUNT(argvHelp), argvHelp, 
	"config-test-not", "Not", XaConfigUnknownWarn,
	XaFalse, "", XaFalse, XaFalse, XaFalse, 0
    },
#endif
};
    

main()
{
    int ntests = COUNT(tests);
    TestRec *pt = &tests[0];
    XaBoolean result;

    for (;ntests--; pt++)
    {
	char *port = NULL;
	XaBoolean noauth = XaFalse;
	int testInt = 0;
	
	fprintf(stderr, "\t%s\n", pt->comment);
	if (!_XaCreateConfig(pt->argc, pt->argv, pt->file, 
		pt->appClass, pt->warn))
	{
	    fprintf(stderr,"\t\tconfig creation failed!\n");
	    exit(2);
	}

	/*
	** test the string resource
	*/
	result = _XaConfigGetString(pt->strName, NULL, &port);
	if (result != pt->strSuccess)
	{
	    fprintf(stderr, "\t\tconfig-test string get failed\n");
	    exit(2);
	}
	if (result)
	{
	    if (strcmp(port, pt->strResult))
	    {
		fprintf(stderr, "\t\tconfig-test string bad\n");
		exit(2);
	    }
	}
	else if (port)
	{
	    fprintf(stderr, "\t\tconfig-test string bad\n");
	    exit(2);
	}

	/*
	** test the bool resource
	*/
	result = _XaConfigGetBool(pt->boolName, NULL, &noauth);
	if (result != pt->boolSuccess)
	{
	    fprintf(stderr, "\t\tconfig-test bool get failed\n");
	    exit(2);
	}
	if (result)
	{
	    if (noauth != pt->boolResult)
	    {
		fprintf(stderr, "\t\tconfig-test bool bad\n");
		exit(2);
	    }
	}
	else if (noauth)
	{
	    fprintf(stderr, "\t\tconfig-test bool bad\n");
	    exit(2);
	}

	/*
	** test the int resource
	*/
	result = _XaConfigGetInt32(pt->intName, NULL, &testInt);
	if (result != pt->intSuccess)
	{
	    fprintf(stderr, "\t\tconfig-test int get failed\n");
	    exit(2);
	}
	if (result)
	{
	    if (testInt != pt->intResult)
	    {
		fprintf(stderr, "\t\tconfig-test int bad\n");
		exit(2);
	    }
	}
	else if (testInt)
	{
	    fprintf(stderr, "\t\tconfig-test int bad\n");
	    exit(2);
	}
    }
    fprintf(stderr, "Tests succeeded!!\n");
}
