/* $XConsortium: ossdevice.c /main/2 1996/12/30 16:35:09 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>  
#include <math.h>  
#include <sys/types.h>  
#include <sys/time.h>  
#include <sys/soundcard.h>
#include "errors.h"
#include <Xa/atomdefs.h>
#include "cobject.h"
#include "cdevice.h"

static int   device_fd = -1;
static int   dev_mode = -1;
static char  *audio_device = "/dev/dsp";

/* 
 * USS device module
 *   Open, Close, Read, Write, Reset, Drain
 */
int 
USSOpenFunc(void *object, int mode)
{
    int status;

    if((device_fd = open(audio_device, mode)) == -1)
    {
        fprintf(stderr, " **Could not open /dev/dsp audio device file **\n");
        return -1;
    }
    dev_mode = mode;

/*
 * Get encodings or block size?
 */
    return 0;
}


int 
USSCloseFunc(void *object)
{
    if (device_fd != -1)
        close(device_fd);

    return 0;
}


int 
USSReadFunc (void *object, void *connectId,
	     XaTime atTime, XaAtom refTime, 
	     char **buf, CARD32 bitsToRead,
	     CARD8 *leftPad, CARD32 *bitsRead,
	     XaTime *deviceTime)
{
    /* XXX mw: For now just assume we're to read byte-aligned audio data. */
    
    XaErrorCode err = XaESuccess;
    int bytesToRead = bitsToRead / 8;
    
    if (dev_mode != O_WRONLY)
	*bitsRead = read(device_fd, *buf, bytesToRead) * 8;
    else
	err = XaEFailure;

    return err;
}


XaErrorCode
USSWriteFunc(void *object, void *connectId,
	     XaTime atTime, XaAtom refTime, 
	     char *buffer, CARD32 bitsToWrite, 
	     CARD8 leftPad, CARD32 *bitsWritten,
	     XaTime *deviceTime)
{
    /* XXX mw: For now just assume we're to write byte-aligned audio data. */

    XaErrorCode err = XaESuccess;
    int bytesToWrite = bitsToWrite / 8;
    
    if (dev_mode != O_RDONLY)
	*bitsWritten = write(device_fd, buffer, bytesToWrite) * 8;
    else
	err = XaEFailure;

    return err;
}


int 
USSResetFunc(void *object)
{
    /* XXX Do a SOUND_PCM_RESET instead? */
    return lseek (device_fd, 0, SEEK_SET);
}


int 
USSDrainFunc(void *object)
{
    return ioctl(device_fd, SOUND_PCM_SYNC, NULL);
}


/*
 * Device Attribute Callbacks....
 */
boolean_t
USSCheckChannelsCB (void *object, XaAttributeCBData *data)
{
    boolean_t  status = B_TRUE;

/*
 * Check if newvalue is a valid value
 */

    return (status);
}

/*********
 * Encoding
 *
 *********/
void
USSGetEncodingCB (void *object, XaAttributeCBData *data)
{
    int encoding;
    int status;

    encoding = AFMT_QUERY;
    status = ioctl(device_fd, SNDCTL_DSP_SETFMT, &encoding);
    if (status == -1)
	perror("USSGetEncoding format query ioctl failed.");

    if (encoding == AFMT_MU_LAW)
      data->value = (void *)XaAencodeUlaw;
    else if (encoding == AFMT_A_LAW)
      data->value = (void *)XaAencodeAlaw;
    else if (encoding == AFMT_IMA_ADPCM)
      data->value = (void *)XaAencodeIMAADPCM;
    else if (encoding == AFMT_MPEG)
      data->value = (void *)XaAencodeMPEG;
    else if (encoding >= AFMT_U8 && encoding <= AFMT_U16_BE)
      data->value = (void *)XaAencodeLinear;
}


boolean_t
USSCheckEncodingCB (void *object, XaAttributeCBData *data)
{
    boolean_t  status = B_TRUE;

    return (status);
}


/*
 * Gain
 */

void
USSSetGainCB (void *object, XaAttributeCBData *data)
{
    int gain;

    gain = (int)data->newValue;
    /* XXX need to check if OGAIN supported, maybe use PCM */
    /* XXX needs to distinguish input vs output gain */

    if (ioctl(device_fd, SOUND_MIXER_OGAIN, &gain) == -1)
    {
        perror("USSSetGain ioctl failed.");
    }
}


void
USSGetGainCB (void *object, XaAttributeCBData *data)
{
    int gain;

    /* XXX need to check if OGAIN supported, maybe use PCM */
    /* XXX needs to distinguish input vs output gain */

    if (ioctl(device_fd, SOUND_MIXER_READ_OGAIN, &gain) == -1)
    {
        perror("USSGetGain ioctl failed.");
    }

    data->value = (void *) gain;
}


boolean_t
USSCheckGainCB (void *object, XaAttributeCBData *data)
{
    boolean_t  status = B_TRUE;

    return (status);
}


/*
 * Format attributes
 */

static unsigned
tag_to_encoding (CARD32 tag, int precision)
{
    unsigned value;

    switch (tag) {
    case XaAencodeUlaw:
	value = AFMT_MU_LAW;
        break;
    case XaAencodeAlaw:
	value = AFMT_A_LAW;
        break;
/* XXX need to distinguish other linear formats? */
    case XaAencodeLinear:
        if (precision == 8)
	    value = AFMT_U8;
        else
	    value = AFMT_S16_LE;
        break;
/* XXX missing encoding cases */
      default:
	value = AFMT_MU_LAW;
        break;
    }
    return value;
}


/* Return TRUE if the sample rates are within a close tolerance (1%)
 */
static boolean_t 
rate_match(
        unsigned int            rate1,
        unsigned int            rate2)
{
        double                  tol;
 
        tol = ((double) rate2 - (double) rate1) / (double) rate2;
        if (fabs(tol) > .01)
                return (B_FALSE);
        return (B_TRUE);
}


XaBoolean
USSValidateFormatCB (void *object, int noOfAttrs, 
		     XaAttributeCBData **attrs)
{
    void              *format = NULL;
    unsigned           nchannels, sample_rate, encoding, sample_width;
    XaAttributeCBData  cbd;
    int                i;
    XaErrorCode        err;

    for (i = 0; i < noOfAttrs; i++) {
      if (attrs[i]->name == XaAformat)
        format = attrs[i]->newValue;
    }
/*
 * If XaAformat was not set, then
 * return
 */
    if (format == NULL)
      return B_TRUE;
/*
 * Check to see if these format
 * attributes make sense together.
 */
    cbd.name = XaAnumChannels;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return B_FALSE;
    nchannels = (unsigned)cbd.value;

    cbd.name = XaAsampleRate;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return B_FALSE;
    sample_rate = (unsigned)cbd.value;

    cbd.name = XaAencoding;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return B_FALSE;
    encoding = (unsigned)cbd.value;

    /* XXX don't do any checking for now
    if ((encoding == XaAencodeUlaw ||
	encoding == XaAencodeAlaw) &&
        rate_match(sample_rate, 8000) && (nchannels == 1))
        return B_TRUE;
    else if (encoding == XaAencodeLinear && nchannels <= 2)
	return B_TRUE;
    else
	return B_FALSE;
      /* XXX */

    return B_TRUE;
}


void
USSSetFormatCB (void *object, XaAttributeCBData *data)
{
    void *format = data->newValue;
    XaAttributeCBData cbd;
    XaErrorCode       err;
    unsigned          value;
    int precision;
    int encoding;
    int channels;
    int sample_rate;

/*
 * Bits Per Sample 
 */ 
    cbd.name = XaAbitsPerSample;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return;

    precision = (unsigned)cbd.value;
/*
 * Encoding
 */ 
    cbd.name = XaAencoding;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return;

    encoding = tag_to_encoding((CARD32)cbd.value, precision);

    if(ioctl(device_fd, SNDCTL_DSP_SETFMT, &encoding) == -1)
    {
        perror("USSSetFormat SETFMT ioctl failed.");
    }

/*
 * Number of channels
 */
    cbd.name = XaAnumChannels;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return;

    channels = (unsigned)cbd.value;

    if(ioctl(device_fd, SOUND_PCM_WRITE_CHANNELS, &channels) == -1)
    {
        perror("USSSetFormat WRITE_CHANNELS ioctl failed.");
    }

/*
 * Sample Rate
 */
    cbd.name = XaAsampleRate;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return;

    sample_rate = (unsigned)cbd.value;

    if(ioctl(device_fd, SOUND_PCM_WRITE_RATE, &sample_rate) == -1)
    {
        perror("USSSetFormat WRITE_RATE ioctl failed.");
    }
}


boolean_t
USSCheckSampleRateCB (void *object, XaAttributeCBData *data)
{
    if ((unsigned int)data->value < 4000 ||
	(unsigned int)data->value > 48000)
        return (B_FALSE);
    return B_TRUE;
}


boolean_t
USSCheckFormatCB (void *object, XaAttributeCBData *data)
{
    void *format = data->newValue;
    XaAttributeCBData cbd;
    XaErrorCode       err;
    boolean_t  status = B_TRUE;
/*
 * Check if format values are valid.
 */

/*
 * Check Number of Channels
 */
    cbd.name = XaAnumChannels;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return B_FALSE;

    status = USSCheckChannelsCB (object, &cbd);
    if (status == B_FALSE)
      return B_FALSE;
/*
 * Check Sample Rate
 */
    cbd.name = XaAsampleRate;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess)
      return B_FALSE;

    status = USSCheckSampleRateCB (format, &cbd);
    if (status == B_FALSE)
      return B_FALSE;
/*
 * Do an XaSetAttribute in case rate was adjusted
 */
    err = XaSetAttributes (format, &cbd, 1);
    if (err != XaESuccess) 
      return B_FALSE;
    
/*
 * Checking encoding
 */
    cbd.name = XaAencoding;
    err = XaGetAttributes (format, &cbd, 1);
    if (err != XaESuccess) 
      return B_FALSE;

    status = USSCheckEncodingCB (object, &cbd);
    if (status == B_FALSE)
      return B_FALSE;

    return (status);
}


/**********
 * FormatWidth
 **********/
void
USSSetFormatWidthCB (void *object, XaAttributeCBData *data)
{
    int precision = (unsigned) data->newValue;
    /* XXX need to combone format width and encoding into format */
}


USSValidateCB (void *object, int count, XaAttributeCBData **data)
{
/*
 * Check if these set of attributes are valid as a set.
 */
    return B_TRUE;
}


/*
 * Update the device time (not - shawnm)
 */
static struct timeval
USSUpdateFunc()
{
    struct timeval tv = {0, 0};
    return tv;
}


boolean_t
USSDeviceInit(void *obj, XaBoolean write) 
{
    XaAttributeCBData attr;
    XaAttributeSetCB  setCB;
    void              *connectorObject;

    /*
       XXX mw: Added passthrough connector creation here,
       moved from dia/device.cc since it is only used for
       a subset of vendors -- 29 May 1996
    */
    /* XXX we need to use a  mixing connector ala dec msb */
    if (write)
    {
	connectorObject = XaCreatePassThroughConnector(USSUpdateFunc,
						       USSWriteFunc,
						       NULL, NULL);
	if (!connectorObject) return XaEFailure;

	XaSetDeviceConnector(obj, connectorObject);
    }
    
    /*
     * then set some local functions.
     */
    SetDeviceOpenFunc(obj, USSOpenFunc);
    SetDeviceReadFunc(obj, USSReadFunc);
    SetDeviceWriteFunc(obj, USSWriteFunc);
    SetDeviceResetFunc(obj, USSResetFunc);
    SetDeviceDrainFunc(obj, USSDrainFunc);
    SetDeviceCloseFunc(obj, USSCloseFunc);

    attr.name = XaAformat;
    attr.type = XaAformat;
    SetAttributeSetCB (obj, &attr, USSSetFormatCB);
    /*SetAttributeGetCB (obj, &attr, USSGetFormatCB); */
    SetAttributeCheckCB (obj, &attr, USSCheckFormatCB); 

    attr.name = XaAgain;
    attr.type = XaTcard32;
    SetAttributeSetCB (obj, &attr, USSSetGainCB);
    SetAttributeGetCB (obj, &attr, USSGetGainCB);
    SetAttributeCheckCB (obj, &attr, USSCheckGainCB);

    SetAttributeValidateCB(obj, USSValidateFormatCB); 

    return 0;
}


boolean_t
device_init(void *obj, XaBoolean write) 
{
   return (USSDeviceInit (obj, write));
}

