/* $XConsortium: msbdevice.c /main/26 1996/12/31 11:35:42 ray $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


*/

/* MSB device module
 */
/*
********************************

MsbInit() 

    open the device
    set up the ring buffer and fill it with silence
    start the update task

MsbUpdate()

    copy data from the ring buffer transfer zone to the hardware DMA
    reset the current times


MsbOpenFunc()

    does this do anything?
    maybe register that another port will be mixing in data

MsbReadFunc);
    MsbWriteFunc);
    MsbResetFunc);
    MsbDrainFunc);

    MsbSetChannelsCB);
    MsbGetChannelsCB);
    MsbCheckChannelsCB);
    MsbValidateChannelsCB);


********************************
*/

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>  
#include <sys/types.h>  
#include <values.h>  
#include <string.h>
/* #include <sys/audioio.h> */
#include "msb.h"
#include "errors.h"  
#include <Xa/atomdefs.h>  
#include <Xa/Xalib.h>  
#include "cobject.h"  
#include "cdevice.h"
#include "xatime.h"

#include <assert.h>

#ifdef DEBUG
#include "config.h"

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".Device.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#endif /* DEBUG */


static int   device_fd = -1;
static int   dev_mode = -1;
static XaBoolean initialized = 0;
static void  *read_device = NULL;
void *write_device = NULL;

#define XA_MSB_INIT_TIME 0
/*
 * This can be used as a starting time to test how time wraps from MAXINT to
 * -MAXINT
#define XA_MSB_INIT_TIME (MAXINT - 100000)
 */
static XaTime msbDeviceTime = XA_MSB_INIT_TIME;
static long lastMilliClock;

static char  *audio_device = "/dev/msb0";
static msb_io_info_t msb_info;
/* msbPhysDevice pDev; */

#ifdef DUMP_BITS
static int dumpFd;
#endif

struct msbFormat
{
    XaTime	sampleRate;
    XaAtom	encoding;
    CARD32	numChannels;
    CARD32	sampleWidth;	/* bits */
    int		silenceValue;
};

#define FORMAT_EQUAL(a, b) (a.sampleRate == b.sampleRate \
	    && a.encoding == b.encoding && a.numChannels == b. numChannels \
	    && a.sampleWidth == b.sampleWidth)



struct readWriteParams
{
    struct msbFormat format;
    CARD32 bytesPerSample;	/* includes all channels */
    char * ringBufAddr;
    XaTime ringBufSize;		/* samples */
    XaTime transferSize; /* XXX is this redundant with sampleTransferTarget ? */
    XaTime sampleLimit;
    XaTime hardwareTransferLimit;
    XaTime sampleTransferTarget;
    XaTime currentSample;
    XaBoolean DMArunning;
    XaBoolean firstWriteDone;
    XaBoolean DMAwrapped;
    char *DMAbuffer;
    unsigned int DMAsize;	/* bytes */
    unsigned int DMAsamples;	/* includes all channels */
    unsigned int DMAwriteIndex;	/* bytes */
    unsigned int DMAlastOffset;	/* bytes */
    unsigned int DMAzeroed;	/* bytes */
    int portsConnected;
    long sampleInterval;
    long timeInterval;
};

struct readWriteParams writeParams;
struct readWriteParams readParams;

#include <sys/time.h>

int MsbInit(char *devName);
XaTime MsbTimeUpdate(void);
XaErrorCode MsbSetFormat(struct msbFormat);
void MsbSetFormatCB (void *object, XaAttributeCBData *data);
XaBoolean MsbValidateFormatCB (void *object, int attCount,
				XaAttributeCBData **dataPtr);

#if 0
XaTime GetTimeInMillis(void)
{
    struct timeval  tp;
    long mSecs;
    XaTime returnTime;

    gettimeofday(&tp, 0);
    /* Avoid overflow */
    mSecs = (long)tp.tv_sec * 1000L + ((long)tp.tv_usec / 1000L);

    mSecs = mSecs % ((MAXINT << 1) + 1);
    
    mSecs = -(MAXINT - 1) + mSecs;

    returnTime = mSecs;

    return returnTime;
}
#endif

/*
 * This relies on a 64-bit long to avoid overflow.
 */
long GetTimeInMillis(void)
{
    struct timeval  tp;

    gettimeofday(&tp, 0);
    /* Avoid overflow */
    return  (long)tp.tv_sec * 1000L + ((long)tp.tv_usec / 1000L);
}

void FatalError( char * fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vfprintf (stderr, fmt, args);
    va_end(args);
    abort();
}

Debug ( char * fmt, ...)
{
#ifdef DEBUG
    if (DoDebug())
    {
	va_list args;
	va_start(args, fmt);
	vprintf (fmt, args);
	va_end(args);
    }
#endif
}


XaErrorCode MsbWriteStart(void)
{
    int status;
    msb_io_t cmd;

    cmd.cmd = MSB_IO_START;
    cmd.inputOffset = 0; /* actually ignored */
    status = ioctl(device_fd, MSB_WRITE, &cmd);
    if (status < 0)
	FatalError("Xaserver: MSB_WRITE MSB_IO_START failed\n");
    writeParams.DMArunning = TRUE;
    writeParams.DMAwriteIndex = 0;
    writeParams.firstWriteDone = XaFalse;
    /* writeParams.sampleTransferTarget = writeParams.DMAsamples/3;
     */

    /* XXXXXX Wrong, doesn't belong here. workaround for now */
    lastMilliClock = GetTimeInMillis();
    fprintf(stderr, "MSB DMA started\n");
    return XaESuccess;
}


void *MsbWriteConnectFunc(void *port, void *formatObj)
{
    struct msbFormat format;

    if (!initialized)
	MsbInit(audio_device);

    /* verify format */
    if (XaESuccess != MsbReadFormatObj(formatObj, &format))
	return NULL;	  /* failure */

    if (writeParams.portsConnected > 0
		&& !FORMAT_EQUAL(writeParams.format, format))
	return NULL;	  /* failure */
    
    if (writeParams.portsConnected == 0
		&& XaESuccess != MsbSetFormat(writeParams.format))
	return NULL;	  /* failure */
    /* add port to list of connected ports */
    writeParams.portsConnected ++;

    if (writeParams.DMArunning)
	return (void *)writeParams.portsConnected; /* connectID -- success */

    if (XaESuccess != (void *)MsbWriteStart())
	return NULL;	  /* failure */
    else
	return (void *)writeParams.portsConnected; /* connectID -- success */
}

XaErrorCode MsbWriteDisconnectFunc(void * port, void * connectId,
					XaBoolean flush)
{
    writeParams.portsConnected --;
    if (writeParams.portsConnected <= 0)
    {
	writeParams.portsConnected = 0;
	/* XXXX   MsbWriteStop(); */
    }
    return XaESuccess;
}


void *MsbReadConnectFunc(void *port, void *format)
{
    /* XXXX verify format */
    /* XXXX add port to list of connected ports */
    if (!initialized)
	MsbInit(audio_device);


    if (writeParams.DMArunning)
	return (void *)1; /* connectID -- success */

    if (0 == (void *)MsbWriteStart())
	return (void *)1; /* connectID -- success */
    else
	return NULL;	  /* failure */
}

XaErrorCode MsbReadDisconnectFunc(void * port, void * connectId,
					XaBoolean flush)
{
    /* XXXXXX Do something??? */
    return XaESuccess;
}


XaErrorCode
MsbReadFunc(void *object, void *connectID, XaTime atTime, XaTag refTime,
	    char **buffer, CARD32 bitsToRead, CARD8 *leftPad, CARD32 *bitsRead,
	    XaTime *deviceTime)
{
    /* XXX mw: For now just assume we're to read byte-aligned audio data. */
    
    /* Set up.
     * Then do the read.
     */
    XaErrorCode err = XaESuccess;
    int bytesToRead = bitsToRead / 8;
    
    /* XXXXXXXX change params to samples??  */

    /* XXXXXXX return device time */
    *deviceTime = msbDeviceTime  = MsbTimeUpdate();

    return err;
}


int 
MsbResetFunc(void *object) {

    /* Set up.
     * Then do the read.
     */
    /* XXXXXXXXXXXXX */
    return 0;
}

void
MsbSetChannelsCB (void *object, XaAttributeCBData *data)
{
    if (write_device)
    {
	writeParams.format.numChannels = (CARD32)data->value;
	MsbSetFormat(writeParams.format);
    }
    else if (read_device)
    {
	readParams.format.numChannels = (CARD32)data->value;
	MsbSetFormat(readParams.format);
    }
}

void
MsbGetChannelsCB (void *object, XaAttributeCBData *data)
{
 /* XXXXXXXXXXXX */
}

/*
 * XaAttributeCheckCB
 */
XaBoolean
MsbCheckChannelsCB (void *object, XaAttributeCBData *data)
{
/*
 * Query this device to see how many channels is supports.
 */
   int max_channels = 2;
/*
 * Check if value
 */
   if ((int)data->value > 0 && (int) data->value < max_channels)
     return XaTrue;
   else
     return XaFalse;
}

/*
 * XaAttributeValidateCB
 */
XaBoolean
MsbValidateChannelsCB (void *object, int count, XaAttributeCBData **data)
{
 /* XXXXXXXXXXXX */
    return;
}

XaTime MsbFigureTime(msb_io_t *cmd)
{
    XaTime advance;
    long newMilliClock;
    XaTime wallClockAdvance;

    if (write_device)
    {

	newMilliClock = GetTimeInMillis();

	/* 
	 * check to see if the DMA has wrapped since the last time
	 */
	wallClockAdvance = ((XaTime)(newMilliClock - lastMilliClock) *
					writeParams.format.sampleRate) / 1000;
	if (wallClockAdvance > writeParams.DMAsamples)
	{
	    /* wrapped */
	    advance = wallClockAdvance;    

	    Debug("MsbFigureTime: DMA wrapped. advance %d\n", advance);
	    writeParams.DMAwrapped = XaTrue;
	}
	else
	{
	    /* didn't wrap */
	    advance = (XaTime)cmd->outputOffset
					- (XaTime)writeParams.DMAlastOffset;
	    if (advance < 0)
		advance += (XaTime)writeParams.DMAsize;
	    advance = advance / writeParams.bytesPerSample;
#ifdef DEBUG
	    if(DoDebug() && advance < (wallClockAdvance - 200)
			   || advance > (wallClockAdvance + 200) )
	    {
	    /* This type of error can be caused by ntp resetting the system
	     * time.
	     */
	    Debug("MsbFigureTime: **** wall clock/DMA clock skew!!\n");
	    Debug("	wallClockAdvance %d; DMA advance %d\n",
		wallClockAdvance, advance);
	    }
#endif
	}
	writeParams.DMAlastOffset = cmd->outputOffset;
	msbDeviceTime += advance;
    }
    /* XXXXXX if (read_device) XXX */

    lastMilliClock = newMilliClock;
    Debug("MSB new time: %d at walltime %ld ms\n", msbDeviceTime,
	    lastMilliClock);
    return msbDeviceTime;
}

static XaTime msbTimeUpdate(msb_io_t *cmd)
{
    long newMilliClock;
    int status;

    if (write_device)
    {
	if (!writeParams.DMArunning)
	{
	    MsbWriteStart();
	    msbDeviceTime = XA_MSB_INIT_TIME;
	    lastMilliClock = GetTimeInMillis();
	    return msbDeviceTime;
	}
	cmd->cmd = MSB_IO_UPDATE;
	status = ioctl(device_fd, MSB_WRITE, cmd);
	if (status < 0)
	{
	    /* device deadman timer must have gone off, need to restart */
	    MsbWriteStart();
	    newMilliClock = GetTimeInMillis();
	    msbDeviceTime += (XaTime)(newMilliClock - lastMilliClock)
					* writeParams.format.sampleRate/1000;
	    lastMilliClock = newMilliClock;
	    Debug("MSB Extrapolated time: %d\n", msbDeviceTime);
	    return msbDeviceTime;
	}
	return MsbFigureTime(cmd);
    }
}

XaTime MsbTimeUpdate(void)
{
    msb_io_t cmd;
    
    return msbTimeUpdate(&cmd);
}

#ifdef TEST_SOURCE
/*
**  test source
*/
#define NSAMP 9000
static char *TestSource(nsamp)
{
    static char samples[NSAMP];
    static int init = 0, current = 0;
    char sample = 0;
    int count;
    char *ret = &samples[current];

    if (!init)
    {
	init = 1;
	/*
	** fake some samples  (slow but simple);
	*/
	for (count = 0; count < NSAMP; count++)
	/* for (count = 0; count < nsamp; count++) */
	{
	    if (!(count & 0x3))           /* flop every four samples */
	    {
		sample = ~sample;
	    }
	    samples[count] = sample;
	}
    }

    current = (current + nsamp) % 8;
    return (ret);
}
#endif

/*
** 
**  XXX This really should take some context pointer, like a pointer to the
**  XXX writeParams struct.
** 
*/
struct timeval MsbUpdate(void)
{
    struct timeval returnTime;
    char *buf = NULL;
    CARD32 samplesRead;
    int status;
    msb_io_t cmd;
    int samplesToTransfer, transferTarget, samplesRemaining;
    unsigned int outputIndex;	/* DMA output index in bytes */
    unsigned int queued, avail;	/* samples */
    int i = 0;

    XaTime msbDeviceTime;

    /* get latest read index and start DMA, if needed */
    if (!writeParams.DMArunning)
	MsbWriteStart();

    if (write_device)
    {
	cmd.cmd = MSB_IO_UPDATE;
	status = ioctl(device_fd, MSB_WRITE, &cmd);

	if (status < 0)
	{
	    Debug("MSB ioctl returned failure %d !!!\n", status);
	    MsbWriteStart();
	    status = ioctl(device_fd, MSB_WRITE, &cmd);
	    if (status < 0)
	    {
		FatalError("MSB ioctl returned failure again %d !!!\n", status);
	    }
	    writeParams.DMAwriteIndex =
				cmd.outputOffset + writeParams.bytesPerSample;
	}

	msbDeviceTime = MsbFigureTime(&cmd);
	if (AFTER(msbDeviceTime, writeParams.currentSample))
	{
	    Debug("MSB currentSample %d is behind msbDeviceTime %d\n",
		writeParams.currentSample, msbDeviceTime);
	    writeParams.currentSample = msbDeviceTime;
	}

	outputIndex = cmd.outputOffset;

	if (writeParams.DMAwriteIndex >= outputIndex)
	    queued = (writeParams.DMAwriteIndex - outputIndex)
					/ writeParams.bytesPerSample;
	else
	    /*
	    queued = (writeParams.DMAsize
			- (outputIndex - writeParams.DMAwriteIndex))
				/ writeParams.bytesPerSample;
	    */
	    queued = ((writeParams.DMAsize - outputIndex)
			+ writeParams.DMAwriteIndex)
				/ writeParams.bytesPerSample;

	if (!writeParams.firstWriteDone || writeParams.DMAwrapped)
	{
	    writeParams.DMAwriteIndex
				= outputIndex + writeParams.bytesPerSample;
	    queued = 0;
	    writeParams.DMAwrapped = XaFalse;
	}

#ifdef DEBUG
	if (DoDebug())
	    assert (queued >= 0 && queued < writeParams.DMAsamples);
#endif
	Debug("MSB w=%d, r=%d, q=%d\n", writeParams.DMAwriteIndex, outputIndex,
		queued);

	if (queued > writeParams.sampleTransferTarget)
	/* this was wrong	+ writeParams.hardwareTransferLimit) */
	{
	    Debug(
	      "MSB queued samples over target!!!! (writeIndex = %d, outputIndex = %d, queued = %d)\n",
		writeParams.DMAwriteIndex, outputIndex, queued);
	    /*
	     * Something is seriously wrong.  The update must not have
	     * been scheduled in time.
	     */
	    queued = 0;
	    /*
	     * XXX not sure if I should do this --
	     */
	    writeParams.DMAwriteIndex =outputIndex + writeParams.bytesPerSample;
	}

	avail = writeParams.DMAsamples - queued - 1;

	if (queued < writeParams.sampleTransferTarget)
	    transferTarget = writeParams.sampleTransferTarget - queued;
	else
	    transferTarget = 0;

	if (transferTarget > avail)
	    transferTarget = avail;		/* shouldn't be needed */
	samplesRemaining = transferTarget;

	samplesRead = 0;

	while ((samplesRemaining > 0) && (i <= 2))
	{
	    samplesToTransfer = samplesRemaining;
#ifdef TEST_SOURCE
	    buf = TestSource(samplesToTransfer);
	    samplesRead = samplesToTransfer;
#else
	    /*
	     * used to do it this way, but wasn't accurate
	     *
	    DeviceWriteTransfer(write_device, NULL, 0, XaAlastAccessTime, &buf,
				    samplesToTransfer,
				    &samplesRead, msbDeviceTime);
	    */
	    /*
	     * ask for exactly the samples we want
	    */
	    DeviceWriteTransfer(write_device, NULL,
				writeParams.currentSample + samplesRead + 1,
				XaAdeviceTime, &buf,
				samplesToTransfer,
				&samplesRead, msbDeviceTime);
	    if (i == 0)
		Debug("\nMSB First Pass: ");
	    else if (i == 1)
		Debug("MSB Second Pass: ");
	    else if (i == 2)
		Debug("MSB Third Pass: ");
	    Debug("askfor %d read %d samples\n",
		    samplesToTransfer, samplesRead);
#ifdef DUMP_BITS
	    write(dumpFd, buf, samplesRead);
#endif
#endif
	    if (!samplesRead)
	    {
		unsigned int bytesToZero =
				samplesToTransfer * writeParams.bytesPerSample;
		if (i == 0) 
		    Debug(" - No Samples!!!\n");
		
		/* didn't get what we asked for, zero the DMA buffer */
		if (writeParams.DMAzeroed < writeParams.DMAsize)
		{

		    Debug("Zeroing %d DMA bytes.\n", bytesToZero);

		    if (writeParams.DMAsize - writeParams.DMAwriteIndex
							>= bytesToZero)
		    {
			memset(writeParams.DMAbuffer+writeParams.DMAwriteIndex,
				writeParams.format.silenceValue, bytesToZero);
		    }
		    else
		    {
			memset(writeParams.DMAbuffer+writeParams.DMAwriteIndex,
			    writeParams.format.silenceValue,
			    writeParams.DMAsize - writeParams.DMAwriteIndex);
			memset(writeParams.DMAbuffer,
			    writeParams.format.silenceValue,
			    bytesToZero
			   - (writeParams.DMAsize - writeParams.DMAwriteIndex));
		    }
		    writeParams.DMAzeroed += bytesToZero;
		}
		/* update write index */
		writeParams.DMAwriteIndex += bytesToZero;
		queued += samplesToTransfer;
		samplesRemaining = 0;
	    }
	    else
	    {
		unsigned int bytesToTransfer;
		unsigned int bytesRead =
				    samplesRead * writeParams.bytesPerSample;

		writeParams.firstWriteDone = XaTrue;

		Debug(" - xfered: %d\n", samplesRead);

		writeParams.DMAzeroed = 0;

		/* XXXXXXXX Now copy the data to the hardware. */
		if (writeParams.DMAsize - writeParams.DMAwriteIndex
							>= bytesRead)
		    {
		    samplesToTransfer = samplesRead;		/* 1 write Ok */
		    bytesToTransfer = bytesRead;
		    }
		else
		    {
		    bytesToTransfer =
			    writeParams.DMAsize - writeParams.DMAwriteIndex;
		    samplesToTransfer =
				bytesToTransfer / writeParams.bytesPerSample;
		    }

		memcpy(writeParams.DMAbuffer + writeParams.DMAwriteIndex, buf,
			bytesToTransfer);

		if (samplesToTransfer < samplesRead)
		{
		    /*
		     * copy to DMA split across buffer boundary, copy 2nd part
		     */
		    Debug("-- Split copy to DMA\n");
		    memcpy(writeParams.DMAbuffer, buf + bytesToTransfer,
			    bytesRead - bytesToTransfer);

		}
		/* update write index */
		writeParams.DMAwriteIndex += bytesRead;
		queued += samplesRead;
		samplesRemaining -= samplesRead;
	    }


	    if (writeParams.DMAwriteIndex >= writeParams.DMAsize)
		writeParams.DMAwriteIndex -= writeParams.DMAsize;
	    

	    Debug("writeIndex: %d queued: %d\n", writeParams.DMAwriteIndex,
			queued);

	    i++;
	}
	/*
	 * Whether or not we transferred what we asked for, the
	 * currentSample and writeIndex advanced.
	*/
	writeParams.currentSample += transferTarget;
    }

    gettimeofday(&returnTime, 0);

    {

	returnTime.tv_usec += writeParams.timeInterval;

	Debug("MsbUpdate rescheduling for %d samples\n\n",
		writeParams.sampleInterval);

    }

    if (returnTime.tv_usec >= (int)1E6)
    {
	returnTime.tv_sec += returnTime.tv_usec / (int)1E6;
	returnTime.tv_usec = returnTime.tv_usec % (int)1E6;
    }

    /* returnTime.tv_sec = 0;  let XaMixingConnector decide next update time */
    return returnTime;
}

/*
 * MsbWriteFunc
 *
 *	This is the "write-through" function for late data.
 */

XaErrorCode MsbWriteFunc(void *object, void *connectId, XaTime atTime,
			XaTag refTime, char *buffer, CARD32 bitsToWrite,
			CARD8 leftPad, CARD32 *bitsWritten, XaTime *deviceTime)
{
    int bytesToWrite = bitsToWrite / 8;
    int bytesToTransfer, bytesRead;
    int samplesToWrite = bytesToWrite / writeParams.bytesPerSample;
    int timeOffset, byteOffset, writeIndex;
    msb_io_t cmd;

#ifdef DEBUG
    if (DoDebug())
	assert(refTime == XaAdeviceTime);
#endif
    if (refTime != XaAdeviceTime)
	return XaEValue;
    
    *deviceTime = msbTimeUpdate(&cmd);	/* does the ioctl() */

    Debug(" MsbWriteFunc: atTime %d deviceTime %d bytes %d\n",
		atTime, *deviceTime, bytesToWrite);

    if (BEFORE(atTime, *deviceTime))
    {
	Debug("	too late for atTime!\n");
	if (BEFORE(atTime + samplesToWrite, *deviceTime))
	{
	    Debug("	totally too late!\n");
	    return XaEFailure;
	}
    }

    timeOffset = DIFF(*deviceTime, atTime);
    byteOffset = timeOffset * writeParams.bytesPerSample;

    if (timeOffset > 0)
    {
	/* 
	 * buffer straddles deviceTime
	 *
	 * adjust offsets so we don't write into the past
	 */

	buffer += byteOffset;
	bytesToWrite -= byteOffset;
	samplesToWrite -= timeOffset;
	atTime += timeOffset;
	byteOffset = 0;
    }

#ifdef DEBUG
    if (DoDebug())
	assert (bytesToWrite <= writeParams.DMAsize);
#endif

    /*
    writeIndex = cmd.outputOffset - byteOffset;
    if (writeIndex >= writeParams.DMAsize)
	writeIndex -= writeParams.DMAsize;
    */

    writeIndex = writeParams.DMAwriteIndex
      - ((writeParams.currentSample + 1 - atTime) * writeParams.bytesPerSample);
    
    if (writeIndex < 0)
	writeIndex += writeParams.DMAsize;
    else
	writeIndex %= writeParams.DMAsize;
#ifdef DEBUG
    if (DoDebug())
	assert (writeIndex >= 0 && writeIndex < writeParams.DMAsize);
#endif


    writeParams.firstWriteDone = XaTrue;
    writeParams.DMAzeroed = 0;

    /* XXXXXXXX Now copy the data to the hardware. */
    if (writeParams.DMAsize - writeIndex >= bytesToWrite)
	{
	bytesToTransfer = bytesToWrite;
	}
    else
	{
	bytesToTransfer =
		writeParams.DMAsize - writeIndex;
	}

    memcpy(writeParams.DMAbuffer + writeIndex, buffer,
	    bytesToTransfer);

    if (bytesToTransfer < bytesToWrite)
    {
	/*
	 * copy to DMA split across buffer boundary, copy 2nd part
	 */
	Debug(" MsbWriteFunc:-- Split copy to DMA\n");
	memcpy(writeParams.DMAbuffer, buffer + bytesToTransfer,
		bytesToWrite - bytesToTransfer);
    }

    return XaESuccess;
}


XaErrorCode MsbDeviceInit(void *obj, XaBoolean write) 
{
    XaAttributeCBData	attr;
    XaAttributeSetCB	setCB;
    XaErrorCode		returnCode;
    void		*connectorObject;


    /* Do device specific initialization
     */

    if (!initialized)
    {
	if (0 != MsbInit(audio_device))
	    return XaEFailure;
    }

    SetDeviceUpdateTimeFunc(obj, MsbTimeUpdate);

    /*
     * Create the connection object
     */
    if (write)
    {
	connectorObject = XaCreateMixingConnector(MsbUpdate, MsbWriteFunc,
						    MsbWriteConnectFunc,
						    MsbWriteDisconnectFunc);
	if (!connectorObject) return XaEFailure;

	/*
	 * Is this needed? - No
	 * SetDeviceWriteFunc(obj, MsbWriteFunc);
	 */
	XaSetDeviceConnector(obj, connectorObject);

	/* 
	 * These are default initial values
	 */
	writeParams.format.sampleRate = 8000;
	writeParams.format.encoding = XaAencodeUlaw;
	writeParams.format.silenceValue = 0x0ff;
	writeParams.format.sampleWidth = 8;
	writeParams.format.numChannels = 1;
	writeParams.portsConnected = 0;
	write_device = obj;
	returnCode = MsbSetFormat(writeParams.format);

	if (returnCode != XaESuccess) return returnCode;
    }
    else
    {
	SetDeviceReadFunc(obj, MsbReadFunc);
	read_device = obj;
	readParams.portsConnected = 0;

	/* XXXXXXXXXXXX */
	returnCode = XaEUnimplemented;

	if (returnCode != XaESuccess) return returnCode;
    }
    /*
     * then set some local functions.
     */
    /* SetDeviceOpenFunc(obj, MsbOpenFunc); */
    /* SetDeviceResetFunc(obj, MsbResetFunc); */
    /* SetDeviceDrainFunc(obj, MsbDrainFunc); */

    attr.name = XaAformat;
    attr.type = XaAformat;
    SetAttributeSetCB (obj, &attr, MsbSetFormatCB);
    SetAttributeValidateCB (obj, MsbValidateFormatCB);

    /* XXXXX Check this. 
     * obj is the Device - does it have a numChannels attribute?  Isn't that
     * an attribute of the format?
     */
    attr.name = XaAnumChannels;
    attr.type = XaTcard32;
    SetAttributeGetCB (obj, &attr, MsbGetChannelsCB);
    SetAttributeCheckCB (obj, &attr, MsbCheckChannelsCB);
    /* SetAttributeValidateCB (obj, MsbValidateChannelsCB); */

    SetDeviceUpdateTimeFunc(obj, MsbTimeUpdate);

    initialized = 1;
    return returnCode;
}

/*
 * This is the symbol that dlsym looks for to init the device.
 */
XaErrorCode device_init(void *obj, XaBoolean write) 
{
   return (MsbDeviceInit (obj, write));
}

XaErrorCode MsbReadFormatObj(void *formatObject, struct msbFormat *format)
{
    XaAttributeCBData cbd;
    XaErrorCode       err;
    unsigned          value;

/*
 * Number of channels
 */
    cbd.name = XaAnumChannels;
    err = XaGetAttributes (formatObject, &cbd, 1);
    if (err != XaESuccess)
	return XaEFailure;
    format->numChannels = (CARD32)cbd.value;
/*
 * Sample Rate
 */
    cbd.name = XaAsampleRate;
    err = XaGetAttributes (formatObject, &cbd, 1);
    if (err != XaESuccess)
	return XaEFailure;
    format->sampleRate = (XaTime)cbd.value;
/*
 * Bits Per Sample 
 */ 
    cbd.name = XaAbitsPerSample;
    err = XaGetAttributes (formatObject, &cbd, 1);
    if (err != XaESuccess)
	return XaEFailure;
    format->sampleWidth = (CARD32)cbd.value;
/*
 * Encoding
 */ 
    cbd.name = XaAencoding;
    err = XaGetAttributes (formatObject, &cbd, 1);
    if (err != XaESuccess)
	return XaEFailure;
    format->encoding = (XaAtom)cbd.value;
    if (format->encoding == XaAencodeLinear)
	format->silenceValue = 0;
    else
	format->silenceValue = 0x0ff;


    return XaESuccess;
}

XaBoolean MsbValidateFormatCB (void *object, int attCount,
				XaAttributeCBData **dataPtr)
{
    struct msbFormat	format;
    XaErrorCode		err;
    int			i;

    for (i = 0; i < attCount; i++, dataPtr++)
    {
	if ((*dataPtr)->name == XaAformat)
	{
	    err = MsbReadFormatObj((*dataPtr)->newValue, &format);
	    break;
	}
    }

    if (err != XaESuccess)
	return XaFalse;

    if (read_device && readParams.portsConnected > 0
		&& !FORMAT_EQUAL(readParams.format, format))
	return XaFalse;

    if (write_device && writeParams.portsConnected > 0
		&& !FORMAT_EQUAL(writeParams.format, format))
	return XaFalse;

    if (format.numChannels != 1 && format.numChannels != 2)
	return XaFalse;

    if (format.sampleWidth != 8 && format.sampleWidth != 16)
	return XaFalse;

    switch (format.sampleRate)
    {
	case 5512:
	case 5513:
	case 6615:
	case 8000:
	case 9600:
	case 11025:
	case 16000:
	case 18900:
	case 22050:
	case 27428:
	case 27429:
	case 32000:
	case 33075:
	case 37800:
	case 44100:
	case 48000:
	    break;
	default:
	    return XaFalse;	/* Error */
    }
    switch (format.encoding)
    {
	case XaAencodeLinear:
	case XaAencodeAlaw:
	case XaAencodeUlaw:
	    break;
	default:
	    return XaFalse;	/* Error */
    }

    return XaTrue;
}

void MsbSetFormatCB (void *object, XaAttributeCBData *data)
{
    struct msbFormat	format;
    XaErrorCode		err;

    err = MsbReadFormatObj(data->newValue, &format);

    if (err != XaESuccess)
	return;

    if (read_device)
	readParams.format = format;
    if (write_device)
	writeParams.format = format;
/*
 * Save new value into current state, if successful.
 */
    if (write_device)
	MsbSetFormat(writeParams.format);
    else if (read_device)
	MsbSetFormat(readParams.format);
}

XaErrorCode MsbSetFormat(struct msbFormat format)
{
    msb_sample_type_t sample_type;
    static struct msbFormat oldFormat;

    if (FORMAT_EQUAL(format, oldFormat))
    {
	/* not changed, quit, avoid mucking with the device causing noise */
	return XaESuccess;
    }

    oldFormat = format;

    Debug("MsbSetFormat: rate=%d encoding=%d channels=%d sampleWidth=%d\n",
	    format.sampleRate, format.encoding, format.numChannels,
	    format.sampleWidth);

    switch (format.sampleRate)
    {
	case 5512:
	case 5513:
	    sample_type.rate = MSB_RATE_5512_5;
	    break;
	case 6615:
	    sample_type.rate = MSB_RATE_6615;
	    break;
	case 8000:
	    sample_type.rate = MSB_RATE_8000;
	    break;
	case 9600:
	    sample_type.rate = MSB_RATE_9600;
	    break;
	case 11025:
	    sample_type.rate = MSB_RATE_11025;
	    break;
	case 16000:
	    sample_type.rate = MSB_RATE_16000;
	    break;
	case 18900:
	    sample_type.rate = MSB_RATE_18900;
	    break;
	case 22050:
	    sample_type.rate = MSB_RATE_22050;
	    break;
	case 27428:
	case 27429:
	    sample_type.rate = MSB_RATE_27428_57;
	    break;
	case 32000:
	    sample_type.rate = MSB_RATE_32000;
	    break;
	case 33075:
	    sample_type.rate = MSB_RATE_33075;
	    break;
	case 37800:
	    sample_type.rate = MSB_RATE_37800;
	    break;
	case 44100:
	    sample_type.rate = MSB_RATE_44100;
	    break;
	case 48000:
	    sample_type.rate = MSB_RATE_48000;
	    break;
	default:
	    return XaEValue;	/* Error */
    }

    switch (format.sampleWidth)
    {
	case 8:
	    switch (format.encoding)
	    {
		case XaAencodeLinear:
		    sample_type.format = MSB_FORMAT_PCM_8;
		    break;
		case XaAencodeAlaw:
		    sample_type.format = MSB_FORMAT_ALAW;
		    break;
		case XaAencodeUlaw:
		    sample_type.format = MSB_FORMAT_MULAW;
		    break;
		default:
		    return XaEValue;	/* Error */
	    }
	    break;
	case 16:
	    switch (format.encoding)
	    {
		case XaAencodeLinear:
		    sample_type.format = MSB_FORMAT_PCM_16;
		    break;
		default:
		    return XaEValue;	/* Error */
	    }
	    break;
	default:
	    return XaEValue;	/* Error */
    }

    switch (format.numChannels)
    {
	case 1:
	    sample_type.type = MSB_MODE_MONO;
	    break;
	case 2:
	    sample_type.type = MSB_MODE_STEREO;
	    break;
	default:
	    return XaEValue;	/* Error */
    }

    
    if (0 > ioctl(device_fd, MSB_SET_SAMPLE_TYPE, &sample_type))
	return XaEFailure;

#if 0
    { /* XXXXXX Hard-coded gain value XXXX */
    msb_gain_t gain;

    gain.channel_mask_left = MSB_M_ALL_CHANNELS;
    gain.channel_mask_right = MSB_M_ALL_CHANNELS;
    gain.value = 0xFFF;
    /*
    gain.enable = MSB_DISABLE;

    if (0 > ioctl(device_fd, MSB_SET_GAIN, &gain))
	return XaEFailure;
    */

    gain.enable = MSB_ENABLE;

    if (0 > ioctl(device_fd, MSB_SET_GAIN, &gain))
	return XaEFailure;
    }

    /* XXXX is this necessary?  did this change when resetting format, etc? */
    /* get the ring buffer addresses */
    if (0 > ioctl(device_fd, MSB_GET_IO_INFO, &msb_info))
	return XaEFailure;

    writeParams.DMAbuffer = msb_info.write.start;
    writeParams.DMAsize = msb_info.write.size;
    readParams.DMAbuffer = msb_info.read.start;
    readParams.DMAsize = msb_info.read.size;
#endif

    if (writeParams.DMArunning)
	MsbTimeUpdate();

    if (write_device)
    {
	XaErrorCode returnCode;

	writeParams.format = format;

	/*
	 * This will cause the DMA write pointer to be set immediately after
	 * the DMA output pointer.
	 */
	writeParams.firstWriteDone = XaFalse;

	writeParams.DMAsamples = writeParams.DMAsize 
			    / (format.numChannels * format.sampleWidth/8);
	writeParams.ringBufSize = writeParams.DMAsize * 4;
	writeParams.bytesPerSample = writeParams.format.numChannels
					* writeParams.format.sampleWidth / 8;
	writeParams.transferSize = writeParams.DMAsamples * 3/4;
	writeParams.sampleLimit = format.sampleRate/8;
	writeParams.hardwareTransferLimit = format.sampleRate/8;
	writeParams.currentSample = msbDeviceTime;
	
	writeParams.sampleTransferTarget = writeParams.transferSize;
	
	writeParams.ringBufAddr = NULL;	/* let it create the buffer */

	writeParams.sampleInterval = writeParams.sampleTransferTarget
					- writeParams.hardwareTransferLimit;
	/*
	 * this is microseconds
	 */
	writeParams.timeInterval =  (1000000 * writeParams.sampleInterval)
					/ writeParams.format.sampleRate;
	    

	returnCode = DeviceRingBufConfigure(write_device,
				&writeParams.ringBufAddr,
				writeParams.ringBufSize,
				writeParams.format.numChannels,
				writeParams.format.sampleWidth,
				writeParams.sampleTransferTarget,
				writeParams.sampleLimit,
				writeParams.hardwareTransferLimit,
				writeParams.currentSample);

	if (returnCode != XaESuccess) return returnCode;
    }

    if (read_device)
    {
	XaErrorCode returnCode;

	readParams.format = format;

	readParams.DMAsamples
	    = readParams.DMAsize/(format.numChannels * format.sampleWidth/8);
	readParams.ringBufSize = readParams.DMAsize * 2;
	readParams.bytesPerSample = readParams.format.numChannels
					    * readParams.format.sampleWidth / 8;
	readParams.transferSize = readParams.DMAsize / 4;
	readParams.sampleLimit = 1000;
	readParams.hardwareTransferLimit = 1000;
	readParams.currentSample = msbDeviceTime;
	
	readParams.sampleTransferTarget = 1.5 * readParams.transferSize;
	/* readParams.sampleTransferTarget = 1.5 * readParams.sampleRate;
	*/
	
	returnCode = DeviceRingBufConfigure(read_device,
				&readParams.ringBufAddr,
				readParams.ringBufSize,
				readParams.format.numChannels,
				readParams.format.sampleWidth,
				readParams.sampleTransferTarget,
				readParams.sampleLimit,
				readParams.hardwareTransferLimit,
				readParams.currentSample);

	if (returnCode != XaESuccess) return returnCode;
    }

    return XaESuccess;
}

int
MsbInit(char *devName)
{
    int status;
    /* msb_io_info_t msb_info; */

    device_fd = open(audio_device, O_RDWR, 0);

#ifdef DUMP_BITS
    dumpFd = creat("MsbDumpFile.dat", 0777);
#endif

    if(device_fd == -1) 
    {
	fprintf (stderr, " **Could not open msb audio device %d **\n",
		      audio_device);
	return -1;
    }

    /* get the ring buffer addresses */
    status = ioctl(device_fd, MSB_GET_IO_INFO, &msb_info);
    if (status < 0) return(-1); /* BadDevGet */

    writeParams.DMAbuffer = msb_info.write.start;
    writeParams.DMAsize = msb_info.write.size;
    readParams.DMAbuffer = msb_info.read.start;
    readParams.DMAsize = msb_info.read.size;

    writeParams.DMAlastOffset = 0;
    writeParams.DMAwrapped = XaFalse;


    /* fill output buffer with silence */
    memset( msb_info.write.start, 0x0ff, msb_info.write.size);
    writeParams.DMAzeroed = writeParams.DMAsize;

    msbDeviceTime = XA_MSB_INIT_TIME;
    lastMilliClock = GetTimeInMillis();

    Debug ("MsbInit: lastMilliClock %d\n", lastMilliClock);


    Debug("\nDMAsize: %d\n", writeParams.DMAsize);

    { /* XXXXXX Hard-coded gain value XXXX */
    msb_gain_t gain;

    gain.channel_mask_left = MSB_M_ALL_CHANNELS;
    gain.channel_mask_right = MSB_M_ALL_CHANNELS;
    gain.value = 0xFFF;
    /*
    gain.enable = MSB_DISABLE;

    if (0 > ioctl(device_fd, MSB_SET_GAIN, &gain))
	return XaEFailure;
    */

    gain.enable = MSB_ENABLE;

    if (0 > ioctl(device_fd, MSB_SET_GAIN, &gain))
	return XaEFailure;
    }   
    
    Debug("\nDMAsize: %d\n", writeParams.DMAsize);

    return status;
}
