/* $XConsortium: tagrange.h /main/5 1996/12/30 16:34:30 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// tagrange.h
//
//
// TagRanges are factories for tags between a
// particular set of values (ranges).
// 
// TagRangeFactories are factories for Tag ranges
// over tag space.
//
// This should probably be coalesced into a single abstact class
// which will produce Tag and Range factories.
//

#ifndef _TAGRANGE_H
#define _TAGRANGE_H

#include "xadefines.h"
#include "object.h"
#include "cclass.h"
#include "atomstrings.h"
#include "tagset.h"

// Number of tags available from a tag range.

class XaTagRangeFactory;
class XaConnection;
class XaTagRange;

const int XaDefaultTagRangeSize = 1024;

class XaTagRange : public XaObject {
public:
    
    XaTagRange(XaConnection * connection, XaClass * classPtr,
	       XaTag objectTag, XaTag classID, 
	       XaTag name, XaTagRangeFactory & factory);
    ~XaTagRange();

    XaTag Start() { return start; }
    XaTag Stop() { return stop; }
    int Length() { return stop - start; }

    void ReleaseTag(XaTag t);

    // Is this tag "in use"?
    XaBoolean IsTagInUse(XaTag t);
    void MarkInUse(XaTag t, XaBoolean inUse);

private:

    const XaTag start;
    const XaTag stop;

    XaTagRangeFactory  & factory;
    CARD32 inUseMap[XaDefaultTagRangeSize / 32];
};

// The factory interface is used
// to keep track of TagRanges, and
// to allow the create to fail graceully
// when there are NO more tags available.
class XaTagRangeFactory {

    friend class XaTagRange;
    
public:
    
    XaTagRangeFactory(XaTag base, XaTag end,
		      CARD32 size = XaDefaultTagRangeSize);
    ~XaTagRangeFactory();

    CARD32 RangeSize() { return rangeSize; }

    XaErrorCode NewTagRange(XaTag & newTagRange);
    void ReleaseTagRange(XaTag);

private:
    CARD32 rangeSize;
    XaTagSet rangeReuse;
    XaTag currentBase;
    const XaTag base;
    const XaTag end;
    XaBoolean rangeOverFlow;

};

#endif
