/* $XConsortium: ringbuffer.h /main/8 1996/12/30 16:34:08 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

// XaRingBuffer -- requires that bitsPerSample/8 == 0

#ifndef __ringbuffer_h
#define __ringbuffer_h

#include <Xalib.h>
#include "intbuffer.h"
#include "xatime.h"

class XaRingBuffer  : public XaAudioBuffer
{

    friend class XaMixingConnector;

  private:
    // XaInternalBuffer *buffer;
    // XaTime _atTime;
    // XaTime _duration;
    // CARD32 _durationInBits;
    // CARD8 _leftPad;

    XaAtom direction;

    XaTime transferSize;
    XaTime latestTransferredSample;
    XaTime earliestTransferredSample;
    // XaTime volatileZoneSize;
    // Write volatile zone = [latestTransferredSample - currentSample]
    // Read volatile zone = [currentSample - earliestTransferredSample]
    XaTime earliestSample;   // oldest
    XaTime latestSample;     // newest
    XaTime latestSampleLimit;
    XaTime earliestSampleLimit;
    XaTime transferLimit;	// update must be scheduled before current
				// sample reaches this limit, i.e., min
				// samples left in ring buffer
    XaTime currentSample;
    XaTime zeroTime;	// Time at zero offset in the buffer
    XaTime bufSamples;	// Buffer size in samples

    XaBoolean doMixing;

    // These two are attributes of the Format, but we _must_ keep an
    // up-to-date copy of this info here because we use it repeatedly.
    // CARD32 numChannels;
    CARD32 bytesPerSample;  // = numChannels * bitsPerSample/8
    CARD32 bytesPerChannel; // = bitsPerSample/8
    XaFormatCache formatCache;
    CARD32   silenceValue;

    XaMixingBuffer *parentMixBuffer;

    void mix_sample(char *dest, char *src);

  public:
    XaRingBuffer(XaInternalBuffer *ib,
		XaTime atTime, XaTime duration,
		XaFormatCache fmtCache,
		XaAtom direction, CARD8 leftPad = 0);
    
    ~XaRingBuffer();

    // Access
    // XaInternalBuffer *InternalBuffer() { return buffer; }
    // XaTime AtTime() { return _atTime;}
    // CARD8 LeftPad() { return _leftPad; }
    XaTime Duration();
    CARD32 DurationInBits();

    char *SampleAddress(XaTime sample, CARD8 *leftPad);

    XaBoolean ReadyToTransfer()
    {
	return (Difference(latestSample, latestTransferredSample) 
			> transferSize);
    }
    XaBoolean ReadyToReceive()
    {
	return (Difference(earliestTransferredSample, earliestSample)
			    > transferSize);
    }
    XaTime SpaceAvailable()
    {
	XaTime max = 
	    (bufSamples - Difference(latestSample, latestTransferredSample));
	if (max > transferSize)
	    return transferSize;
	else
	    return max;
    }
    XaTime SampleLimit();

    XaErrorCode SetLatestSample(XaTime newLS);

    XaErrorCode Configure(XaTime size, CARD32 nChannels,
			CARD32 sWidth, XaAtom encoding,
			XaTime transferSize,
			XaTime sampleLimit,
			XaTime hardwareTransferLimit,
			XaTime currentSample = 0,
			XaMixingBuffer *parent = NULL);

    
    
    // Computation
    inline XaBoolean BeforeTime(XaTime at)
	{ return Before(at,  _atTime); }
    inline XaBoolean AfterTime(XaTime at)
	{ return After(at,  _atTime + _duration); }
    inline XaBoolean IncludesTime(XaTime at)
	{ return ( Between(_atTime, at, _atTime + _duration)); }

    // I/O
    XaErrorCode Write(XaTime atTime, XaTag refClock,
				XaBoolean preempt, char *buffer,
				XaTime samplesToWrite, XaTime *samplesWritten);
    XaErrorCode WriteTransfer(XaTime atTime, XaTag refTime,
				     char **buffer, XaTime samplesToTransfer,
				     XaTime *samplesTransferred);

    XaErrorCode Read(XaTime atTime, XaTag refTime,
			     char **buffer, XaTime samplesToRead,
			     XaTime *samplesRead);

    XaErrorCode ReadTransfer(XaTime atTime, XaTag refClock,
					XaBoolean preempt,
					char *buffer, XaTime samplesToTransfer, 
					XaTime *samplesTransferred);

    XaErrorCode Zero(XaTime atTime, 
		    XaTime samplesToWrite, XaTime *samplesWritten);


    XaErrorCode WriteSilence(XaTime atTime, XaTag refClock,
			    XaTime samplesToWrite, XaTime *samplesWritten);
};

#endif

