/* $XConsortium: port.cc /main/23 1996/12/30 16:33:53 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/*
   An XaPort is a conduit of data between a client and a device, or between
   two devices.
*/

#include "port.h"
#include "scheduler.h"
#include <Xa/atomdefs.h>
#include "class.h"
#include "connectors.h"

#ifdef DUMP_BITS
#include <fcntl.h>
#include <unistd.h>
#endif

//
// Temporarily declared as static members
// to set the default input/output buffers on a port.
XaTag XaPort::defaultInputBuffer = XaTnone;
XaTag XaPort::defaultOutputBuffer = XaTnone;

XaAttrInitRec XaPortAttrInit[] =
{
    { 
        XaNcontinuity,      	XaNbool,
                                XaValidBool,
                                (void *)XaTrue,
                                XaMODE_CSG
    },
    {
        XaNordered,         	XaNbool,
                                XaValidBool,
                                (void *)XaTrue,
                                XaMODE_CSG
    },
    { 
        XaNsyncPolicy,      	XaNtag,
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    {
        XaNoverflownAction, 	XaNtag,
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    {
        XaNunderflownAction,	XaNtag,
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    {
        XaNformat,          	XaNformat,
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    {
        XaNrun,         	XaNbool,
                                XaValidBool,
                                (void *)XaFalse,
                                XaMODE_CSG
    },
    {
        XaNinputTimestamp,	XaNint32,
                                XaValid,
                                (void *)0,
                                XaMODE_G
    },
    {
        XaNinputBufferTimestamp, XaNint32,
                                XaValid,
                                (void *)0,
                                XaMODE_G
    },
    {
        XaNoutputTimestamp,	XaNint32,
                                XaValid,
                                (void *)0,
                                XaMODE_G
    },
    {
        XaNoutputBufferTimestamp, XaNint32,
                                XaValid,
                                (void *)0,
                                XaMODE_G
    },
};

/* Private data we need when continuing a read/write */
struct RWTaskInfo
{
    XaPort   *thePort;
    XaInternalBuffer *theBuffer;
    XaTask   *thisTask;
    void     *startByte;
    CARD32   bitsToProcess;
    CARD8    leftPad;
    BOOL     reading;
    /* some other information later, such as how to tweak the server when done */
    RWTaskInfo(XaPort *p, XaInternalBuffer *b, XaTask *t,
	       void *start, CARD32 bits, CARD8 left, BOOL read)
	: thePort(p), theBuffer(b), thisTask(t), startByte(start),
          bitsToProcess(bits), leftPad(left), reading(read) {}
};

#define RW_TASK_DELAY_MSEC 100


#ifdef DEBUG
#include "config.h"

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".Port.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#endif /* DEBUG */





XaPort::XaPort(XaConnection *c, XaClass *cl,
	       XaTag objectTag, XaTag classTag,
	       XaTag nameTag) :
               XaBuffer (c, cl, objectTag, classTag, nameTag),
	       _lastAccessTime(0)
{
    inputBuffer = NULL;
    outputBuffer = NULL;

    inputTimeOffset = 0;
    outputTimeOffset = 0;
    lastTransferredSample = 0;

    inputTimeFactor = 1;
    outputTimeFactor = 1;

    format = NULL;
    firstOutputWritten = XaFalse;
    outputRunning = XaFalse;
    inputRunning = XaFalse;

}

XaPort::~XaPort(void)
{
    Drain();
}

XaTime XaPort::TranslateToPortTime(XaTime elementTime, XaTag refTime,
				    XaAtom direction)
{
    if (direction == XaAoutput)
	return ((XaTime)(elementTime - outputTimeOffset) * outputTimeFactor);
    else
	return ((XaTime)(elementTime - inputTimeOffset) * inputTimeFactor);
}

XaTime XaPort::TranslateToElementTime(XaTime portTime, XaTag refTime,
					XaAtom direction)
{
    if (direction == XaAoutput)
	return ((XaTime)(portTime / outputTimeFactor) + outputTimeOffset);
    else
	return ((XaTime)(portTime / inputTimeFactor) + inputTimeOffset);

}

// Pretty much just call the delegate.
XaErrorCode
XaPort::Read(XaTime atTime , XaTag refClock, XaInternalBuffer *&buffer,
	     CARD32 bitsToRead, CARD8 &leftPad, CARD32 &bitsRead,
	     XaTime &deviceTime)
{
    XaErrorCode err;

    buffer = NULL; // in case we fail

    XaTime atLocal = resolveToLocalTime(atTime, refClock);

    if( inputBuffer)
    {
	XaAudioBuffer *audBuf;
	err = readDelegate->Read(atTime, refClock, audBuf,
				 bitsToRead, leftPad, bitsRead, deviceTime);
	if (audBuf != NULL)
	{
	    buffer = audBuf->InternalBuffer();
	    buffer->Get();
	    delete audBuf;
	}
	_lastAccessTime = atLocal + bitsToTime(bitsRead);
    }
    else
    {
	// You can't read, haven't been connected to
	// something to read from.
	err = XaEFailure;
    }
    
    return err;
}

//
// Write stores into the local audioDataCltn and
// If an attempt is made to write into the "volatile zone"
// then do a "Write through" to the our outputBuffer.
// 
XaErrorCode
XaPort::Write(XaTime  atTime, XaTag refClock,
	      XaInternalBuffer &buffer,
	      CARD32 bitsToWrite, CARD8 leftPad,
	      CARD32 &bitsWritten, XaTime &deviceTime)
{
    

#ifdef DUMP_BITS

    static int dumpFd;

    if (!dumpFd)
	dumpFd = creat("PortWriteDump.dat", 0666);

    write(dumpFd, buffer.GetBuffer(), bitsToWrite/8);

#endif

    XaErrorCode e = XaESuccess;
    XaAudioBuffer *audBuf;

    if (!(outputBuffer && writeDelegate))
	return XaEServerInternal;


    // Resolve this time to port time.
    XaTime atLocal = resolveToLocalTime(atTime, refClock);
    XaTime duration = bitsToTime(bitsToWrite);
    XaTime volatileTime, volatileDuration;

    // XXXXX Compare this to the deviceTime and if it's completely too late,
    // XXXXX bag it and return NOW. (Do the buffer.Release();)
    // XXXXX Not sure how Port gets deviceTime.  (pderr)


    // Subsume the internal buffer into an XaAudioBuffer object.
    audBuf = new XaAudioBuffer(&buffer, atLocal, duration, bitsToWrite,
				leftPad, &formatCache);
    assert(audBuf != NULL);

    // Release a reference to the internal buffer; once the XaAudioBuffer
    // object goes away, so does the internal buffer.
    buffer.Release();

    // Check to see if we have to do the write through.
    if(inVolatileZone(atLocal, duration, XaAoutput,
			volatileTime, volatileDuration))
    {
	XaAudioBuffer *newBuf = NULL;

	CARD32 newBitsWritten = 0;
	bitsWritten = 0;
#ifdef DEBUG
	if (DoDebug())
	{
	printf("XaPort::Write in volatile zone.\n");
	printf(" time %d dur %d volTime %d volDuration %d lastTransSample %d\n",
		atLocal, duration, volatileTime, volatileDuration,
		lastTransferredSample);
	}
#endif
	// only write the size of the volatile zone
	// to the outputBuffer, and save the rest
	// in the local audioData collection.

	if (After(volatileTime, atLocal))
	{
	    // I don't believe this can ever happen. (pderr)
#ifdef DEBUG
	if (DoDebug())
	    printf("   first part is too late. Toss %d samples.\n",
		    volatileTime);
#endif
	    // The first part is too late.  Toss it.
	    newBuf = audBuf->Split(volatileTime, XaFalse);
	    bitsWritten += audBuf->DurationInBits();
	    delete audBuf;

	    audBuf = newBuf;
	    newBuf = NULL;
	    duration = audBuf->Duration();
	    atLocal = volatileTime;
	}

	assert(atLocal == volatileTime);

	if (duration > volatileDuration)
	{
	    // the last part is Before the volatile zone
	    newBuf = audBuf->Split(volatileDuration, XaTrue);
	}
	
	// Try to write directly to the transfer buffer.

	e = writeDelegate->Write(TranslateToElementTime(atLocal, refClock,
							XaAoutput),
				 XaAdeviceTime, *audBuf,
				 audBuf->DurationInBits(), leftPad,
				 newBitsWritten, deviceTime);
	// XXXX Now cache deviceTime somewhere??
#ifdef DEBUG
	if (DoDebug())
	    assert(e == XaESuccess);
#endif
	if (Before(lastTransferredSample, atLocal + audBuf->Duration()))
	    lastTransferredSample = atLocal + audBuf->Duration() - 1;
#ifdef DEBUG
	if (DoDebug())
	    printf("      lastTransferredSample = %d\n", lastTransferredSample);
#endif

	bitsWritten += newBitsWritten;

	// Put the remaining audio data into the port's queue, but only if
	// everything up to this point has been successfully written.

	if (e == XaESuccess && newBitsWritten == audBuf->DurationInBits()
		&& newBuf)
	{
	    e = audioData.insert(*newBuf);
	    if (e == XaESuccess)
		bitsWritten += newBuf->DurationInBits();
	}
	else if (newBuf)
	{
	    delete newBuf;
	}
	delete audBuf;
    }
    else // not writing to volatile zone, store data in port
    {
	// XXXX Perhaps we want to actually do this 
	// O.k. we're not there, so just store this.
	// in the buffer collection.

	bitsWritten = bitsToWrite;
	// XXXXX deviceTime = ?????
	e = audioData.insert(*audBuf);
    }

    _lastAccessTime = atLocal + bitsToTime(bitsWritten);
    
    return e;
}

// Write transfer moves data from
// the the port to the transfer buffer.
// If there is not enough data
// to write then we have an underflow condition.
XaErrorCode XaPort::WriteTransfer(XaTime atTime, XaAtom refTime,
				  CARD32 bitsToWrite, CARD32 &bitsWritten,
				  XaTime &deviceTime)
{
    // XXXXX  What coordinate system are these time values in?
    // 		Perhaps refTime tells us, and tells us if conversion is
    //		necessary. (pderr)
    XaTime atPortTime;

    // XXXX This seems like a hack, but it works for now.
    if (!firstOutputWritten)
    {
	firstOutputWritten = XaTrue;
	// outputTimeOffset = atTime;
    }


    atPortTime = TranslateToPortTime(atTime, refTime, XaAoutput);

    XaErrorCode e = XaESuccess;
    bitsWritten = 0; // in case we fail

    if (!OutputRunning())
    {
	if (refTime == XaAdeviceTime)
	    outputTimeOffset = atTime;
	else if (refTime == XaAlastAccessTime)
	    outputTimeOffset += atTime;	 // XXXX make sure this is right - pderr
    }

    // No bits to write == nothing to do
    if (bitsToWrite == 0)
    {
	return e;
    }
    
    // Get the data we need read.
    // XXXXX
    // This needs to be backed to pay attention
    // to the arguments, and do the correct number of
    // writes depending on the arguments.
    //
    // In other words:
    //
    //             If the bitsToWrite argument implies
    //             a time longer than the duration of the
    //             databuffer we just pulled out,
    //             then we get a another buffer
    //             from the collection, modify the bitsToWrite
    //             argument, based on bits written returned from
    //             the first write, and call write again
    //             with the new buffer.

    CARD32 bitsRemaining = bitsToWrite;
    XaTime currentTime = atPortTime;
    XaAudioBuffer *dataBuffer;
    XaBoolean endLoop = XaFalse;
    
    if (OutputRunning())
	do
	{
	    dataBuffer = audioData.remove(currentTime);
	    if (dataBuffer == NULL)
	    {
		/* Underflow policy kicks in here. */
		/* However, for now, we'll bail the loop. */
#ifdef DEBUG
	    if (DoDebug())
		printf("XaPort::WriteTransfer: null audio buffer for time %d\n",
			    currentTime);
#endif
	    }
	    else
	    {
#ifdef DEBUG
		if (DoDebug()) printf(
		"XaPort::WriteTransfer: at %d bitsRemaining %d thisChunkbits %d\n",
		currentTime, bitsRemaining, dataBuffer->DurationInBits());
#endif

		if (dataBuffer->DurationInBits() > bitsRemaining)
		{
		    // Split the audio buffer into two pieces,
		    // keeping only what was requested.
		    XaAudioBuffer *buf =
		       dataBuffer->Split(bitsRemaining/formatCache.bitsPerFrame,
					 XaTrue);
		    assert(buf != NULL);

		    // Put the remaining audio data back into the queue
		    // from the front.
		    audioData.insert(*buf);
		}

		CARD32 chunkBitsToWrite, chunkBitsWritten;
		CARD8  chunkLeftPad;

		chunkBitsToWrite = dataBuffer->DurationInBits();

		assert(chunkBitsToWrite <= bitsRemaining);

		chunkLeftPad = dataBuffer->LeftPad();
		    
		e = writeDelegate->Write(
			   TranslateToElementTime(currentTime, refTime, XaAoutput),
					 refTime,
					 *dataBuffer,
					 chunkBitsToWrite,
					 chunkLeftPad,
					 chunkBitsWritten, deviceTime);
		assert(e == XaESuccess);

		bitsWritten += chunkBitsWritten;

		// If (chunkBitsWritten != chunkBitsToWrite)
		// in writeDelegate->write, we save the unwritten data
		// for the next time we are called.
		if (chunkBitsWritten != chunkBitsToWrite)
		{
#ifdef DEBUG
		if (DoDebug())
		    assert(0==1); // should NEVER get here
#endif
		    // Split the data buffer so that we get
		    // the piece that we want to save.
		    XaAudioBuffer *leftoverBuf =
			dataBuffer->Split((chunkBitsToWrite - chunkBitsWritten)
						/ formatCache.bitsPerFrame,
					  XaTrue);
		    assert(leftoverBuf != NULL);

		    audioData.insert(*leftoverBuf);

		    // we don't want to reiterate this loop any more,
		    // because the transfer buffer has had enough.
		    endLoop = XaTrue;
		}
			
		bitsRemaining -= chunkBitsWritten;
		currentTime += bitsToTime(chunkBitsWritten);

		// Free up the audio data buffer that we no longer need.
		if (dataBuffer) delete dataBuffer;
	    }
	}
	while((bitsRemaining > 0) && (dataBuffer != NULL) && (endLoop != XaTrue));

    // NOTE: lastTransferredSample is updated whether or not the requested
    //       data was transferred.  This is necessary to know when a
    //	     write-through is needed or if we can wait for the next device 
    //	     update.

    currentTime = atPortTime + bitsToTime(bitsToWrite) - 1;

    if (After(currentTime, lastTransferredSample))
		lastTransferredSample = currentTime;

    // XXXXXX Update local copy and attribute of device time.
    return e;
}


// forces data up to us.
// Not the usual mode eh?
// We don't expect to use this, do we?

XaErrorCode XaPort::ReadTransfer(XaTime atTime, XaAtom refTime,
				 CARD32 bitsToWrite, CARD32 &bitsWritten,
				 XaTime &deviceTime) {
    // XXX UNIMPLEMENTED
    bitsWritten = 0;
    return XaEUnimplemented;
}


// XXXXX This needs to be fixed.
XaTime XaPort::resolveToLocalTime( XaTime atTime, XaTag refClock)
{
    XaTime result = atTime;
    
    // Most refClocks are relative, and simply require that
    // we add something to atTime to yield the correct timestamp.
    switch(refClock)
    {
    case XaAlastAccessTime:
	result += _lastAccessTime;
    case XaAearliestTime:
    case XaAlatestTime:
    default:
	// A clock we can't just handle on our own.
	// For now, do nothing.
	// XXX might we want to allow extensible clocks to process
	//     the time here?
	;
    }
    
    return result;
}

XaTime XaPort::bitsToTime( CARD32 durationInBits)
{
    return durationInBits/formatCache.bitsPerFrame;
} 

CARD32 XaPort::timeToBits(XaTime duration)
{
    return duration*formatCache.bitsPerFrame;
}

XaBoolean XaPort::inVolatileZone(XaTime atTime, XaTime duration,
				XaAtom direction,
				XaTime &volatileTime, XaTime &volatileDuration)
{
    XaTime sampleCutoff = lastTransferredSample;

    if (direction == XaAoutput)
    {
	// If the output is not running, it's not in the volatile zone.
	if (!OutputRunning())
	    return XaFalse;

	// The Connector's latest sample could be later than (after) the
	// Port's latest sample if the Port was previously unable to provide
	// requested data.

	XaTime connectorLS =
			  outputBuffer->GetConnectionDelegate()->LatestSample();
	connectorLS = TranslateToPortTime(connectorLS, XaAdeviceTime,
					    XaAoutput);
#ifdef DEBUG
	if (DoDebug())
	    printf(
	  "XaPort::inVolatileZone: atTime %d connectorLS: %d sampleCutoff %d\n",
		atTime, connectorLS, sampleCutoff);
#endif
	if (Before(sampleCutoff, connectorLS))
	{
	    sampleCutoff = connectorLS;
#ifdef DEBUG
	if (DoDebug())
	    printf("  new sampleCutoff %d\n", sampleCutoff);
#endif
	}

	// Increment sampleCutoff so that the lastTransferredSample is
	// included in the volatile zone.
	sampleCutoff ++;

	//
	// The volatile zone is any time that has been previously
	// transfered to the Device.
	//
	if (Before(atTime, sampleCutoff))
	{
	    volatileTime = atTime;
	    if (Before(atTime + duration, sampleCutoff))
		volatileDuration = duration;
	    else
		volatileDuration = Difference(sampleCutoff, volatileTime);
	    return XaTrue;
	}
	else
	{
	    return XaFalse;
	}
    }
    else
    {
	// XXXXX Read case not done right yet.
	//
	// The volatile zone is any time that has not yet been
	// transfered from the Device.
	//
	XaTime latestTime; // XXXXX Bogus!  This is an attribute!

	return After(atTime + duration, latestTime);
    }
}



// XXXXX WE HAVE A PROBLEM HERE WITH ERRORS NOT BEING RETURNABLE
// in a SET call. I have a feeling this won't fly.

// XXXX We are defaulting to flushing output on a disconnect
//      for this kind of buffer.
XaErrorCode XaPort::connectToNewElement(XaElement *newE,
			      XaElement *&oldE, XaTransferBuffer *&oldTB,
			      XaTime &deviceTime) {

    XaErrorCode e = XaESuccess;
    // Things that SHOULD NOT happen
    if( newE == NULL) {
	return XaEServerInternal;
    }

    // If there is an old element, we have to discconet from it.
    if( oldE) {
	e = oldE->Disconnect(this, *oldTB, XaTrue);
    }

    // Need a format to connect with, if this
    // hasn't been set we are going to have
    // a pretty big problem.
    if( (e == XaESuccess)&& format) {
	e = newE->Connect(this, format, oldTB);
	// XXX we need to set the format on the element as if we'd done
	// a call to formatSetCB on the element.  This shouldn't happen
	// here.
	/* Moved into XaElement::Connect()
	if (e == XaESuccess) {
	    XaAttributeCBData cbdata;
	    cbdata.name = XaAformat;
	    cbdata.value = format;
	    cbdata.type = XaAformat;
	    e = newE->SetAttribute(conn, &cbdata);
	}
	*/
    }

    if( e == XaESuccess) {
	oldE = newE;
	if (newE->_time_update_func)
	    deviceTime = (*newE->_time_update_func)();
	else
	    deviceTime = 0;
    }

    // XXXXX WE MAY NEED to "unreference" the
    // old Element here. 
    return e;
        
}
			      

//
// What does this do now?
// XXX NOTHING!?!
void XaPort::Drain(void) {
    if (outputBuffer) {
	XaAudioBuffer *dataBuffer = audioData.remove(0);
	while (dataBuffer) {
	    CARD32 bitsWritten;
	    XaTime deviceTime; // XXX what should device time be?
			       // XXXX  - it's a return parameter - pderr

	    // XXX why isnt there a short call which takes XaAudioBuffers
	    // XXXX This will NOT work with a MixingBuffer - pderr
	    writeDelegate->Write(0, XaAlastAccessTime,
				 *dataBuffer,
				 dataBuffer->DurationInBits(),
				 dataBuffer->LeftPad(),
				 bitsWritten, deviceTime);
	    dataBuffer = audioData.remove(0);
	}
	
    } else if (inputBuffer) {
    }
}


// XXXX By default we do "drain" our transfer buffers
//      on destroy. This may want an ATTRIBUTE eh?
XaErrorCode XaPort::XaPortDestroyCB(XaObject *obj) {
    
    //XXX Some cleanup goes here:
    //XXX   Nuke created objects
    //XXX   Remove from server's list of connections?????

    XaPort *port = (XaPort*)obj;
    XaErrorCode e = XaESuccess;

    // Disconnect the buffers.
    if(port->inputBuffer) {
	e = port->inputBuffer->Disconnect(port,
					  *port->readDelegate, XaFalse);
    }
    
    if(port->outputBuffer) {
	e = port->outputBuffer->Disconnect(port,
					   *port->writeDelegate,
					   XaFalse);
    }
    
    return e;
}

/* Buffer Set CB */
void XaPort::bufferSetCB(void *obj, XaAttributeCBData *cbd) {

    XaPort *port = (XaPort *)obj;
    XaTag   bufTag = (XaTag)(unsigned long)cbd->newValue;
    XaConnection  *conn = port->Conn();

    //
    // If this is one of the input/output buffers
    // then we have to do a connect on the object
    // that is being specified.
    //
    // XXXXXX Verify on this should be done.

    // Set the Input/Output buffer by
    // connecting to the appropriate element
    // with and changing the appropriate transferBuffer.
    XaElement *newElement;
    XaTime	deviceTime;
    if (cbd->name == XaAinputBuffers) {
	newElement = (XaElement *)conn->ObjectDB().find(bufTag);
	port->connectToNewElement(newElement, port->inputBuffer,
				port->readDelegate, port->inputTimeOffset);
    } else if (cbd->name == XaAoutputBuffers) {
	newElement = (XaElement *)conn->ObjectDB().find(bufTag);
	port->connectToNewElement(newElement, port->outputBuffer,
				port->writeDelegate, port->outputTimeOffset);
#ifdef DEBUG
	if (DoDebug())
	    printf("XaPort::bufferSetCB: outputConnectTime %d\n",
					    port->outputTimeOffset);
#endif
	port->firstOutputWritten = XaFalse;
    }

}

void XaPort::runSetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   runTag = (XaTag)(unsigned long)cbd->newValue;

    // If outputBuffer is set,
    // call the outputBuffer Start/Stop function
    // If inputBuffer is set,
    // call the inputBuffer Start/Stop function
    //
    if (port->outputBuffer)
    {
	if ((XaBoolean)(unsigned long)cbd->newValue == XaTrue)
	{
	    // NOTE: The order of these statements is critical.
	    port->outputTimeOffset = (port->outputBuffer)->_time_update_func();
	    // XXX fudge it to avoid missing the first few samples
	    // XXX need some heuristic to calc. this based on sample rate.
	    port->outputTimeOffset += port->formatCache.sampleRate/8;
	    port->outputRunning = XaTrue;
#ifdef DEBUG
	    if (DoDebug())
		printf("XaPort::runSetCB: outputTimeOffset %d\n",
			port->outputTimeOffset);
#endif
	    (port->outputBuffer)->Start(port->Tag());

	    // Check all chunks in the queue to see if they're in the
	    // volatile zone.

	    XaAudioBuffer *audBuf = port->audioData.First();
	    XaTime	volatileTime;
	    XaTime	volatileDuration;

	    while (audBuf && (port->inVolatileZone(audBuf->AtTime(),
					    audBuf->Duration(), XaAoutput,
					    volatileTime, volatileDuration)))
	    {
		XaAudioBuffer *nextBuf;
		XaAudioBuffer *newBuf = NULL;
		CARD32 bitsWritten = 0;
		XaErrorCode e;
		XaTime deviceTime;

		bitsWritten = 0;
		nextBuf = audBuf->Next();
		audBuf = port->audioData.remove(audBuf->AtTime());
#ifdef DEBUG
		if (DoDebug())
		{
		    assert(audBuf != NULL);
		    printf("XaPort::runSetCB in volatile zone.\n");
		    printf(
	       " time %d dur %d volTime %d volDuration %d lastTransSample %d\n",
			audBuf->AtTime(), audBuf->Duration(),
			volatileTime, volatileDuration,
			port->lastTransferredSample);
		}
#endif

		// only write the size of the volatile zone
		// to the outputBuffer, and save the rest
		// in the local audioData collection.

		if (After(volatileTime, audBuf->AtTime()))
		{
		    // I don't believe this can ever happen. (pderr)
#ifdef DEBUG
		    if (DoDebug())
			printf("   first part is too late. Toss %d samples.\n",
				volatileTime);
#endif
		    // The first part is too late.  Toss it.
		    newBuf = audBuf->Split(volatileTime, XaFalse);
		    bitsWritten += audBuf->DurationInBits();
		    delete audBuf;

		    audBuf = newBuf;
		    newBuf = NULL;
		}
#ifdef DEBUG
		if (DoDebug())
		    assert(audBuf->AtTime() == volatileTime);
#endif
		if (audBuf->Duration() > volatileDuration)
		{
		    // the last part is Before the volatile zone
		    newBuf = audBuf->Split(volatileDuration, XaTrue);
		}
		
		// Try to write directly to the transfer buffer.

		e = port->writeDelegate->Write(
			    port->TranslateToElementTime( audBuf->AtTime(),
							    XaAdeviceTime,
							    XaAoutput),
					 XaAdeviceTime, *audBuf,
					 audBuf->DurationInBits(),
					 audBuf->LeftPad(),
					 bitsWritten, deviceTime);
		// XXXX Now cache deviceTime somewhere??
#ifdef DEBUG
		if (DoDebug())
		{
		    assert(e == XaESuccess);
		    assert(bitsWritten == audBuf->DurationInBits());
		}
#endif
		if (Before(port->lastTransferredSample,
				audBuf->AtTime() + audBuf->Duration()))
		    port->lastTransferredSample
				= audBuf->AtTime() + audBuf->Duration() - 1;
#ifdef DEBUG
		if (DoDebug())
		    printf("      lastTransferredSample = %d\n",
			    port->lastTransferredSample);
#endif
		// Put the remaining audio data into the port's queue

		if (newBuf)
		    e = port->audioData.insert(*newBuf);
		
		delete audBuf;
		audBuf = nextBuf;
	    }
	}
	else
	{
	    (port->outputBuffer)->Stop(port->Tag());
	    port->outputRunning = XaFalse;
	}
    }
    else if (port->inputBuffer)
    {
	if ((XaBoolean)(unsigned long)cbd->newValue == XaTrue)
	{
	    port->inputTimeOffset = (port->inputBuffer)->_time_update_func();
	    (port->inputBuffer)->Start(port->Tag());
	    port->inputRunning = XaTrue;
	}
	else
	{
	    (port->inputBuffer)->Stop(port->Tag());
	    port->inputRunning = XaFalse;
	}
    }
}


/* Format Set CB */
void 
XaPort::formatSetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   fmtTag = (XaTag)(unsigned long)cbd->newValue;
    XaConnection  *conn = port->Conn();
    
    // update our notion of the format.
    port->format = (XaFormat *)conn->ObjectDB().find(fmtTag);

    // If outputBuffer is set,
    // set format on the output buffer.
    // If inputBuffer is set,
    // set format on the input buffer.
    //
    if (port->outputBuffer)
    {
      cbd->name = XaAformat;
      cbd->value = port->format;
      (port->outputBuffer)->SetAttribute(conn, cbd);
    }
    else if (port->inputBuffer)
    {
      cbd->name = XaAformat;
      cbd->value = port->format;
      (port->inputBuffer)->SetAttribute(conn, cbd);
    }
    port->CacheFormat(port->format);
}

void XaPort::inputTimestampGetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   tag = (XaTag)(unsigned long)cbd->newValue;

    if (port->inputBuffer && port->inputBuffer->_time_update_func)
    {
	cbd->newValue = (void *)port->TranslateToPortTime(
				    (*port->inputBuffer->_time_update_func)(),
				    XaAdeviceTime, XaAinput);
    }
    else
    {
	cbd->newValue = (void *)port->LatestSample();
    }
}
void XaPort::inputBufferTimestampGetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   runTag = (XaTag)(unsigned long)cbd->newValue;

    if (port->inputBuffer && port->inputBuffer->_time_update_func)
    {
	cbd->newValue = (void *)(*port->inputBuffer->_time_update_func)();
    }
    else
    {
	cbd->newValue = (void *)port->LatestSample();
    }
}
void XaPort::outputTimestampGetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   runTag = (XaTag)(unsigned long)cbd->newValue;

    if (port->outputBuffer && port->outputBuffer->_time_update_func)
    {
	cbd->newValue = (void *)port->TranslateToPortTime(
				    (*port->outputBuffer->_time_update_func)(),
				    XaAdeviceTime, XaAoutput);
    }
    else
    {
	cbd->newValue = (void *)port->EarliestSample();
    }
}
void XaPort::outputBufferTimestampGetCB(void *obj, XaAttributeCBData *cbd)
{
    XaPort *port = (XaPort *)obj;
    XaTag   runTag = (XaTag)(unsigned long)cbd->newValue;

    if (port->inputBuffer && port->inputBuffer->_time_update_func)
    {
	cbd->newValue = (void *)(*port->inputBuffer->_time_update_func)();
    }
    else
    {
	cbd->newValue = (void *)port->EarliestSample();
    }
}

XaErrorCode XaPort::XaPortCreateCB (XaObject *obj, XaAttributeCBData *data,
				    CARD32 count)
{
    
    XaPort            *port = (XaPort *)obj;
    XaConnection      *connection = port->Conn();

    //
    // first setup all the callbacks
    // 

    XaAttribute * outputBuffer = port->AtomToAttribute(XaAoutputBuffers);
    assert(outputBuffer != NULL);
    outputBuffer->Set(port->bufferSetCB);
    
    XaAttribute * inputBuffer = port->AtomToAttribute(XaAinputBuffers);
    assert(inputBuffer != NULL);
    inputBuffer->Set(port->bufferSetCB);
    
    XaAttribute * format = port->AtomToAttribute(XaAformat);
    assert(format != NULL);
    format->Set(port->formatSetCB);

    // Run Attribute CB
    XaAttribute * runAttr = port->AtomToAttribute(XaArun);
    if (runAttr)
    {
      // Set up Set Callback for XaAFormat
      runAttr->Set(port->runSetCB);
    }

    XaAttribute * tsAttr;

    // inputTimestamp Attribute Get CB
    tsAttr = port->AtomToAttribute(XaAinputTimestamp);
    if (tsAttr)
    {
      // Set up Get Callback for XaAinputTimestamp
      tsAttr->Get(port->inputTimestampGetCB);
    }
    // inputBufferTimestamp Attribute Get CB
    tsAttr = port->AtomToAttribute(XaAinputBufferTimestamp);
    if (tsAttr)
    {
      // Set up Get Callback for XaAinputBufferTimestamp
      tsAttr->Get(port->inputBufferTimestampGetCB);
    }
    // outputTimestamp Attribute Get CB
    tsAttr = port->AtomToAttribute(XaAoutputTimestamp);
    if (tsAttr)
    {
      // Set up Get Callback for XaAoutputTimestamp
      tsAttr->Get(port->outputTimestampGetCB);
    }
    // outputBufferTimestamp Attribute Get CB
    tsAttr = port->AtomToAttribute(XaAoutputBufferTimestamp);
    if (tsAttr)
    {
      // Set up Get Callback for XaAoutputBufferTimestamp
      tsAttr->Get(port->outputBufferTimestampGetCB);
    }

    // pass our creation arguments on to the normal SetAttributes call
    if (count > 0) {
	XaErrorCode err = port->SetAttributes(port->Conn(), data, count);
	if (err != XaESuccess)
	    return err;
    }
    
    //
    // Set up Output buffer
    //
    if (XaPort::defaultOutputBuffer != XaTnone &&
	outputBuffer != NULL &&
	(outputBuffer->Value() != NULL)) {
	if ((XaTag)(unsigned long)outputBuffer->Value() == XaTdefault) {
	    XaAttributeCBData cbdata;
	    cbdata.name = XaAoutputBuffers;
	    cbdata.type = XaTtag;
	    // get from classAttributes later
	    cbdata.value = (void *)XaPort::defaultOutputBuffer; // devicetag
	    XaErrorCode err = port->SetAttribute(connection, &cbdata);
	    if (err != XaESuccess)
	        return XaEFailure;
	    if (port->outputBuffer == NULL)
	        return XaEFailure;
	}
    }

    //
    // Input Buffer
    //
    if (XaPort::defaultInputBuffer != XaTnone &&
	inputBuffer != NULL &&
	(inputBuffer->Value() != XaTnone)) {
	if ((XaTag)(unsigned long)inputBuffer->Value() == XaTdefault) {
	    XaAttributeCBData cbdata;
	    cbdata.name = XaAinputBuffers;
	    cbdata.type = XaTtag;
	    // get from classAttributes later
	    cbdata.value = (void *)XaPort::defaultInputBuffer; 
	    XaErrorCode err = port->SetAttribute(connection, &cbdata);
	    if (err != XaESuccess)
	        return XaEFailure;
	    if (port->inputBuffer == NULL)
	        return XaEFailure;
	}
    }

    return XaESuccess;
}

void *PortClassCreate(void *conn, void *c, XaTag t1, XaTag t2, XaTag t3)
{

    return (void*) new XaPort((XaConnection*)conn, (XaClass*)c,
			      t1, t2, t3);
}

XaClassInitRec XaPortClassInit =
{
    XaNdevice, XaNbuffer,
    PortClassCreate, // pointer to constructor that takes XaBuffer constructor args.
    XaNumber(XaPortAttrInit),
//  XaNumber (XaPortClassAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XaPort::XaPortCreateCB, XA_NULL, XA_NULL, XA_NULL, XaPort::XaPortDestroyCB
};

XaErrorCode XaCreateClassPort(XaConnection *conn)
{
    return (new XaClass(conn, XaAport,
	    &XaPortClassInit, XaPortAttrInit)) ? XaESuccess : XaEFailure;
}

