/* $XConsortium: key.cc /main/3 1996/12/30 16:33:49 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
** Key class definition
*/

#include "class.h"

#ifdef USE_XKEY						// XXX Not there yet!
#include ?????
#endif /* USE_XKEY */

#define BABBLE(x) printf(x)

static XaClassCreateFunc	XaKeyCreateCB;
static XaClassDestroyFunc	XaKeyDestroyCB;
static XaTypeCheckFunc	XaValidAuthName;

XaAttrInitRec XaKeyAttrInit[] =
{
    {
	XaNauthName,		XaNtag,
				XaValidAuthName,
				(void *)0,
				XaMODE_M | XaMODE_C
    },
    {
	XaNauthData,		XaNcard32,
				XaValid,
				(void *)0,
				XaMODE_M | XaMODE_C | XaMODE_G
    },
    {
	XaNactive,		XaNbool,
				XaValidBool,
				(void *)XaTrue,
				XaMODE_CSG
    },
    {
	XaNtrusted,		XaNbool,
				XaValidBool,
				(void *)XaTrue,
				XaMODE_C | XaMODE_G
    }
};

XaClassInitRec XaKeyClassInit =
{
    XaNkey, XaNobject,
    XA_NULL,
    XaNumber(XaKeyAttrInit),
    XaMODE_CSG, XaMODE_NONE,
    XaKeyCreateCB, XA_NULL, XA_NULL, XA_NULL, XaKeyDestroyCB
};

/*
** Collection of Valid Auth Names
*/
XaEnumerated XaAuthNames;
static XaBoolean XaValidAuthName(XaObject *obj, void *name) 
{ return XaAuthNames.Valid((XaAtom)(unsigned long)name); }

/* 
** Key class creation 
*/
XaErrorCode XaCreateClassKey(XaConnection *conn)
{
    // XXX Valid encodings should be initialized by the connection access code
    return (new XaClass(conn, XaAkey, &XaKeyClassInit, XaKeyAttrInit)) ? 
	    XaESuccess : XaEFailure;
}

/* ----------------------------------------------------------
** Key behavior
*/

/* Set callback for active attribute */
void
static XaKeySetActiveCB(void *vobject, XaAttributeCBData *data)
{
    BABBLE("Key Set CB\n");

    XaObject *obj = (XaObject *)vobject;
#ifdef USE_XKEY
    void *trusted;
#endif /* USE_XKEY */

    // if the active state has changed, add or remove the key
    if (!(XaBoolean)(unsigned long)(data->value) 
	    != !(XaBoolean)(unsigned long)(data->newValue))
    {
	if ((XaBoolean)(unsigned long)(data->newValue))
	{
	    BABBLE("	Adding Key\n");
#ifdef USE_XKEY
	    // XXX get attributes for call
	    XaAddAuthorization((XaBoolean)trusted, authNameLength, authName, 
		    authDataLength, authData, obj->Tag());
	    // XXX should check return status
#endif /* USE_XKEY */
	}
	else
	{
	    BABBLE("	Removing Key\n");
#ifdef USE_XKEY
    	    XaAttributeCBData data = 
	      { XaAtrusted, XaTbool, (void *)XaFalse, (void *)XaTrue};
	    if (obj->GetAttribute(obj->Conn(), &data) == XaESuccess)
	      XaRemoveAuthorization((XaBoolean)trusted, obj->Tag());
#endif /* USE_XKEY */
	}
    }
}

/* create callback */
static XaErrorCode XaKeyCreateCB(XaObject *obj, XaAttributeCBData * data,
				 CARD32 count)
{
    BABBLE("Key Create CB\n");

    // add callback for setting active field
    obj->AttributeSetCB(XaAactive, XaKeySetActiveCB);

    // initialize state of implementation to match that of the object.
    void *value;
    XaAttributeCBData cbdata = 
	    { XaAactive, XaTbool, (void *)XaFalse, (void *)XaTrue};
    if (obj->GetAttribute(obj->Conn(), &cbdata) != XaESuccess)
      return XaEFailure;
    else
      XaKeySetActiveCB((void *)obj, &cbdata);


    // XXX Add key to server object''s list of keys

    return XaESuccess;
}

/* Destroy callback */
static XaErrorCode XaKeyDestroyCB(XaObject *obj)
{
    BABBLE("Key Destroy CB\n");

    // disable key, if needed
    void *value;
    XaAttributeCBData data = 
	    { XaAactive, XaTbool, (void *)XaTrue, (void *)XaFalse};
    if (obj->GetAttribute(obj->Conn(), &data) != XaESuccess)
      return XaEFailure;
    else
      XaKeySetActiveCB((void *)obj, &data);

    // XXX remove key from server object''s list of keys
    return XaESuccess;
}
