/* $XConsortium: intbuffer.cc /main/16 1996/12/30 16:33:38 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#include "intbuffer.h"
#include <Xa/Xalib.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef DEBUG
#include "config.h"

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".InternalBuffer.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#define CHECK_INVARIANTS

#endif /* DEBUG */


XaInternalBuffer::XaInternalBuffer(CARD32 bSize, void *bufPtr)
    : bufSize(bSize), buf(bufPtr)
{
    if (buf == NULL)
    {
	buf = malloc(bufSize);
	freeOnDestroy = XaTrue;
    }
    else
	freeOnDestroy = XaFalse;
    assert(buf != NULL);
    refCount = 1;
}

XaInternalBuffer::~XaInternalBuffer(void)
{
    if (freeOnDestroy == XaTrue)
	free(buf);
}


/*
 * Audio Buffer
 * The thing that we pass audio bits around in.
 *
*/

XaAudioBuffer::XaAudioBuffer(XaInternalBuffer *ib,
			     XaTime atTime, XaTime duration,
			     CARD32 offset, CARD32 noOfBits, CARD8 leftPad,
			     XaFormatCache *formatCache)
    : buffer(ib), _intBufferOffset(offset),
      _atTime(atTime), _duration(duration),
      _leftPad(leftPad), _durationInBits(noOfBits),
      _formatCache(formatCache)
{
    
    // Grab a reference to the buffer.
    buffer->Get();
}

XaAudioBuffer::XaAudioBuffer(XaInternalBuffer *ib,
			     XaTime atTime, XaTime duration,
			     CARD32 noOfBits, CARD8 leftPad,
			     XaFormatCache *formatCache)
    : buffer(ib), _intBufferOffset(0),
      _atTime(atTime), _duration(duration),
      _leftPad(leftPad), _durationInBits(noOfBits), next(NULL), prev(NULL),
      _formatCache(formatCache)
{
    
    // Grab a reference to the buffer.
    buffer->Get();
}

XaAudioBuffer::~XaAudioBuffer()
{
    if (buffer != NULL)
    {
	// We're done.
        buffer->Release();
    }
}

XaAudioBuffer *
XaAudioBuffer::Split(XaTime newBufStartTime, XaBoolean relative)
{
    XaTime newBufTime = (relative == XaTrue ? _atTime + newBufStartTime
			 : newBufStartTime);
    XaTime newDuration = _duration - (newBufTime - _atTime);

    CARD32 newLength = (newDuration * _formatCache->bitsPerFrame);
    CARD32 newOffset = _intBufferOffset
		+ ((_duration - newDuration) * _formatCache->bitsPerFrame/8);

    XaAudioBuffer *newBuf = NULL;

#ifdef DEBUG
    if (DoDebug())
    {
	printf(
	  "Splitting buffer: tm %ld, off %ld, dur %ld, len %ld, pad %d into:\n",
	   AtTime(), GetIntBufferOffset(), Duration(), DurationInBits(),
	   LeftPad());
	printf("\tFirst buffer: tm %ld, off %ld, dur %ld, len %ld, pad %d\n",
	       AtTime(), GetIntBufferOffset(), _duration - newDuration,
	       _durationInBits - newLength, LeftPad());
	printf("\tSecond buffer: tm %ld, off %ld, dur %ld, len %ld, pad %d\n",
	       newBufTime, newOffset, newDuration, newLength, _leftPad);
	fflush(stdout);
    }
#endif
    
    if (newLength > 0)
    {
	newBuf = new XaAudioBuffer(InternalBuffer(), newBufTime,
				   newDuration, newOffset, newLength,
				   _leftPad, _formatCache);
	assert(newBuf != NULL);
    }

    _durationInBits -= newLength;
    _duration -= newDuration;

    return newBuf;
}

/*
 * AudioBuffer Collection
 *
*/ 


// constructor
XaAudioBufferCltn::XaAudioBufferCltn() : first(NULL), last(NULL), entries(0)
{
#ifdef CHECK_INVARIANTS
    Invariant();
#endif
}

XaAudioBufferCltn::~XaAudioBufferCltn()
{
    XaAudioBuffer *next;
    XaAudioBuffer *current;

    next = first;

    // XXX shouldn't be necessary, but avoids seg faults (pderr)
    if (entries == 0)
	return;

    while (next)
    {
	current = next;
	next = current->next;
	delete current;
    }
}

// Keep this in order sorted by atTime.
// last points to the largest (newest) atTime,
// first points to the smallest atTime (oldest).
//
//        
XaErrorCode XaAudioBufferCltn::insert(XaAudioBuffer &ab)
{
    XaErrorCode e = XaESuccess; // presume that we succeed

    // First entry
    if(first == NULL || entries == 0) // XXX entries test shouldn't be needed
				      // XXX but it avoids seg faults (pderr)
    {
	first = &ab;
	last = &ab;
	ab.next = NULL;
	ab.prev = NULL;
    }
    // Try both sides of the list first
    // cause we think that is the most likely case.
    // XXX the use of AfterTime and BeforeTime are ambiguous,
    //     need more explanation -- mw 6/96
    else if( last->AfterTime(ab._atTime))
    {
	ab.prev = last;
	ab.next = NULL;
	last->next = &ab;
	last = &ab;
    }
    else if( first->BeforeTime(ab._atTime))
    {
	ab.next = first;
	ab.prev = NULL;
	first->prev = &ab;
	first = &ab;
    }
    else
    {
	// find the right spot.
	XaAudioBuffer *curr;
	for (curr=last->prev; curr != NULL; curr = curr->prev)
	{
	    if(curr->AfterTime(ab._atTime)
		&& (!curr->IncludesTime(ab._atTime)))
	    {
		// Insert after curr.
                ab.prev = curr;
                ab.next = curr->next;
                ab.prev->next = ab.next->prev = &ab;
		break;
	    }
	}

	// This happens if we try and insert at a time
	// that already existed. BAD DOG. *BAD* DOG.
	if( curr == NULL)
	{
	    e = XaEValue;
#ifdef DEBUG
	if (DoDebug())
	    assert (0==1);
#endif
	}
    }

    // If we successfully inserted the chunk, bump up the number of entries.
    if (e == XaESuccess)
	entries++;

#ifdef CHECK_INVARIANTS
    Invariant();
#endif
    
    return e;
}

// 
// Assume we'll be removing from the
// front mostly, so make that the cheapest.
XaAudioBuffer *XaAudioBufferCltn::remove(XaTime at) {

    XaAudioBuffer *returnValue = NULL;

    if(entries == 0)
    {
#ifdef CHECK_INVARIANTS
	Invariant();
#endif
	return NULL;
    }

    // XXX tkr the timestamp of all our packets will be 0 so
    // we just remove from the front until that is fixed.
//     if (first != NULL)
//     {
// 	returnValue = first;
// 	first = first->next;
// 	if (first)
// 	    first->prev = NULL;
// 	return returnValue;
//     }
//     else return NULL;

    /*
      The way the list is structured:
      first: the earliest audio chunk in the list
      last: the latest audio chunk in the list
      next: points to an audio chunk *later* than (this)
      prev: points to an audio chunk *earlier* than (this)
    */
    
    
    // Check first, then last, the search.
    if( first->IncludesTime(at))
    {
	returnValue = first;
	first = first->next;

	if (first != NULL)
	    first->prev = NULL;
	else
	    last = NULL;
    }
    else if( last->IncludesTime(at))
    {
	returnValue =  last;
	last = last->prev;
	if (last)
	    last->next = NULL;
	else
	    first = NULL;
    }
    else
    {
	// Start at the front and move backwards.
	for( XaAudioBuffer *curr = first;
	    (returnValue == NULL) && (curr != NULL) && (curr->next != NULL);
	    curr = curr->next)
	{
	    if( curr->next->IncludesTime(at))
	    {
		returnValue = curr->next;
		break;
	    }
	}

	if (returnValue)
	{
	    if (returnValue->next)
	        returnValue->next->prev = returnValue->prev;
	    if (returnValue->prev)
		returnValue->prev->next = returnValue->next;
	}
    }

    // Remove the entry.
    if( returnValue != NULL)
    {
	entries--;
    }

    // XXX another prophylactic that shouldn't be needed but is... (pderr)
    if (entries == 0)
    {
	first = NULL;
	last = NULL;
    }

#ifdef CHECK_INVARIANTS
    Invariant();
#endif

    return returnValue;
}

void
XaAudioBufferCltn::Invariant(void) const
{
    // If we have 0 entries, make sure the pointers are null.
    if (entries == 0)
    {
    	assert((first == NULL) && (last == NULL));
    }
    else
    {
    	// We have entries. First, make sure that both
    	// first and last are populated.
    	assert((first != NULL) && (last != NULL));

    	// Traverse the chunk list. Count up the number of chunks
    	// and verify the time relationship between adjacent chunks.
    	XaAudioBuffer *curr, *prev;
    	int nEntries;
    	for(curr = first, nEntries = 0; curr != NULL;
    	    curr = curr->next, nEntries++)
    	{
    	    // Each iteration, make sure that the current block represents 
    	    // an earlier chunk of time than the one following it.
    	    if (curr->next != NULL)
    	    {
    	    	assert(curr->AfterTime(curr->next->_atTime) == XaTrue);
    	    	assert(curr->IncludesTime(curr->next->_atTime) == XaFalse);
    	    }
    	    prev = curr;
    	}

    	// Make sure that (last) is pointing to the right chunk.
    	assert(last == prev);

    	// Make sure the number of entries we counted is the same as
    	// what the collection expects.
    	assert(nEntries == entries);
    }
}

