/* $XConsortium: element.h /main/6 1996/12/30 16:33:34 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __element_h
#define __element_h


#include "buffer.h"
#include "dictionary.h"
#include "cdevice.h"

class XaConnector;
class XaConnection;
class XaClass;
class XaPassThroughConnector;
class XaMixingConnector;

// An Element delegates is connectablity
// to another object (an XaConnector).


class XaElement : public XaBuffer {

protected:

    XaElement(XaConnection *cn, XaClass *cl,
	      XaTag ot, XaTag ct, XaTag nt)
	: XaBuffer(cn, cl, ot, ct, nt), connectorDelegate(NULL) {}

    virtual ~XaElement() {};
    
    XaConnector *connectorDelegate;
    
    // TransferBuffers by Port.
    XaDictionary connections;


    // XXX These are needed by subclasses of connector
    // Should put an interface for them on
    // connector it'self.
    
public:
    // Element Callbacks
    DeviceDisconnectFunc _disconnect_func;
    DeviceTimeUpdateFunc  _time_update_func;


    // XXX is this needed?
    // XaTime latestTransferredSample;
    // XaTime latestSample;
    
public:

    // XXXX Does Connect need to keep track of transferBuffers?
    virtual XaErrorCode Connect(XaPort *port, XaFormat *data_format, 
				XaTransferBuffer *&transferBuffer);

    virtual XaErrorCode Disconnect(XaPort * port,
				   XaTransferBuffer &transferBuffer,
				   XaBoolean flush);

    virtual XaErrorCode Start(XaTag port) { return XaEUnimplemented; }

    virtual XaErrorCode Stop(XaTag port) { return XaEUnimplemented; }


    // Tansfer between Ports and Elements
    virtual XaErrorCode GetData(XaTime minTime, XaTime maxTime,
				XaTime &startTime, XaTime &endTime);

    virtual XaErrorCode PutData(XaTime minTime, XaTime maxTime,
			       XaTime &startTime, XaTime &endTime);
    
    // Access methods.
    void SetConnectionDelegate(XaConnector &del);
    
    inline XaConnector *GetConnectionDelegate() {
	return connectorDelegate;
    }

    virtual XaTime LatestSample()
    {
	return (*_time_update_func)();
    }


};
#endif




