/* $XConsortium: device.h /main/7 1996/12/30 16:33:23 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __device_h
#define __device_h

#include "cdevice.h"
#include "element.h"
#include "scheduler.h"


class XaConnector;

class XaDevice : public XaElement {
    
  public:

    XaDevice(const char *libraryName = NULL);
    XaDevice(XaConnection *, XaClass *, XaTag, XaTag, XaTag);

    ~XaDevice();

    //
    // Dynamically loads in the libraryName passed into the constructor or
    // this call.  If libraryName pass both times, it will
    // use this libraryName.  If the symbol has already been loaded, it
    // will not do it again.  After loading, it calls the device init function.
    //
    XaErrorCode init(const char *libraryName = NULL, XaBoolean write = True);



    XaErrorCode Connect(XaPort *port, XaFormat *data_format,
			  XaTransferBuffer *&transferBuffer);

    // Calls init() and opens the device.
    // For now, mode can be either O_WRONLY, O_RDONLY, O_RDWR.
    //
    // XXX This should probably be removed, functionality included in Init or
    // XXX Connect  (pderr)
    XaErrorCode Open(int mode);

    // This should probably be removed, functionality included in Shutdown or
    // Disconnect  (pderr)
    XaErrorCode Close();

    XaErrorCode reset();

    XaErrorCode drain();

    XaErrorCode Start(XaTag port);

    XaErrorCode Stop(XaTag port);

    XaErrorCode RingBufConfigure(char **buf, XaTime length,
				CARD32 nChannels, CARD32 sWidth,
				XaTime transSize, XaTime sampleLimit,
				XaTime hardwareTransferLimit,
				XaTime currentSample);

    // Connector methods to be delegated.
    XaErrorCode PutData(XaTime minTime, XaTime maxTime,
				XaTime *startTime, XaTime *endTime);

    // Don't think we need this, use the one from XaElement instead
    // XaErrorCode GetData(XaTime minTime, XaTime maxTime,
    //				XaTime &startTime, XaTime &endTime);

    static void Update(XaTask *task, void *taskInfo);


    // configuration
    XaErrorCode RingBufConfigure(XaTime size, XaTime transferSize,
				XaTime sampleLimit,
				XaTime hardwareTransferLimit,
				XaTime currentSample = 0);


    // Calculate the next update time based on buffer parameters
    XaErrorCode NextUpdateTime(XaWallTime& nextTime);

    XaErrorCode WriteTransfer(void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char **buf, CARD32 samplesToRead,
			    CARD32 *samplesRead, XaTime deviceTime);

    static XaErrorCode CreateCB (XaObject *obj, XaAttributeCBData * data, CARD32 count);

    // The device specific read/write functions.
    // Can't make these private because the C interface funcs needs
    // to access them
    //
    DeviceOpenFunc    _open_func;
    DeviceReadFunc    _read_func;
    DeviceWriteFunc   _write_func;
    DeviceResetFunc   _reset_func;
    DeviceDrainFunc   _drain_func;
    DeviceCloseFunc   _close_func;
    // DeviceTimeUpdateFunc  _time_update_func;


  private:

    char            *_libName;	    // .so file name
    DeviceInitFunc   _initFunc;     // pointer to init function
    XaBoolean        _initialized;  // device has been initialized
    XaBoolean        running;	    // device updates are scheduled
    
    XaAtom	     direction;     // really an attribute, cached here for
				    // easy reference (not allowed to 
				    // change once set)
    
    // Buffer pointers.
    XaTime          lastTransferTime; // really an attribute, cached here.
    XaTime          transferSize;   // really an attribute, cached here.

    XaTimedTask updateTask;
    XaWallTime	lastUpdateTime;	// wall time
    XaWallTime	nextUpdateTime;	// wall time

};
#endif

