/* $XConsortium: device.cc /main/16 1996/12/30 16:33:18 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#include <string.h>
#include <stdlib.h>

#include "device.h"
#include "object.h"
#include "class.h"

#include "connectors.h"
#include "port.h"


#include "connectors.h"
#include "port.h"

#include "xasymlib.h"
#include "xadefines.h"
#include "dictionary.h"
#include "errors.h"

#define DEV_DEFAULT_GAIN   50
#define DEV_DEFAULT_VTIME  1
#define DEV_DEFAULT_SIZE   1


static XaAttrInitRec XaDeviceAttrInit[] =
{
    {
        XaNavailableFormats,  	XaNformat, // need some kind of array or collection,
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_G
    },
    { 
        XaNgain,          	XaNcard32,
                                XaValid,
                                (void *)DEV_DEFAULT_GAIN,
                                XaMODE_CSG
    },
    {
        XaNvolatileTime,  	XaNcard32,
                                XaValid,
                                (void *)DEV_DEFAULT_VTIME,
                                XaMODE_CSG
    },
    {
        XaNvolatileSize,  	XaNcard32,
                                XaValid,
                                (void *)DEV_DEFAULT_SIZE,
                                XaMODE_CSG
    },
    {
        XaNdeviceTime,  	XaNint32,
                                XaValid,
                                (void *)0,
                                XaMODE_G
    }
};

//
// C Interface to Set device specific functions.
//

// To set the open device function from a c-language device module:
extern "C" {
	void SetDeviceOpenFunc(void *object, DeviceOpenFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_open_func = myFunc;
	}		
}

// To set the read device function from a c-language device module:
extern "C" {
	void SetDeviceReadFunc(void *object, DeviceReadFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_read_func = myFunc;
	}		
}

// To set the write device function from a c-language device module:
extern "C" {
	void SetDeviceWriteFunc(void *object, DeviceWriteFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_write_func = myFunc;
	}		
}

// To set the reset device function from a c-language device module:
extern "C" {
	void SetDeviceResetFunc(void *object, DeviceResetFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_reset_func = myFunc;
	}		
}

// To set the drain device function from a c-language device module:
extern "C" {
	void SetDeviceDrainFunc(void *object, DeviceDrainFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_drain_func = myFunc;
	}		
}

// To set the close device function from a c-language device module:
extern "C" {
	void SetDeviceCloseFunc(void *object, DeviceCloseFunc myFunc) {
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_close_func = myFunc;
	}		
}

// To set the time update device function from a c-language device module:
extern "C" {
	void SetDeviceUpdateTimeFunc(void *object, DeviceTimeUpdateFunc myFunc)
	{
		XaDevice *thisDevice = (XaDevice*)object;
		thisDevice->_time_update_func = myFunc;
	}		
}


XaDevice::XaDevice(const char *libraryName) 
    : XaElement (0, 0, 0, 0, 0), // XXX XaObject bad params
    _read_func(NULL), _write_func(NULL), _reset_func(NULL), 
    _drain_func(NULL), _open_func(NULL), _initFunc(NULL), 
    _close_func(NULL), _initialized(XaFalse), running(False),
    updateTask(Update, (void *)this, lastUpdateTime)

{
    _libName = NULL;
    if (libraryName)
      _libName = strdup(libraryName);
}

XaDevice::XaDevice(XaConnection *c, XaClass *cl, XaTag t1, XaTag t2, XaTag t3) 
    : XaElement (c, cl, t1, t2, t3),
    _read_func(NULL), _write_func(NULL), _reset_func(NULL), 
    _drain_func(NULL), _open_func(NULL), _initFunc(NULL), 
    _close_func(NULL), _initialized(XaFalse), running(False),
    updateTask(Update, (void *)this, lastUpdateTime),
    _libName(NULL)
{

    // 	default initial format values
    formatCache.sampleRate = 8000;
    formatCache.sampleWidth = 8;
    formatCache.numChannels = 1;
    formatCache.bitsPerFrame = 8;
    formatCache.encoding = XaAencodeUlaw;
}

XaDevice::~XaDevice()
{
    if (_libName) {
      free (_libName);
      _libName = NULL;
    }
}

/*
 * Update the device time (I think -- mw).
 */
static struct timeval
device_update_func()
{
    struct timeval tv = {0, 0};
    return tv;
}

XaErrorCode 
XaDevice::init(const char *libraryName, XaBoolean write) 
{
    XaErrorCode  error;
    int		 status;
    XaAttributeCBData	attrData;

    //
    // Return if we already called init.
    //
    if (_initialized)
      return XaESuccess;

    //
    // Set and cache the direction.  Not allowed to change it later
    //
    attrData.name = XaAdirection;
    attrData.type = XaTatom;
    if (write)
	direction = XaAoutput;
    else
	direction = XaAinput;
    attrData.value = (void *)(unsigned long)direction;
    SetAttribute(Conn(), &attrData);


    // Do a bunch of local initialization

    // If we have a new libraryName, the use this one
    if (libraryName) {
      if (_libName) 
	free (_libName);
      _libName = strdup (libraryName);
    }

    //
    // If no library name given in the constructor or
    // init(), then fail.
    //
    if (!_libName)
      return XaEFailure;

    // Let the device module initialize the device.
    // DEVICE_INIT_FUNC should always be in the device module.
    // NOTE:  Should fix this to only load it if it hasn't
    //	      been loaded yet.
    //
    error = XaDynamicSymbolLibrary::getSymbol (_libName, DEVICE_INIT_FUNC,
					       (void *&)_initFunc);
    if (error == XaESuccess && _initFunc) 
      status = _initFunc(this, write);

    if (status)
      error = XaEFailure;
    else
      _initialized = XaTrue;
    // clean up.


    return error;
}

XaErrorCode
XaDevice::Open(int mode)
{
    int  err = 0;
    XaErrorCode status;

    // Initialize this device.
    //
    status = init();
    if (status == XaEFailure)
      return XaEFailure;

    // Do local state, then call
    // device module's read function.

    if (_open_func)
      err = _open_func(this, mode);

    // Do local clean up.


    if (err == 0)
      return XaESuccess;
    else
      return XaEFailure;

    return err;
}
#if 0

XaErrorCode
XaDevice::Read(char *buf, CARD32 bitsToRead, CARD8 *leftPad, 
	       CARD32 *bitsRead)
{
    XaErrorCode err = XaESuccess;
    XaInternalBuffer intBuffer((bitsToRead+7)/8, buf);
    XaInternalBuffer *intBufferPtr = &intBuffer;
    XaTime deviceTime;

    Read(0, XaAlastAccessTime, &intBufferPtr, bitsToRead, leftPad,
    bitsRead, &deviceTime);

    return err;
}



//
// RefTime must be one of the atoms XaAwallTime XaAdeviceTime XaAlastAccessTime
//
XaErrorCode 
XaDevice::Read(XaTime atTime, XaTag refTime, XaInternalBuffer **buffer,
	       CARD32 bitsToRead, CARD8 *leftPad, CARD32 *bitsRead,
	       XaTime *deviceTime)
{
    XaErrorCode err = XaESuccess;

    *bitsRead = 0; // in case there's no read function.

    // Do local state, then call
    // device module's read function.

    if (_read_func)
    {
	char *buf = NULL;

	if (*buffer)
	    buf = (char *)(*buffer)->GetBuffer();
	// XXXX ConnectID ?????
	err = _read_func(this, NULL, atTime, refTime, &buf, bitsToRead, 
			leftPad, bitsRead, deviceTime);
	if (err == XaESuccess && !(*buffer))
	{
	    // XXXXXXXXXXXXXX Now what???

	}
	    
    }
    // Do local clean up.

    return err;
}

XaErrorCode 
XaDevice::Write(char *buf, CARD32 bitsToWrite, CARD8 leftPad, 
		CARD32 *bitsWritten)
{
    XaInternalBuffer intBuffer((bitsToWrite+7)/8, buf);
    XaTime	deviceTime;

    return Write(0, XaAlastAccessTime, &intBuffer, bitsToWrite, leftPad,
		bitsWritten, &deviceTime);
}

XaErrorCode
XaDevice::Write(XaTime atTime, XaTag refClock, XaInternalBuffer *buffer,
		CARD32 bitsToWrite, CARD8 leftPad, CARD32 *bitsWritten,
		XaTime *deviceTime)
{
}

XaErrorCode
XaDevice::Write(XaTime atTime, XaTag refClock, XaInternalBuffer *buffer,
		CARD32 bitsToWrite, CARD8 leftPad, CARD32 *bitsWritten,
		XaTime *deviceTime)
{
    XaErrorCode err = XaESuccess;

    *bitsWritten = 0; // in case there's no write function.

    // Do local state, then call
    // device module's write function.
    if (_write_func)
	// XXXXX How do we find the connectID???????
      err = _write_func(this, NULL, 0, XaAlastAccessTime, 
			(char *)buffer->GetBuffer(), bitsToWrite, 
			leftPad, bitsWritten, deviceTime);

    // Do local clean up.

    return err;
}
#endif


XaErrorCode XaDevice::Start(XaTag port)
{
    // XXXX need to mark the port as running.


    // Reschedule
    // do the first update
    // if (!running)
    //	Update(&updateTask, (void *)this);

    running = True;

    return XaESuccess;
}

XaErrorCode XaDevice::Stop(XaTag port)
{
    // XXXX need to mark the port as not running.

    // XXXX if other ports are still running, return.

    if (!running)
	return XaESuccess;

    running = False;

    return XaESuccess;
}

//
//	Update()
//
void XaDevice::Update(XaTask *task, void *taskInfo)
{
    XaDevice		*device = (XaDevice *)taskInfo;
    XaErrorCode		errorReturn;


    // Check to make sure we're not stopped.  If stopped, return.
    // if (!device->running)
    //	return;

    // Check to make sure we have enough data to update the hardware
    // XXX is something similar needed in the Read case??

    if (!device->connectorDelegate->ReadyToTransfer())
    {
    //
    // First run through any open ports
    // and move data into the transferBuffers.

	XaTime	transferStartTime, transferEndTime;
	XaTime	actualStartTime, actualEndTime;
	XaTime	currentTime = device->_time_update_func();

	transferStartTime = device->connectorDelegate->LatestSample() + 1;

	if (After(currentTime, transferStartTime))
	    transferStartTime = currentTime;

	transferEndTime = transferStartTime - 1
				+ device->connectorDelegate->SpaceAvailable();

	errorReturn = device->GetData(transferStartTime, transferEndTime,
					actualStartTime, actualEndTime);

	// Set the LatestSample to the requested transferEndTime rather than
	// the actualEndTime whether or not we got what we asked for.
	// If data arrives later a write-through will be required.

	device->connectorDelegate->SetLatestSample(transferEndTime);

	// XXX latestSample needs to be stored in the attribute so client
	// XXX can get it.
    }

    

    // How DO we fail? (jdr)
    //
    // I believe failures must be ignored, must continue to reschedule the
    // updates.  If the ports didn't provide data on time, there's not much we
    // can do about it.
    // XXX BUT, We might want to send an error event. (pderr)
    //
    // if( errorReturn != XaESuccess)
    //	XXXX Send an event ????
    
   // Do the transferBuffer updating and return a reschedule time.
   XaWallTime next;
   // Connector
   if( (errorReturn = device->connectorDelegate->Update(next)) != XaESuccess)
       return;
   
    // So reschedule and be done with it.
   device->updateTask.Reschedule(next);

   return;
}



// C API for device code to configure ring buffer parameters

XaErrorCode DeviceRingBufConfigure(void *object, char **buf, XaTime length,
				CARD32 nChannels, CARD32 sWidth,
				XaTime transferSize, XaTime sampleLimit,
				XaTime hardwareTransferLimit,
				XaTime currentSample)
{
    XaDevice *device = (XaDevice *)object;

    return device->RingBufConfigure(buf, length, nChannels, sWidth,
				    transferSize, sampleLimit,
				    hardwareTransferLimit, currentSample);
}

// Most done in XaMixingBuffer
XaErrorCode XaDevice::RingBufConfigure(char **buf, XaTime length,
				CARD32 nChannels, CARD32 sWidth,
				XaTime transSize, XaTime sampleLimit,
				XaTime hardwareTransferLimit,
				XaTime currentSample)
{
    XaMixingBuffer *mixingBuffer;

    transferSize = transSize;

    // XXX perhaps there should be no nChannels and sWidth parameters here
    // because they are set when the format is set.  Verify them for now.

    if (sWidth != formatCache.sampleWidth
		|| nChannels != formatCache.numChannels)
	return XaEValue;

    if (!(mixingBuffer = connectorDelegate->MixingBuffer()))
    {
	return XaEValue;  // XXX better return value??
    }
    else
    {
	return mixingBuffer->RingBufConfigure(buf, length, nChannels,
					sWidth, transSize, sampleLimit,
					hardwareTransferLimit, currentSample,
					direction);
    }
}


XaErrorCode 
XaDevice::reset()
{
    int err;

    // Do local state, then call
    // device module's reset function.
    if (_reset_func)
      err = _reset_func(this);

    // Do local clean up.



    if (err == 0)
      return XaESuccess;
    else
      return XaEFailure;
}

XaErrorCode 
XaDevice::drain()
{
    int err;

    // Do local state, then call
    // device module's reset function.
    if (_drain_func)
      err = _drain_func(this);

    // Do local clean up.



    if (err == 0)
      return XaESuccess;
    else
      return XaEFailure;
}

XaErrorCode 
XaDevice::Close()
{
    int err;

    // Do local state, then call
    // device module's reset function.
    if (_close_func)
      err = _close_func(this);

    // Do local clean up.


    if (err == 0)
      return XaESuccess;
    else
      return XaEFailure;
}

static XaErrorCode XaDeviceDestroyCB(XaObject *obj)
{
    //XXX Some cleanup goes here:
    //XXX   Nuke created objects
    //XXX   Remove from server's list of connections
    return XaESuccess;
}

void *DeviceClassCreate(void *conn, void *c, XaTag t1, XaTag t2, XaTag t3) {
	return (void*) new XaDevice((XaConnection*)conn, (XaClass*)c,
	                    t1, t2, t3);
}

/* Format Set CB */
static void 
formatSetCB(void *obj, XaAttributeCBData *cbd) 
{
    XaDevice      *device = (XaDevice *)obj;
    XaConnection  *conn = device->Conn();
    XaTag          fmtTag = (XaTag)(unsigned long)cbd->newValue;

    XaObject      *format = (XaObject *)conn->ObjectDB().find(fmtTag);    
   
    device->SetAttribute (conn, cbd);
    device->CacheFormat(format);
}

XaErrorCode
XaDevice::CreateCB (XaObject *obj, XaAttributeCBData * data, CARD32 count)
{
    XaDevice          *device = (XaDevice*)obj;
    XaConnection      *c = device->Conn();
    XaAttributeCBData  cbdata;

//
// Set up XaAformat callback
// so that this is called when a format 
// is set on a device obj.
//
    XaAttribute *attr = (XaAttribute *)device->attributes.find(XaAformat);
    if (attr) {
      // Set up Set Callback
      attr->Set(formatSetCB);
    }
    else
      return XaEFailure;

    return XaESuccess;
}


XaClassInitRec XaDeviceClassInit =
{
    XaNdevice, XaNbuffer,
    // pointer to constructor that takes Xaobject constructor args.    
    DeviceClassCreate, 
    XaNumber(XaDeviceAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XaDevice::CreateCB, XA_NULL, XA_NULL, XA_NULL, XaDeviceDestroyCB
};

XaErrorCode XaCreateClassDevice(XaConnection *conn)
{
    return (new XaClass(conn, XaAdevice,
	    &XaDeviceClassInit, XaDeviceAttrInit)) ? XaESuccess : XaEFailure;
}


XaErrorCode XaDevice::Connect(XaPort *port, XaFormat *data_format,
			      XaTransferBuffer *&transferBuffer) {

    XaErrorCode e = XaElement::Connect(port, data_format, transferBuffer);

    // XXXXX Failure from above.
    if (e != XaESuccess) return e;

    // Take this out.  Start now is called in response to setting the 'run'
    // attribute true.
    // e = Start(port->Tag());
    Update(&updateTask, (void *)this);

    return e;
}
    


/*
 * provides data from device shared buffer for hardware to play.
 */
XaErrorCode XaDevice::WriteTransfer(void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char **buf, CARD32 samplesToRead,
			    CARD32 *samplesRead, XaTime deviceTime)
{
    XaMixingBuffer *mixingBuffer;

    if (!(mixingBuffer = connectorDelegate->MixingBuffer()))
    {
	return XaEValue;  // XXX better return value??
    }
    else
    {
	deviceTime = _time_update_func();
	return mixingBuffer->WriteTransfer(atTime, refTime, *buf,
						samplesToRead, *samplesRead,
						deviceTime);
    }
}

XaErrorCode DeviceWriteTransfer(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char **buf, CARD32 samplesToRead,
			    CARD32 *samplesRead, XaTime deviceTime)
{
    XaDevice *device = (XaDevice *)object;

    return device->WriteTransfer(connectId, atTime, refTime, buf,
				samplesToRead, samplesRead, deviceTime);
}
/*
 * accepts data from hardware to write into device shared buffer 
 */
XaErrorCode DeviceReadTransfer(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char *buf, CARD32 samplesToWrite, 
			    CARD8 leftPad, CARD32 *samplesWritten,
			    XaTime deviceTime);

