/* $XConsortium: connectors.h /main/7 1996/12/30 16:33:15 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __connectors_h
#define __connectors_h

#include "cdevice.h"
#include "buffer.h"
#include "scheduler.h"

#include "transbuffs.h"

class XaElement;
class XaPort;

/*
 * Implements connection and update semantics.
*/ 
class XaConnector {

    friend class XaMixingBuffer;


    
public:
    XaConnector(DeviceUpdateFunc updateFunc = NULL,
		DeviceWriteFunc writethroughFunc = NULL,
		DeviceConnectFunc connectFunc = NULL,
		DeviceDisconnectFunc disconnectFunc = NULL) :
	    updateFunction(updateFunc), writethroughFunction(writethroughFunc),
	    connectFunction(connectFunc), disconnectFunction(disconnectFunc),
	    portsConnected(0) {};
    virtual ~XaConnector() {};

    // connectability.
    virtual XaErrorCode Connect(XaPort *port,
				XaFormat *data_format, 
				XaTransferBuffer *&transferBuffer) = 0;

    // XXX had a parameter 'XaElement *e' but I don't know why (pderr)
    virtual XaErrorCode Disconnect(XaPort * port, 
				   XaTransferBuffer &transferBuffer,
				    XaBoolean flush) = 0;

    // Update 
    virtual XaErrorCode Update(XaWallTime &when);
    

    // Information required for updates
    virtual XaBoolean ReadyToTransfer() = 0;
    
    virtual XaTime LatestTransferredSample() = 0;
    virtual XaTime LatestSample() = 0;
    virtual XaErrorCode SetLatestSample(XaTime ls) = 0;

    virtual XaTime SpaceAvailable() = 0;
    virtual XaErrorCode NextUpdateTime(XaWallTime& nextWallTime) = 0;
    virtual XaMixingBuffer * MixingBuffer() = 0;

    // Access
    XaElement *GetElement() { return connectingElement; }
    void SetElement(XaElement *e) {connectingElement = e;}
    
protected:
    // Access to the element.
    XaElement *connectingElement;
    DeviceUpdateFunc updateFunction;
    DeviceWriteFunc writethroughFunction;
    DeviceConnectFunc connectFunction;
    DeviceDisconnectFunc disconnectFunction;

    XaTime latestSample;
    int portsConnected;
};


// Returns a PassThroughBuffer on connect.
class XaPassThroughConnector : public XaConnector
{
    
friend void * XaCreatePassThroughConnector(DeviceUpdateFunc updateFunc,
					DeviceWriteFunc writeFunc,
					DeviceConnectFunc connectFunc,
					DeviceDisconnectFunc disconnectFunc);

public:

    XaPassThroughConnector( DeviceUpdateFunc updateFunc = NULL,
			    DeviceWriteFunc writethroughFunc = NULL,
			    DeviceConnectFunc connectFunc = NULL,
			    DeviceDisconnectFunc disconnectFunc = NULL);

    virtual ~XaPassThroughConnector();
    
    virtual XaErrorCode Connect(XaPort *port,
				XaFormat *data_format, 
				XaTransferBuffer *&transferBuffer);

    // XXX had a parameter 'XaElement *e' but I don't know why (pderr)
    virtual XaErrorCode Disconnect(XaPort * port,
				   XaTransferBuffer &transferBuffer,
				    XaBoolean flush);

    inline XaBoolean ReadyToTransfer() {
	// PassThrough never has data to transfer, always needs to pull 
	// it from the port(s).
	return False;
    }

    inline XaTime LatestTransferredSample()
    {
	return latestTransferredSample;
    }

    inline XaTime LatestSample()
    {
	return latestSample;
    }

    XaErrorCode SetLatestSample(XaTime ls)
    {
	latestSample = ls;
	return XaESuccess;
    }

    XaErrorCode NextUpdateTime(XaWallTime& nextWallTime);
    virtual XaMixingBuffer * MixingBuffer();

    inline XaTime SpaceAvailable() { return transferSize; };

private:

    // XXX does this belong here???? (pderr)
    XaTime transferSize;
    XaTime latestTransferredSample;
};

class XaMixingConnector : XaConnector {
    
    // XXX paramters??
    friend void *XaCreateMixingConnector(DeviceUpdateFunc, DeviceWriteFunc,
				    DeviceConnectFunc, DeviceDisconnectFunc);

    XaMixingBuffer	*mixingBuffer;

public:
    XaMixingConnector( DeviceUpdateFunc updateFunc,
			    DeviceWriteFunc writethroughFunc,
			    DeviceConnectFunc connectFunc,
			    DeviceDisconnectFunc disconnectFunc) :
			XaConnector(updateFunc, writethroughFunc,
			connectFunc, disconnectFunc) {}

    virtual ~XaMixingConnector() {};

    XaMixingBuffer * MixingBuffer() { return mixingBuffer; }
    
    virtual XaErrorCode Connect(XaPort *port, XaFormat *data_format, 
				XaTransferBuffer *&transferBuffer);

    virtual XaErrorCode Disconnect(XaPort * port,
				   XaTransferBuffer &transferBuffer,
				    XaBoolean flush);

    inline XaBoolean ReadyToTransfer()
    {
	return mixingBuffer->ringBuffer->ReadyToTransfer();
    }
    inline XaTime LatestTransferredSample()
    {
	return mixingBuffer->ringBuffer->latestTransferredSample;
    }

    inline XaTime LatestSample()
    {
	return mixingBuffer->ringBuffer->latestSample;
    }

    XaErrorCode SetLatestSample(XaTime ls)
    {
	// Latest sample is maintained by the RingBuffer

	return mixingBuffer->ringBuffer->SetLatestSample(ls);
    }

    XaErrorCode NextUpdateTime(XaWallTime& nextWallTime);

    inline XaTime SpaceAvailable()
    {
	return mixingBuffer->ringBuffer->SpaceAvailable();
    }

private:
    void *connectID;
};

#endif

