/* $XConsortium: connectors.cc /main/11 1996/12/30 16:33:10 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#include "connectors.h"
#include "element.h"
#include "transbuffs.h"

// This just calls the callback that will
// tell us when we should call update again.
XaErrorCode XaConnector::Update(XaWallTime &when) {

    XaErrorCode e = XaESuccess;

    // This shouldn't happen.
    if( updateFunction == NULL) {
	return XaEServerInternal;
    }
	
    // Just do the usual thing on update.
    struct timeval next = (*updateFunction)();

    switch( (int)next.tv_sec) {
	case -1:
	    // forget it.
	    break;
	case 0:
	    // figure out for yourself when to do this.
	    NextUpdateTime(when);
	    break;
	default:
	    // We've returned a time s 
	    when.Set(next.tv_sec, next.tv_usec);
	    break;
    }

    return e;
    
}

#define PASSTHRU_TRANSFER_SIZE 100000

XaPassThroughConnector::
XaPassThroughConnector(DeviceUpdateFunc updateFunc,
		       DeviceWriteFunc writethroughFunc,
		       DeviceConnectFunc connectFunc,
		       DeviceDisconnectFunc disconnectFunc) :
		       XaConnector(updateFunc, writethroughFunc,
				    connectFunc, disconnectFunc),
		       transferSize(PASSTHRU_TRANSFER_SIZE),
		       latestTransferredSample(0)
{}

XaPassThroughConnector::~XaPassThroughConnector() {
    
}

XaErrorCode XaPassThroughConnector::Connect(XaPort *port, XaFormat *format,
					    XaTransferBuffer *&transferBuffer) {

    XaErrorCode e = XaESuccess;
    
    // Need one of these to return.
    if(!connectingElement) return XaEServerInternal;

    // In case we fail.
    transferBuffer = NULL;
    
    // Calls the connect function on the element
    void * connectID = NULL;
    if( connectFunction) {
	
	connectID = connectFunction(port, format);
	
	// Couldn't connect.
	if(connectID == NULL) {
	    return XaEFailure;
	}
    }
    
    // We've got a good connection so get a transferbuffer
    // This guy is effectively owned by the port.

    // XXXXX Attach the device write function to it.
    // XXXXX And the connectID as write callback data.
    transferBuffer = new XaPassThroughBuffer(connectingElement,
					     connectID,
					     writethroughFunction);
    if(transferBuffer == NULL) {
	return XaEAlloc;
    }
    
    portsConnected++;

    return e;
}


XaErrorCode XaPassThroughConnector::Disconnect(XaPort * port,
				   XaTransferBuffer &transferBuffer,
				    XaBoolean flush)
{
    XaErrorCode returnCode = XaESuccess;

    assert(connectingElement != NULL);

    // if( connectingElement->_disconnect_func)
    if(disconnectFunction)
    {
	// XXXXXX get this connectId out of the transfer buffer's callback
	// 	data
	void * connectId;	// XXXX Bogus

	returnCode = (*disconnectFunction)(port, connectId, flush);
    }

    delete &transferBuffer;

    portsConnected--;
    if (portsConnected < 0)
	portsConnected = 0;

    return returnCode;

}

//
// XXXXX This whole function is pretty bogus and is mostly a copy of the
// XXXXX XaMixingConnector version (pderr)
//
XaErrorCode XaPassThroughConnector::NextUpdateTime(XaWallTime& nextWallTime)
{
    XaErrorCode	returnCode;
    XaWallTime	currentWallTime;
    XaAttributeCBData	data;
    XaFormat	*format;
    CARD32	sampleRate;
    XaTime	sampleLimit;

    XaWallTime now;
    now.Now();
    nextWallTime.Set(0, 10000);
    nextWallTime += now;
    return XaESuccess;

    // Set next time to 0 in case of any failure returns
    nextWallTime.Set(0, 0);

#if 0
    // Find sample rate
    // XXXX Is this expensive?  Should sample rate be cached somewhere?
    // XXX overload SetAttribute, cache value, call XaObject::SetAttribute
    // XXX Do this for sampleWidth and numChannels, too.

    data.name = XaAformat;
    data.type = XaTtag;
    if ((returnCode = connectingElement->GetAttribute(connectingElement->Conn(),
							&data)) != XaESuccess)
	return returnCode; // failure
    format =
    (XaFormat *)connectingElement->Conn()->ObjectDB().find((XaTag)(unsigned long)data.value);

    data.name = XaAsampleRate;
    data.type = XaTcard32;
    if ((returnCode = format->GetAttribute(format->Conn(),&data)) != XaESuccess)
	return returnCode; // failure
    sampleRate = (CARD32)(unsigned long)data.value;
#endif
    sampleRate = connectingElement->FormatCache().sampleRate;
	

    // Find currentSample and current wall time.

    currentWallTime.Now();	// keep this before getting currentSample
				// early is better than late
    // if (connectingElement->_time_update_func)
    //	mixingBuffer->ringBuffer->currentSample =
    //			(*connectingElement->_time_update_func)();
    // else
    //	XXXXX not sure what to do here.  Hope device write set the current
    //	sample.  Could interpolate somehow.

    XaTime deviceTimeInterval = transferSize;
	//		sampleLimit - mixingBuffer->ringBuffer->currentSample;
    if (deviceTimeInterval < 0)
    {
	// We're late!!!  Set the update time to Now.
	nextWallTime.Now();
	return XaESuccess;  // XXX should return something else
    }

    // Translate next update time into wall time

    XaWallTime wallTimeInterval(deviceTimeInterval * (int)1e6 / sampleRate);

    currentWallTime += wallTimeInterval;

    return XaESuccess;
}


XaMixingBuffer *
XaPassThroughConnector::MixingBuffer()
{
    return NULL;
}

extern "C"
{

// XXXXXX this may need to do more
void * XaCreatePassThroughConnector(DeviceUpdateFunc updateFunc,
				DeviceWriteFunc writeFunc,
				DeviceConnectFunc connectFunc,
				DeviceDisconnectFunc disconnectFunc)
{
    XaPassThroughConnector * connector = 
				new XaPassThroughConnector(updateFunc,
							    writeFunc,
							    connectFunc,
							    disconnectFunc);
    return (void *)connector;
}

}

//
// MixingConnector
//

XaErrorCode XaMixingConnector::Connect(XaPort *port, XaFormat *format,
					    XaTransferBuffer *&transferBuffer)
{

    XaErrorCode e = XaESuccess;
    
    // In case we fail.
    transferBuffer = NULL;
    
    // Need one of these to return.
    if(!connectingElement)
	return XaEServerInternal;

    // Need one of these to return.
    if(!mixingBuffer)
	return XaEServerInternal;

    // XXXXX Check the format!
    // if other ports with different formats are already connected this must
    // return a failure status !!

    // Calls the connect function on the element
    // if(connectingElement->_connect_func)
    if (connectFunction)
    {
	// connectID = (*connectingElement->_connect_func)(port, format);
	connectID = (*connectFunction)(port, format);
	
	// Couldn't connect.
	if(connectID == NULL) {
	    return XaEFailure;
	}
	
	// XXXXX If we need to save the connectionID here is where
	// we better do it.
    }
    
    // We've got a good connection so get a transferbuffer
    // This guy is effectively owned by the port.

    // XXXXX Attach the device write function to it.
    // XXXXX And the connectID as write callback data.
    transferBuffer = mixingBuffer;

    // schedule first update
    
    portsConnected++;
    if (portsConnected > 1)
	mixingBuffer->ringBuffer->doMixing = XaTrue;

    return e;
}

XaErrorCode XaMixingConnector::Disconnect(XaPort * port,
					XaTransferBuffer &transferBuffer,
					XaBoolean flush)
{
    XaErrorCode returnCode = XaESuccess;

    assert(connectingElement != NULL);

    // if( connectingElement->_disconnect_func)
    if(disconnectFunction)
    {
	void * connectId;

	returnCode = (*disconnectFunction)(port, connectId, flush);
    }

    portsConnected--;
    if (portsConnected < 0)
	portsConnected = 0;

    if (portsConnected <= 1)
	mixingBuffer->ringBuffer->doMixing = XaFalse;

    return returnCode;

}

XaErrorCode XaMixingConnector::NextUpdateTime(XaWallTime& nextWallTime)
{
    XaErrorCode	returnCode;
    XaAttributeCBData	data;
    XaFormat	*format;
    CARD32	sampleRate;
    XaTime	sampleLimit;

    /*
       The next update time is the time at which we want to service
       the hardware, because the transfer size and desired latency
       are much lower.
       
       If this connector is for an output device (speaker, etc),
       the next update time should be

           sampleLimit = (latestTransferredSample - hardwareTransferLimit)

       where (latestTransferredSample) is the most recent sample written
       to the hardware, and (hardwareTransferLimit) is essentially the
       maximum time needed to write a batch of data to/from the device
       without causing dropouts.

       For input devices (microphone, etc), the next update time should be

           sampleLimit = (earliestTransferredSample - hardwareTransferLimit)

       Find currentSample and current wall time.
       Project wall time when currentSample == sampleLimit.
    */

    // Set next time to 0 in case of any failure returns
    nextWallTime.Set(0, 0);

    sampleLimit = mixingBuffer->ringBuffer->SampleLimit();

    // Find sample rate
    // XXXX Is this expensive?  Should sample rate be cached somewhere?
    // XXX overload SetAttribute, cache value, call XaObject::SetAttribute
    // XXX Do this for sampleWidth and numChannels, too.

#ifdef FixThisLater // XXXXXXXXXXXX

    data.name = XaAformat;
    data.type = XaTtag;
    if ((returnCode = connectingElement->GetAttribute(connectingElement->Conn(),
							&data)) != XaESuccess)
	return returnCode; // failure
    format =
    (XaFormat *)connectingElement->Conn()->ObjectDB().find((XaTag)(unsigned long)data.value);

    data.name = XaAsampleRate;
    data.type = XaTcard32;
    if ((returnCode = format->GetAttribute(format->Conn(),&data)) != XaESuccess)
	return returnCode; // failure
    sampleRate = (CARD32)(unsigned long)data.value;
#endif

    sampleRate = connectingElement->FormatCache().sampleRate;
	

    // Find currentSample and current wall time.

    nextWallTime.Now();	// keep this before getting currentSample
				// early is better than late
    if (connectingElement->_time_update_func)
	mixingBuffer->ringBuffer->currentSample =
				(*connectingElement->_time_update_func)();
    // else
    //	XXXXX not sure what to do here.  Hope device write set the current
    //	sample.  Could interpolate somehow.

    XaTime deviceTimeInterval =
			sampleLimit - mixingBuffer->ringBuffer->currentSample;
    if (deviceTimeInterval < 0)
    {
	// We're late!!!  Set the update time to Now.
	return XaESuccess;  // XXX should return something else
    }

    // Translate next update time into wall time in microseconds

    XaWallTime wallTimeInterval(deviceTimeInterval * (int)1e6 / sampleRate);

    nextWallTime += wallTimeInterval;

    return XaESuccess;
}


extern "C"
{

void * XaCreateMixingConnector(DeviceUpdateFunc updateFunc,
				DeviceWriteFunc writeFunc,
				DeviceConnectFunc connectFunc,
				DeviceDisconnectFunc disconnectFunc)
{
    XaMixingConnector * connector = new XaMixingConnector(updateFunc,
							writeFunc,
							connectFunc,
							disconnectFunc);
    connector->mixingBuffer = new XaMixingBuffer(connector);
    return (void *)connector;
}

}

