/* $XConsortium: config.cc /main/4 1996/12/30 16:33:01 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
** This module handles command line parsing and configuration files.
** There is an unsupported version of this that does not rely on the X library.
** define XA_NO_XRM to get that version. Note that the fallback does not do
** config files.
*/

#ifdef __cplusplus
extern "C" {
#endif

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef XA_NO_XRM

#include <X11/Xlib.h>
#include <X11/Xresource.h>

#define CNULL (char *)NULL

/*
** option tables - the first is just for the app name and defaults file
**		the second has the rest of the options.
*/

static XrmOptionDescRec bootsStrapOptions[] =
{
    { "-config",	".config", 	XrmoptionSepArg, NULL},
    { "-name", 		".name", 	XrmoptionSepArg, NULL},
    { "-help", 		".help", 	XrmoptionNoArg,	 "on"}
};

static XrmOptionDescRec options[] =
{
    { "-port",		".port", 	XrmoptionSepArg, NULL},
    { "-noauth", 	".auth", 	XrmoptionNoArg,	 "False"},
    { "-auth", 		".auth", 	XrmoptionNoArg,	 "True"},
    { "-xrm",		NULL, 		XrmoptionResArg, NULL}
};

static int 	ConfigArgc = 	0;
static char ** 	ConfigArgv = 	NULL;
static char *	ConfigApp = 	NULL;	/*Application name used for resources*/
static char *	ConfigClass = 	NULL;	/*Application name used for resources*/
static XrmDatabase ConfigDB = 	NULL;

/*
**------------------------------------------
** The next few routines pull data from the xrm data base
*/

/* tightly bind resource class name */
#define EXPAND(in, tmp, prefix)		\
    if (in[0] == '.')			\
    {					\
	sprintf(tmp, "%s%s", prefix, in);\
	in = tmp;			\
    }

/* common code for resource fetching routines */
#define RES_COMMON				\
    XaBoolean ret;				\
    char *type;					\
    XrmValue value;				\
    char fullName[512], fullClass[512];		\
						\
    if (!ConfigDB)				\
	return (FALSE);				\
    EXPAND(resName, fullName, ConfigApp);	\
    if (resClass)				\
	EXPAND(resClass, fullClass, ConfigClass);	\
    ret = XrmGetResource(ConfigDB, resName, resClass, &type, &value);

XaBoolean _XaConfigGetString(char *resName, char *resClass, char **target)
{
    RES_COMMON;
    if (ret)
	*target = value.addr;
    return (ret);
}

XaBoolean _XaConfigGetBool(char *resName, char *resClass, Bool *target)
{
    RES_COMMON;
    if (ret)
	*target = !(	(value.addr[0] == 'F') || 
			(value.addr[0] == 'f') ||
			(value.addr[0] == '0'));
    return (ret);
}

XaBoolean _XaConfigGetInt32(char *resName, char *resClass, int *target)
{
    RES_COMMON;
    if (ret)
	*target = atoi(value.addr);
    return (ret);
}

/*
** routine that spits out command line syntax, given an option table
*/
static void ValidOptions(XrmOptionDescRec *options, int nopt)
{
    char *suffix;

    while (nopt--) 
    {
	switch (options->argKind)
	{
	  case XrmoptionNoArg:
	  case XrmoptionIsArg:		suffix = "";			break;
	  case XrmoptionStickyArg: 	suffix = "<arg>";		break;
	  case XrmoptionSepArg:
	  case XrmoptionSkipArg: 	suffix = " <arg>";		break;
	  case XrmoptionResArg:		suffix = " <resource:value>";	break;
	  case XrmoptionSkipLine:	suffix = " ...";		break;
	  case XrmoptionSkipNArgs:	suffix = " <multiple args>";	break;
	}
	fprintf(stderr, " %s%s", options++->option, suffix);
    }
}

void Help()
{
    fprintf(stderr, "Valid options are:");
    ValidOptions(options, sizeof(options)/sizeof(XrmOptionDescRec));
    ValidOptions(bootsStrapOptions, 
	    sizeof(bootsStrapOptions)/sizeof(XrmOptionDescRec));
    fprintf(stderr, "\n");
}

/*
** generic syntax complainer
*/
void static Syntax()
{
    int i;

    fprintf(stderr, "Error in %s - Unkown options:", ConfigArgv[0]);
    for (i = 1; i < ConfigArgc; i++)
	fprintf(stderr, " %s", ConfigArgv[i]);
    fprintf(stderr, "\n");
    Help();
}

#ifdef WIN32
#  define DIR_SEPARATOR '\\'
#else
#  define DIR_SEPARATOR '/'
#endif

#ifdef DEBUG
void _XaObjectConfigReset(void);
#endif

XaBoolean _XaCreateConfig(int argc, char *argv[], 
    char *defaultFile, char *appClass, XaConfigUnkown warn)
{
    XrmDatabase dbApp;
    static char bootStrapDbString[512];

    XaBoolean help = XaFalse;
    int i;
    char *pl, *pr;	/* left and right end of appname */
    int nchars;

    /* clean up if not first time */
    if (ConfigArgc)
    {
	free(ConfigArgv);
	ConfigArgv = NULL;
	if (ConfigDB)
	    XrmDestroyDatabase(ConfigDB);
	ConfigDB = NULL;
	ConfigArgc = 0;
	if (ConfigApp)
	    free(ConfigApp);
	ConfigApp = 0;
    }
    else
	XrmInitialize();

    /* 
    ** save data
    */
    ConfigClass = appClass;
    ConfigArgv = (char **)malloc(sizeof(char *) * argc);
    if (!ConfigArgv)
	return XaFalse;
    for (i = 0; i < argc; i++)
	ConfigArgv[i] = argv[i];
    ConfigArgc = argc;

    /* 
    ** cull application name from argv[0] - drop path and suffix
    */
    pl = strrchr(argv[0], DIR_SEPARATOR);	/* drop path */
    pl = (pl) ? (pl + 1) : argv[0];
    pr = strchr(pl, '.');			/* drop suffix */
    nchars = (pr) ? (pr - pl) : strlen(pl);
    ConfigApp = (char *)malloc(nchars + 1);	/* copy and terminate result */
    if (ConfigApp)
    {
	strncpy(ConfigApp, pl, nchars);
	ConfigApp[nchars] = 0;
    }

    /* 
    ** get the defaults file name and application name from command line 
    */
    sprintf(bootStrapDbString, "*.config: %s", defaultFile);
    ConfigDB = XrmGetStringDatabase(bootStrapDbString);
    XrmParseCommand(&ConfigDB, bootsStrapOptions, 
	    sizeof(bootsStrapOptions)/sizeof(XrmOptionDescRec), 
	    ConfigApp, &ConfigArgc, ConfigArgv);
    _XaConfigGetString(".config",	CNULL, &defaultFile);
    _XaConfigGetString(".name",		CNULL, &ConfigApp);

    /*
    ** get out if they just want help
    */
    _XaConfigGetBool(".help",		CNULL, &help);
    if (help)
    {
	Help();
	exit(1);
    }

    /*
    ** Now load up the defaults file
    */
    dbApp = XrmGetFileDatabase(defaultFile);
    if (dbApp)
	XrmMergeDatabases(dbApp, &ConfigDB);
    XrmParseCommand(&ConfigDB, options, 
	    sizeof(options)/sizeof(XrmOptionDescRec), 
	    ConfigApp, &ConfigArgc, ConfigArgv);

    /*
    ** complain if unparsed command components
    */
    if (ConfigArgc > 1)
    {
	switch (warn)
	{
	    case XaConfigUnknownQuiet: 			break;
	    case XaConfigUnknownWarn:	Syntax(); 	break;
	    case XaConfigUnknownDie:	Syntax(); 	exit(1);
	}
    }
#ifdef DEBUG
    // I need this to get the Object code to recheck the config db,
    // because it already initialized itself before we got here.
    _XaObjectConfigReset();
#endif

    return XaTrue;
}

#else /* XA_NO_XRM */

static int ConfigArgc = 0;
static char ** ConfigArgv = NULL;

/*
** THIS CODE IS UNSUPPORTED!!!!
*/
void usage(char *progname)
{
    fprintf(stderr, "%s: [-port number] [-auth] [-noauth]\n", progname);
}

XaBoolean _XaCreateConfig(int argc, char *argv[], 
    char *defaultFile, char *appClass, XaConfigUnkown warn)
{
    int i;
    int error = 0;

    ConfigArgc = argc;
    ConfigArgv = argv;
    for (i = 1; i < argc; i++) 
	if (!strcmp(argv[i], "-port"))
		error |= (i++ == argc);
	else 
	    error |= !strcmp(argv[i], "-noauth");

    if (error)
	switch (warn)
	{
	    case XaConfigUnknownQuiet: 			break;
	    case XaConfigUnknownWarn:	usage(argv[0]); break;
	    case XaConfigUnknownDie:	usage(argv[0]); exit(1);
	}
}

#define RES_COMMON(fail)				\
    int i;						\
							\
    resName++;				/* skip '.' */	\
    for (i = 0; i < ConfigArgc; i++)			\
	if ((ConfigArgv[i][0] == '-') && (!strcmp(resName, ConfigArgv[i]+1))) \
	    break;					\
    if (fail)						\
	return (XaFalse);					

XaBoolean _XaConfigGetInt32(char *resName, char *resClass, int *target)
{
    RES_COMMON((i + 1) >= ConfigArgc)
    *target = atoi(ConfigArgv[i+1]);
    return (XaTrue);
}

XaBoolean _XaConfigGetString(char *resName, char *resClass, char* *target)
{
    RES_COMMON((i + 1) >= ConfigArgc)
    *target = ConfigArgv[i+1];
    return (XaTrue);
}

XaBoolean _XaConfigGetBool(char *resName, char *resClass, XaBoolean *target)
{
    RES_COMMON((i + 1) >= ConfigArgc)
    *target = XaTrue;
    return (XaTrue);
}

#endif /* XA_NO_XRM */

#ifdef __cplusplus
}
#endif
