/* $XConsortium: clientconn.cc /main/13 1996/12/30 16:32:52 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/*

    Connection sequence:

	Server:

	    ServerMasterConnection::setup()

		Calls IceRegisterForProtocolReply()

		Calls IceListenForConnections()

		Calls IceGetListenConnectionNumber() to get fd to listen on
		for new connections.

		Use select() or poll() to listen on the fd for new
		connections.

	Client:

	    ClientServerConnection::setup()

		Calls IceRegisterForProtocolSetup()

	    ClientServerConnection::open()

		Calls IceOpenConnection()

	Server:

	    Detect new connection on listen fd

	    ServerMasterConnection::acceptConnection()

		Calls IceAcceptConnection()
		process setup and authentication messages

	Client:

		Send a Protocol Setup


 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "scheduler.h"
#include "clientconn.h"
#include "class.h"
#include "bag.h"
#include "collectable.h"
#include "tagrange.h"
#include "buffer.h"
#include "intbuffer.h"
#include "config.h"

static void XaConnectionObjectInit(XaObject *connObj, XaClientConnection *conn);

#ifdef DEBUG

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".Connection.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#endif /* DEBUG */

// Collectable for connections
class XaCConn: public XaCollectable {
  public:
    XaCConn(IceConn i, XaClientConnection *c = NULL) : id(i), conn(c) {}
    ~XaCConn() {}

    XaClientConnection *conn;
    IceConn id;

    inline virtual XaBoolean equals(const XaCollectable &o) const
	   { return ((XaCConn&)o).id == id; }
    inline virtual unsigned hash(void) const { return (unsigned)(long)id; }
};

extern "C" {
struct _XtransConnInfo;  // missing decl. in ICEconn.h
#include <X11/ICE/ICEmsg.h>
}

extern XaMasterConnection masterConnection;

extern "C" { extern IcePaAuthStatus _IcePaMagicCookie1Proc ( IceConn, 
	    IcePointer *, Bool, int, IcePointer, int *, IcePointer *, char **);

	    extern Status SetAuthentication(int, IceListenObj *,
					    IceAuthDataEntry **);
	    extern void FreeAuthenticationData (int, IceAuthDataEntry *);
	   }

XaErrorCode XaCreateWellKnownClasses(XaConnection *conn);

//
// Server
//
XaMasterConnection::XaMasterConnection() :
    tagRangeFactory(XA_ATOM_SERVER_BOTTOM, XA_ATOM_SERVER_TOP)
{
    masterConn = this;

    listenConnFds = NULL;
    listenObjs = NULL;
    listenObjCount = 0;
    versionCount = 1;
    versions.major_version = 1;
    versions.minor_version = 0;
    versions.process_msg_proc = processMsgProc;

    authCount = 1;
    authNames[0] = "MIT-MAGIC-COOKIE-1";
    authProcs[0] = _IcePaMagicCookie1Proc;

    atomCache.Init();

    XaCreateWellKnownClasses(this);

    XaTagRange * tagRange = (XaTagRange *)XaCreateObject(this, XaAtagRange,
							 XaTnone, XaTnone, XA_NULL, 0);
    tagRanges.insert(*tagRange);

    // initing the atom cache used up some number of the availabe
    // parse constant tags, so we set our range to something a bit less
    parseConstantTags.SetRangeWithLength(XA_ATOM_PARSE_LAST_PREDEFINED + 1,
					 XA_ATOM_PARSE_TOP - XA_ATOM_PARSE_BOTTOM);
    tagCounter.SetRangeWithLength(tagRange->Start(), tagRange->Length());

    // make sure all the atoms get listed as allocated
    while (tagCounter.NewTag() < XA_ATOM_SERVER_LAST_PREDEFINED)
	; // empty loop

    externalObj = XaCreateObject(this, XaAconnection, 
				 NewTag(), XaTnone, XA_NULL, 0);

}

XaMasterConnection::~XaMasterConnection()
{

    if (listenConnFds)
	delete listenConnFds;
    if (listenObjs)
	IceFreeListenObjs(listenObjCount, listenObjs);

    if (externalObj)
    {
	delete externalObj;
	externalObj = NULL;
    }
}

void XaMasterConnection::runProc(XaTask *task, void *userData)
{
    XaConnFd *connFd = (struct XaConnFd *)userData;

    ((XaMasterConnection *)(connFd->conn))->acceptConnection(connFd->fd);


}

XaAtom XaMasterConnection::findAtom(char *name, XaBoolean create)
{
    XaAtom atom = atomCache.AtomByString(name);
    if (atom == XaTnone) {
	atom = NewTag();
	atomCache.AddAtom(atom, name);
    }
    return atom;
}

XaScalarBag& XaMasterConnection::ObjectDB() { return objectDB; }
XaScalarBag& XaMasterConnection::ClassDB()  { return classDB;  }

XaConnection *
XaMasterConnection::Narrow(const char * className)
{
    if (strcmp(className, "XaMasterConnection") == 0)
	return this;
    return NULL;
}


XaTag
XaMasterConnection::NewTag()
{
    return tagCounter.NewTag();
}

void
XaMasterConnection::ReleaseTag(XaTag tag)
{
    XaTag tagRangeTag = tag & (~ (XaDefaultTagRangeSize - 1));
    XaTagRange * tagRange = (XaTagRange *) ObjectDB().find(tagRangeTag);
    if (tagRange) {
	tagRange->ReleaseTag(tag);
    } else {
	// if this isn't the tag for the TagRange itself, then complain
	if (tag != tagRangeTag)
	    fprintf(stderr, "Couldn't find TagRange for tag  %u\n", tag);
    }
}


XaTagRange *
XaMasterConnection::NewTagRange(XaConnection * connection, XaClass * theClass,
				XaTag classID, XaTag name)
{
    XaTag objectTag = XaTnone;
    tagRangeFactory.NewTagRange(objectTag);
    if (objectTag == XaTnone)
	return NULL;

    return new XaTagRange(connection, theClass, objectTag, classID, name,
			  tagRangeFactory);
}



void XaMasterConnection::cleanup()
{
    if (authCount)
	FreeAuthenticationData (listenObjCount, authDataEntries);
}

extern "C"
{
_XaIceListenForConnections(char		*port,
			int		*countRet,
			IceListenObj	**listenObjsRet,
			int		errorLength,
			char		*errorStringRet);
}

int XaMasterConnection::setup(char *port, XaBoolean useAuth)
{
    Status	iceStatus;
    char	errorStr[256];

    if (!useAuth)
	{
	authCount = 0;
	}

    IceSetIOErrorHandler(errorHandler);

    iceOpCode = IceRegisterForProtocolReply (XA_PROTOCOL_NAME, vendorString,
		    releaseString, versionCount, &versions, authCount,
		    authNames, authProcs, 
		    hostBasedAuthProc, 
		    protocolSetupProc,
		    protocolActivateProc, errorHandler);
    if (iceOpCode<0)
	{
	fprintf(stderr, "Couldn't register XAUDIO protocol with ICE.\n");
	return 0;
	}
    iceStatus = _XaIceListenForConnections(port, &listenObjCount, &listenObjs, 255, 
					errorStr);
    if (!iceStatus)
	{
	fprintf(stderr, 
	    "XaMasterConnection::setup: IceListenForConnections failed.\n");
	return 0;
	}
    printf("Audio server network connection ids: %s\n",
	    connIDs = IceComposeNetworkIdList(listenObjCount, listenObjs));

    if (useAuth && 
	    !SetAuthentication (listenObjCount, listenObjs, &authDataEntries))
	fprintf (stderr, "Could not set authorization\n");

    listenConnFds = new XaConnFd[listenObjCount];
    int i;

    for (i = 0; i < listenObjCount; i++)
	{
	XaFileTask *newListenTask;

	IceSetHostBasedAuthProc(listenObjs[i], hostBasedAuthProc);
	listenConnFds[i].fd = IceGetListenConnectionNumber(listenObjs[i]);
	listenConnFds[i].conn = this;

	newListenTask = new XaFileTask((XaTaskProc)runProc,
				       (void *)&listenConnFds[i],
				       listenConnFds[i].fd);

	Scheduler().AddTask(*newListenTask);
	}
    
    return 1;
}

int XaMasterConnection::acceptConnection(int newFd)
{
    IceListenObj listenObj = NULL;
    IceConn	newIceconn;
    int i;


    for (i=0; i<listenObjCount; i++)
	if (listenConnFds[i].fd == newFd)
	    {
	    listenObj = listenObjs[i];
	    break;
	    }

    if (!listenObj)
	{
	fprintf(stderr, "select on fd %d didn't match ICE listenObjs.\n",
			newFd);
	return 0;
	}

    IceAcceptStatus acceptStatus;
    newIceconn = IceAcceptConnection(listenObj, &acceptStatus);
    if (acceptStatus != IceAcceptSuccess)
	{
	switch(acceptStatus)
	    {
            case IceAcceptFailure:
		{
                printf("IceAcceptFailure\n");
                break;
		}
            case IceAcceptBadMalloc:
		{
                printf("IceAcceptBadMalloc\n");
                break;
		}
            default:
		{
                printf("unknown status %1d\n",acceptStatus);
                break;
		}
	    }
	}

    IceConnectStatus connectStatus;
    connectStatus = IceConnectionStatus(newIceconn);

    // rest of accept algorithm as in IceLib p.13

    if (connectStatus != IceConnectPending && connectStatus != IceConnectAccepted)
	{
	IceCloseConnection(newIceconn);
	return 0;
	}

    XaClientConnection *newClient;
    newClient = new XaClientConnection(this, newIceconn);
    AddClient(*newClient);

    return 1;
}


void XaMasterConnection::AddClient(XaClientConnection& newClient)
{
    XaCConn *cc = new XaCConn(newClient.connectionId, &newClient);
    clients.insert(*cc); 			//XXX test for fail!

    Scheduler().AddTask(*newClient.task);
}

XaClientConnection *XaMasterConnection::FindClient(IceConn connId)
{
    XaCConn cc(connId);
    return ((XaCConn *)clients.find(cc))->conn;
}

void XaMasterConnection::RemoveClient(XaClientConnection *client)
{
    XaCConn cc(client->connectionId, client);
    IceCloseConnection(client->connectionId);
    clients.removeAndDestroy(cc);
    Scheduler().RemoveTask(*(client->task));
    delete client;
}


void XaMasterConnection::RemoveClient(IceConn connId)
{
    XaCConn cc(connId);
    XaClientConnection *client = ((XaCConn *)clients.find(cc))->conn;
    IceCloseConnection(client->connectionId);
    clients.removeAndDestroy(cc);
    Scheduler().RemoveTask(*(client->task));
    delete client;
}

// #include <signal.h>

XaIceReadData(IceConn connectionId, int maxLen, char *buffer)
{
    static XaBoolean init = FALSE;
    static int chunkSize = 0;
    int bytesToRead;
    int bytesRead = 0;

    if (!init)
    {
	_XaConfigGetInt32(".Connection.chunkSize", "", &chunkSize);

	if (chunkSize == 0)
	    chunkSize = 32768;
	init = TRUE;
    }

    while (bytesRead < maxLen)
    {
	if ((maxLen - bytesRead) > chunkSize)
	    bytesToRead = chunkSize;
	else
	    bytesToRead = maxLen - bytesRead;

	IceReadData(connectionId, bytesToRead, buffer + bytesRead);
	bytesRead += bytesToRead;

	Scheduler().RunTimedTasks();
    }

}

void XaMasterConnection::MarkForDelete(IceConn connId)
{
    XaCConn cc(connId);
    ((XaCConn *)clients.find(cc))->conn->markedForDelete = True;
}

// This is the callback invoked by IceProcessMessages when a message on the
// Audio protocol is received.

void XaMasterConnection::processMsgProc(IceConn iceConn, IcePointer clientData,
				int opcode, unsigned long length, Bool swap)
{
    XaClientConnection  *client;

#ifdef DEBUG
    if (DoDebug())
	printf("XaMasterConnection::processMsgProc was called with opcode %d\n",
		opcode);
#endif

    client = masterConnection.FindClient(iceConn);


  //  This macro sets up the ICE message header with the IceGetHeader
  //  macro, copies the rest of the Xa*Header fields into the ICE buffer,
  //  and sets the message ICE message length field.

#define _XaMasterConnection_ReadHeader(_opcode, _reqType) 		\
    _reqType *ptr##_opcode; 						\
    IceReadMessageHeader(iceConn, sizeof(_reqType), _reqType, ptr##_opcode); \
    if (swap)                                                           \
	Swap32((CARD32 *)ptr##_opcode + 2, (sizeof(_reqType) - 8)/4);   \
    client->_opcode##processMsg(ptr##_opcode, length, swap);


    switch (opcode)
	{
	char *data;

	case FINDATOM:
	    _XaMasterConnection_ReadHeader(FINDATOM, XaFindAtomRequest);
	    break;

	case FINDOBJECT:
	    _XaMasterConnection_ReadHeader(FINDOBJECT, XaFindObjectRequest);
	    break;

	case CREATE:
	    _XaMasterConnection_ReadHeader(CREATE, XaCreateRequest);
	    break;

	case DESTROY:
	    _XaMasterConnection_ReadHeader(DESTROY, XaDestroyRequest);
	    break;

	case SET:
	    _XaMasterConnection_ReadHeader(SET, XaSetRequest);
	    break;

	case GET:
	    _XaMasterConnection_ReadHeader(GET, XaGetRequest);
	    break;

	case WRITE:
	    _XaMasterConnection_ReadHeader(WRITE, XaWriteRequest);
	    break;

	case READ:
	    _XaMasterConnection_ReadHeader(READ, XaReadRequest);
	    break;

	case PING:
	    _XaMasterConnection_ReadHeader(PING, XaPingRequest);
	    break;


	default:
	    fprintf(stderr, 
		    "XaMasterConnection::processMsgProc: Unknown opcode %d\n",
		    opcode);
	}

    return;
}

Bool XaMasterConnection::hostBasedAuthProc(char *hostName)
{

    // To allow connection even if  authentication fails,
    // return True;

    if (masterConnection.authCount)
	return False;
    else
	// no auth, allow anyone
	return True;

}

Status XaMasterConnection::protocolSetupProc(IceConn iceConn, int majorVersion, 
			    int minor_version, char *vendor, char *release, 
			    IcePointer *clientDataRet, char **failureReasonRet)
{

    // When this is called the client has been authenticated but the
    // "Protocol Reply" has not yet been sent.

    // do nothing for now

    return 1;

}

//
// This is where the server sends a message to the client informing
// it about the server's predefined objects, tag range allocated for the
// client, etc.
// This is called immediately after the "Protocol Reply" has been sent.
//
void XaMasterConnection::protocolActivateProc(IceConn iceConn, 
						IcePointer clientData)
{

    XaClientConnection *client;
    XaStartupEvent startupMsg;

    client = masterConnection.FindClient(iceConn);

    startupMsg.minorOpcode = STARTUP_EVENT;
    startupMsg.connection = client->externalObj->Tag();
    startupMsg.server = masterConnection.externalObj->Tag();

    // this is bad
    XaBagIterator  bagiter(client->tagRanges);
    XaTagRange * tagRange = (XaTagRange *) bagiter.key();
    assert(tagRange != NULL);

    startupMsg.tagRangeTag = tagRange->Tag();
    startupMsg.tagRangeLength = tagRange->Length();

    client->sendMessage((XaProtoHeader *)&startupMsg, 0, NULL);
}

void XaMasterConnection::errorHandler(IceConn conn)
{
    printf("XaMasterConnection::errorHandler: Error on %d\n", conn);
    masterConnection.MarkForDelete(conn);
}


//
// XaClientConnection member functions
//

XaClientConnection::XaClientConnection(XaMasterConnection *mc,
				       IceConn iceConn)
{

    // Initialization
    masterConn = mc;
    connectionId = iceConn;
    
    // We use the atom cache from the Master Connection
    atomCache = mc->atomCache;
    
    connectStatus = IceConnectionStatus(iceConn);
    markedForDelete = False;
    iceOpCode = masterConn->iceOpCode;

    task = new XaFileTask(ProcessMessage, this,
			  IceConnectionNumber(iceConn));

    // create a new tag range for our client to use
    XaTagRange * tagRange = (XaTagRange *)XaCreateObject(this, XaAtagRange,
							 XaTnone, XaTnone, XA_NULL, 0);
    
    tagRanges.insert(*tagRange);

    externalObj = XaCreateObject(masterConn, XaAconnection, 
				 masterConn->NewTag(), XaTnone, XA_NULL, 0);
    XaConnectionObjectInit(externalObj, this);
}

XaClientConnection::~XaClientConnection()
{
    if (externalObj)
    {
	delete externalObj;
	externalObj = NULL;
    }

    // destroy all the tag ranges we created.
    tagRanges.clearAndDelete();

    delete task;
}

XaAtom XaClientConnection::findAtom(char *name, XaBoolean create)
{
    return masterConn->findAtom(name, create);
}


XaScalarBag&
XaClientConnection::ObjectDB()
{
    return masterConn->ObjectDB();
}


XaScalarBag&
XaClientConnection::ClassDB()
{
    return masterConn->ClassDB();
}

void
XaClientConnection::ReleaseTag(XaTag tag)
{
    masterConn->ReleaseTag(tag);
}



XaConnection *
XaClientConnection::Narrow(const char * className)
{
    if (strcmp(className, "XaClientConnection") == 0)
	return this;
    return NULL;
}

void XaClientConnection::ProcessMessage(XaTask *task, void *data)
{
    XaClientConnection *thisConnection;
    IceConnectStatus	newConnectStatus;

    thisConnection =(XaClientConnection *)data;

    if (!thisConnection->markedForDelete)
	IceProcessMessages(thisConnection->connectionId, NULL, NULL);

    if (thisConnection->markedForDelete)
	{
	masterConnection.RemoveClient(thisConnection);
	return;
	}

    newConnectStatus = IceConnectionStatus(thisConnection->connectionId);

    if (newConnectStatus == IceConnectAccepted  
    		&&  thisConnection->connectStatus != IceConnectAccepted)
	printf("Conn ID %d accepted.\n", thisConnection->connectionId);
    else if (newConnectStatus != IceConnectPending 
		&& newConnectStatus != IceConnectAccepted)
	{
	printf("Conn ID %d rejected or failed.\n",thisConnection->connectionId);
	masterConnection.RemoveClient(thisConnection);
	return;
	}
    thisConnection->connectStatus = newConnectStatus;

}

void XaClientConnection::errorHandler(IceConn conn)
{
    printf("XaClientConnection::errorHandler: Error on %d\n", conn);
    masterConnection.MarkForDelete(conn);
}



void XaClientConnection::FINDATOMprocessMsg(XaFindAtomRequest *req, 
					    unsigned long length, Bool swap)
{
    char *buffer;
    int maxLen;
    XaAtom atom = XaTnone;
    XaFindReply reply;

#ifdef DEBUG
    if (DoDebug())
	printf("FINDATOM message on connection %d\n", connectionId);
#endif

    maxLen = length * 8 - (sizeof(XaFindAtomRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, buffer);
	
#ifdef DEBUG
	if (DoDebug())
	    printf("Atom name is %s\n", buffer);
#endif

	atom = masterConn->findAtom(buffer, req->create);
	
	//
	// find the server object Tag.
	// Call the object's method with the attributes.
	//

	protocolBuffer.Unlock();
	}


    // FINDATOM expects a reply, so send a reply
    reply.minorOpcode = FIND_REPLY;
    reply.replyID = req->reply_id;
    sendMessage((XaProtoHeader *)&reply, sizeof(XaAtom), (char *)&atom);
}


void XaClientConnection::FINDOBJECTprocessMsg(XaFindObjectRequest *req, 
					    unsigned long length, Bool swap)
{
    char *buffer;
    int maxLen;
    XaTag tags[2] = {0, 0};  // XXXXXXX Bogus!
    XaFindReply reply;

#ifdef DEBUG
    if (DoDebug())
	printf("FINDOBJECT message on connection %d\n", connectionId);
#endif

    maxLen = length * 8 - (sizeof(XaFindObjectRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	int numAttr;
	XaAttributeCBData *attributes;
	XaBag objectBag;


	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen/4);
	
	attributes = (XaAttributeCBData *)parseParamList((XaProtoItem *)buffer,
							maxLen, numAttr);
	//
	// find the server object Tag.
	// Call the object's method with the attributes.
	// Should return a list of tags.
	//

	// Does FindByAttributes need a return value?
	// XXXXXXX Big Hole !!
	/*
	ObjectDB().FindByAttributes(this, req->classId,
				    attributes, numAttr, objectBag);
	*/

	protocolBuffer.Unlock();
	}


    // FINDOBJECT expects a reply, so send a reply
    // XXXXXXX Hole!
    // Change this to return the list of tags.
    // Get the tags out of the objectBag

    reply.minorOpcode = FIND_REPLY;
    reply.replyID = req->reply_id;
    sendMessage((XaProtoHeader *)&reply, 2 * sizeof(XaTag), (char *)tags);
}

void	XaClientConnection::CREATEprocessMsg(XaCreateRequest *req,
					unsigned long length, Bool swap)
{
    int maxLen;
    char  *buffer;

#ifdef DEBUG
    if (DoDebug())
	printf("CREATE message on connection %d for object %ld\n", connectionId,
		req->id);
#endif

    maxLen = length * 8 - (sizeof(XaCreateRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	int numAttr;
	XaAttributeCBData *attributes;
	XaObject *newObject;


	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *) buffer, maxLen/4);

	attributes = (XaAttributeCBData *)parseParamList((XaProtoItem *)buffer,
							maxLen, numAttr);

	//
	// Validate the tag being used to create the object
        //  
	if (ObjectDB().find(req->id)) {
	    // XXX Hole need to signal an error if tag is already in use
	    fprintf(stderr, "Creating new object with in use tag %u\n", req->id);
	}

	// make sure that this tag is coming from a tag range that
	// belongs to this client
	XaTag tagRangeTag = req->id & (~ (XaDefaultTagRangeSize - 1));
	XaTagRange * tagRange = (XaTagRange *)ObjectDB().find(tagRangeTag);
	if (tagRange == NULL || tagRange->Conn() != this) {
	    // XXX Hole need to signal an error if a tag doesn't belong to this connection
	    fprintf(stderr, "Creating new object with bad  tag %u\n", req->id);
	}

	// this is probably excessive, but for now it's some extra sanity checking
	if (tagRange->IsTagInUse(req->id) == XaTrue) {
	    fprintf(stderr, "Creating new object with in-use  tag %u\n", req->id);
	}

	//
	// Create the new object with the attributes and Tag from the
	// request.
	//
	newObject = XaCreateObject(this, req->classId, req->id, XaTnone,
				    attributes, numAttr);

	// Is XaCreateObject going to handle generating Create events or do
	// we need to do that here??

	protocolBuffer.Unlock();
	}


}

void	XaClientConnection::DESTROYprocessMsg(XaDestroyRequest *req, 
					unsigned long length, Bool swap)
{
    XaObject *object;

#ifdef DEBUG
    if (DoDebug())
	printf("DESTROY message on connection %d for object %ld\n",
		connectionId, req->object);
#endif

    if (sizeof(XaDestroyRequest) % 8)
	IceReadPad(connectionId, 8 - (sizeof(XaDestroyRequest) % 8));

    // DESTROY has no variable length data.

    object = (XaObject *)ObjectDB().find(req->object);

    if (object)
	{
	delete object;
	}
    else
	{
	// send error event
	// XXXX Hole!
	}
}

void	XaClientConnection::SETprocessMsg(XaSetRequest *req,
					unsigned long length, Bool swap)
{
    int maxLen;
    char  *buffer;
    XaObject *object;

#ifdef DEBUG
    if (DoDebug())
	printf("SET message on connection %d for object %ld\n", connectionId,
		req->object);
#endif

    maxLen = length * 8 - (sizeof(XaSetRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	int numAttr;
	XaAttributeCBData *attributes;


	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen/4);

	attributes = (XaAttributeCBData *)parseParamList((XaProtoItem *)buffer,
							maxLen, numAttr);
	//
	// find the object from the Tag in the request.
	// Call the object's method with the attributes
	//
	object = (XaObject *)ObjectDB().find(req->object);

	if (object)
	    {
	    object->SetAttributes(this, attributes, numAttr);
	    }

	protocolBuffer.Unlock();
	}

}

void	XaClientConnection::GETprocessMsg(XaGetRequest *req, 
					unsigned long length, Bool swap)
{
    char *buffer;
    int	maxLen;
    XaGetReply reply;
    XaObject *object;


#ifdef DEBUG
    if (DoDebug())
    {
	printf("GET message on connection %d\n", connectionId);
	printf("  %d  attributes for object %d\n", req->n_attributes,
		req->object);
    }
#endif


    maxLen = length * 8 - (sizeof(XaGetRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen/4);

	// shouldn't need any parsing.  Buffer contains an array of 
	// attribute tags.  Find the object from the Tag and call the right
	// method.
	//

	protocolBuffer.Unlock();
	}

    // GET expects a reply
    
    parseBuffer.Lock();

    // XaAttributeCBData *attributes = new XaAttributeCBData[req->n_attributes];
    XaAttributeCBData *attributes = (XaAttributeCBData *)
	    parseBuffer.Reserve(sizeof(XaAttributeCBData) * req->n_attributes);
    char *replyBuffer =
		parseBuffer.Reserve(sizeof(XaProtoItem) * req->n_attributes);
    int i;
    XaAtom *atomPtr = (XaAtom *)buffer;
    XaProtoItem *replyItems = (XaProtoItem *)replyBuffer;


    // fill in attribute name atoms for each attr

    for (i=0; i<req->n_attributes; i++)
	attributes[i].name = *atomPtr++;

    object = (XaObject *)ObjectDB().find(req->object);
    if (object)
	{
	object->GetAttributes(this, attributes, req->n_attributes);
	// encode the reply

	// XXXX Big Hole!
	//  Need to handle array-type values.
	//

	for (i=0; i<req->n_attributes; i++)
	    {
	    replyItems[i].name = attributes[i].name;
	    replyItems[i].value	= (CARD32)(unsigned long)attributes[i].value;
	    }

	reply.minorOpcode = GET_REPLY;
	reply.replyID = req->reply_id;
	sendMessage((XaProtoHeader *)&reply,
		    (sizeof(XaProtoItem) * req->n_attributes), replyBuffer);
	}
    else
	{
	XaErrorReply errorReply;
	//
	// No matching object, send Error Reply
	//
	errorReply.minorOpcode = ERROR_REPLY;
	errorReply.replyID = req->reply_id;
	// XXXXX Hole!  Error codes not yet defined
	errorReply.errorCode = 0;
	sendMessage((XaProtoHeader *)&errorReply, 0, NULL);
	}
    parseBuffer.Unlock();
    }

void	XaClientConnection::WRITEprocessMsg(XaWriteRequest *req, 
					unsigned long length, Bool swap)
{
    int	maxLen;

    // buffer comes from the protocolBuffer.  The object->Write method will
    // release the buffer if it's done with it.

#ifdef DEBUG
    if (DoDebug())
	printf("WRITE message on connection %d\n", connectionId);
#endif
    maxLen = length * 8 - (sizeof(XaWriteRequest) - sizeof(XaProtoHeader));
    if (maxLen)
	{
	XaObject *object;
	CARD32 bitsWritten;

	/* Taken out for XaInternalBuffer
	char * buffer;
	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen));
	*/

	/* ICE Read data used to put the data from the
	 * "wire" into our local buffer.
	 * Since it's data it wont require any parsing.
	*/
	XaInternalBuffer * iBuff= new XaInternalBuffer(maxLen);
	if (IceValidIO(connectionId))
	    XaIceReadData(connectionId, maxLen, (char *)(iBuff->GetBuffer()));

	// Find the object the request refers to.
	if(object = (XaObject *)ObjectDB().find(req->object))
            {
#ifdef DEBUG
	    if (DoDebug())
		fprintf(stderr, "connection: writing buffer to object\n");
#endif
	    /* XXXXX Have to define the is readable/Writeable stuff. *
	    /* if (object->IsWriteable()) */
	    XaBuffer *writeable = (XaBuffer *)object;
	    XaTime deviceTime;
	    XaErrorCode ec = writeable->Write(req->when, req->time_ref,
			                      *iBuff,
					      req->bit_length, req->leftPad[0],
			                      bitsWritten, deviceTime);
	    if( ec != XaESuccess)
	        {
		fprintf(stderr, "Write to buffer failed.\n");
	        }

#ifdef DEBUG
	    if (DoDebug())
		fprintf(stderr, "Wrote: %d bits\n", bitsWritten);
#endif
	    /* XXXXXX For NOW assume that the object has actually
	     * consumed all of the bits required.
	    */
            }

	/*
	 * XXXX This should be required.
	// delete buffer;
	protocolBuffer.Unlock();
	*/
	}

}

void	XaClientConnection::READprocessMsg(XaReadRequest *req, 
					unsigned long length, Bool swap)
{
    int	maxLen;
    XaAudioDataReply reply;
    XaObject *object;
    XaInternalBuffer *buffer;
    CARD32 bitsRead;
    CARD8 leftPad = 0;


    printf("READ message on connection %d\n", connectionId);

    // READ has no variable length data

    // This read pad is not really nec. since the sizeof the Read request is
    // a multiple of 8 bytes, but it's in here to avoid problems if we change
    // the size of the request.

    if (sizeof(XaReadRequest) % 8)
	IceReadPad(connectionId, 8 - (sizeof(XaReadRequest) % 8));

    // buffer comes from the protocolBuffer.  The object->Write method will
    // release the buffer if it's done with it.

        object = (XaObject *)ObjectDB().find(req->object);

        if (object)
            {
            // if read is supported
	    // XXXXXX Big Hole!
	    /*
            if (object->IsReadable())
		((XaBuffer *))object->Read(req->when, req->time_ref,
			buffer, req->max_bits, &leftPad, &bitsRead);
	    */
	    // if (bitsRead < req->min_bits) like call
	    //	Read again, resetting leftPad if nec.
            }


    // READ expects a reply, so send a reply
    // Change this to send the real data when we get it.

    reply.minorOpcode = AUD_DATA_REPLY;
    reply.replyID = req->reply_id;
    reply.numBits = 0;
    reply.leftPad = 0;

    sendMessage((XaProtoHeader *)&reply, 0, NULL);
}

void	XaClientConnection::PINGprocessMsg(XaPingRequest *req, 
					unsigned long length, Bool swap)
{
    XaPingReply reply;
#ifdef DEBUG
    if (DoDebug())
	printf("PING message on connection %d\n", connectionId);
#endif
    reply.minorOpcode = PING_REPLY;
    reply.replyID = req->reply_id;

    sendMessage((XaProtoHeader *)&reply, 0, NULL);
}

//
// XaClientConnection::sendMessage
//
//	msgHeader	message header with minor opcode filled in
//	dataLen		length of extra data in bytes
//	data		extra data
//	finish		XaFinish callback struct pointer

unsigned long XaClientConnection::sendMessage(XaProtoHeader *msgHeader,
					int	dataLen, 
					char	*data)
{
    unsigned long	sequenceNumber;
    int			msgLen;

// This macro sets up the ICE message header with the IceGetHeader macro,
// copies the rest of the Xa*Header fields into the ICE buffer, and
// sets the message ICE message length field.

#define _XaClientConnection_GetHeader(_opcode, _reqType) \
    _reqType *ptr##_opcode; \
    IceGetHeader(connectionId, iceOpCode, _opcode, \
		sizeof(_reqType), _reqType, ptr##_opcode); \
    memcpy((char *)ptr##_opcode + sizeof(XaProtoHeader),  \
	(char *)msgHeader + sizeof(XaProtoHeader), \
	sizeof(_reqType) - sizeof(XaProtoHeader)); \
    msgLen = sizeof(_reqType) - sizeof(iceMsg) + dataLen; \
    ptr##_opcode->length = (msgLen + 7) >> 3;


    switch (msgHeader->minorOpcode)
	{
	case STARTUP_EVENT:
	    _XaClientConnection_GetHeader(STARTUP_EVENT, XaStartupEvent);
	    break;
	    
	case CHANGE_EVENT:
	    _XaClientConnection_GetHeader(CHANGE_EVENT, XaChangeEvent);
	    break;
	    
	case CREATE_EVENT:
	    _XaClientConnection_GetHeader(CREATE_EVENT, XaCreateEvent);
	    break;
	    
	case DESTROY_EVENT:
	    _XaClientConnection_GetHeader(DESTROY_EVENT, XaDestroyEvent);
	    break;
	    
	case FIND_REPLY:
	    _XaClientConnection_GetHeader(FIND_REPLY, XaFindReply);
	    break;
	    
	case GET_REPLY:
	    _XaClientConnection_GetHeader(GET_REPLY, XaGetReply);
	    break;
	    
	case AUD_DATA_REPLY:
	    _XaClientConnection_GetHeader(AUD_DATA_REPLY,XaAudioDataReply);
	    break;
	    
	case PING_REPLY:
	    _XaClientConnection_GetHeader(PING_REPLY, XaPingReply);
	    break;
	    
	case ERROR_REPLY:
	    _XaClientConnection_GetHeader(ERROR_REPLY, XaErrorReply);
	    break;
	    
	case ERROR_EVENT:
	    _XaClientConnection_GetHeader(ERROR_EVENT, struct XaErrorEvent);
	    break;
	    

	default:
	    fprintf(stderr,
		    "XaClientConnection::sendMessage: Unknown opcode %d\n",
		    msgHeader->minorOpcode);
	    return 0;
	}


    if (dataLen > 0)
	{
	// this is a macro
	IceWriteData(connectionId, dataLen, data);
	}

    if (msgLen % 8 > 0)
	{
	// need to pad to 8-byte boundary
	// this is a macro
	_XaWritePad(connectionId, 8 - (msgLen % 8));
	}

    sequenceNumber = IceLastSentSequenceNumber(connectionId);
    IceFlush(connectionId);


    return sequenceNumber;
}

/*----------------------------------------------------------
** External object description 
*/
#define BABBLE(x) printf(x)

inline XaBoolean XaValidAccess(XaObject *obj, void *tag)
	{ return (tag) ? XaValidType(obj, tag, XaAaccess) : XaTrue; }

inline XaBoolean XaValidKey(XaObject *obj, void *tag)
	{ return (tag) ? XaValidType(obj, tag, XaAkey) : XaTrue; }

inline XaBoolean XaValidExtension(XaObject *obj, void *tag)
	{ return (tag) ? XaValidType(obj, tag, XaAextension) : XaTrue; }

static XaClassDestroyFunc XaConnectionDestroyCB;

XaAttrInitRec XaConnectionAttrInit[] =
{
    {
	XaNdestroyOnClose,	        XaNbool, 
					XaValidBool,
					(void *)XaTrue,
					XaMODE_S_ON_T | XaMODE_G
    },
    {
	XaNclosed,			XaNbool,
					XaValidBool,
					(void *)XaFalse,
					XaMODE_G
    },
    {
	XaNtrusted,			XaNbool,
					XaValidBool,
					(void *)XaTrue,	// Must be set by implementation
					XaMODE_G
    },
    {
	XaNaccess,			XaNtag,
					XaValidAccess,
					(void *)XaTnone,
					XaMODE_S | XaMODE_G
    },
    {
	XaNkey,				XaNtag,
					XaValidKey,
					(void *)XaTnone, // Must be set by implementation
					XaMODE_G
    },
    {
	XaNsuspended,			XaNbool, 
					XaValidBool,
					(void *)XaTrue,
					XaMODE_S_BY_T | XaMODE_G
    },
    {
	XaNobjects,			XaNtag, 	// XXX XaNCollection?
					XaValidBool,
					(void *)XaTnone,
					XaMODE_G
    },
    {
	XaNextensionsInUse,		XaNtag, 	// XXX XaNCollection?
					XaValidExtension,
					(void *)XaTnone,
					XaMODE_C | XaMODE_G
    }
};

XaClassInitRec XaConnectionClassInit =
{
    XaNconnection, XaNobject,
    XA_NULL,
    XaNumber(XaConnectionAttrInit),
    XaMODE_SG, XaMODE_SG,
    XA_NULL, XA_NULL, XA_NULL, XA_NULL, XaConnectionDestroyCB
};

XaErrorCode XaCreateClassConnection(XaConnection *conn)
{
    return (new XaClass(conn, XaAconnection, &XaConnectionClassInit, 
	    XaConnectionAttrInit)) ? XaESuccess : XaEFailure;
}

static void XaConnectionObjectInit(XaObject *connObj, XaClientConnection *conn)
{
    // This routine performs these duties:
    // 1) initialize external state to match internal state
    // 2) Add to server object's list of connections
    // 		#2 could have been done vie create callback

    BABBLE("Intializing external connection object\n");

    // stash away pointer to XaClientConnection
    connObj->ImplData((void *)conn);

    // set trusted field
    //XXX wait until Trusted define on XaClientConnection
    //XXX obj->SetAttribute(obj->Conn(), XaAconnectionTrusted, 
    //XXX	    (void *)conn->Trusted());

    // set key field
    //XXX wait until Key() is implemented on XaClientConnection
    //XXX obj->SetAttribute(obj->Conn(), XaAconnectionKey, (void *)conn->Key());

    // add object to server's collection of connections
    //XXX wait until server object is implemented
}

static XaErrorCode XaConnectionDestroyCB(XaObject *obj)
{
    BABBLE("XaConnectionDestroyCB\n");
    //XXX Some cleanup goes here:
    //XXX   Nuke created objects
    //XXX   Remove from server's list of connections
    return XaESuccess;
}
