/* $XConsortium: buffer.cc /main/6 1996/12/30 16:32:38 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#include "buffer.h"
#include "class.h"
#include "object.h"

//
// A buffer is an object that holds samples.
// This buffer class is an abstract class, i.e., you can create
// an instance of one of the three classes of buffer, but not the
// buffer class itself.
//
XaAttrInitRec XaBufferAttrInit[] =
{
    { 
        XaNformat,        	XaNtag,
                                XaValid,        
                                (void *)XaTnone,
                                XaMODE_SG
    },
    {
        XaNsupportedFormats,  	XaNtag,  // need a collection atom here
                                XaValid,
                                (void *)XaTnone,
                                XaMODE_G
    },
    { 
        XaNlatestTime,    	XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
        XaNearliestTime,  	XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
        XaNbufferSize,  	XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
        XaNdirection,  		XaNatom,
                                XaValid,
                                (void *)XaAinput,
                                XaMODE_CSG
    },
    {
        XaNinputBuffers,     	XaNtag,	// need a collection atom here
                                XaValid,
                                (void *)XaTdefault,
                                XaMODE_CSG
    },
    {
        XaNoutputBuffers,    	XaNtag,	// need a collection atom here
                                XaValid,
                                (void *)XaTdefault,
                                XaMODE_CSG
    }

};

#ifdef DEBUG
#include "config.h"

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".Buffer.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#endif /* DEBUG */


XaBuffer::XaBuffer(XaConnection *c, XaClass *cl,
		   XaTag objectTag, XaTag classTag, XaTag name) :
    XaObject (c, cl, objectTag, classTag, name),
    ringBuffer(NULL), readDelegate(NULL), writeDelegate(NULL) {

}

XaBuffer::~XaBuffer() {
}


static XaErrorCode XaBufferDestroyCB(XaObject *obj)
{
    //XXX Some cleanup goes here:
    //XXX   Nuke created objects
    //XXX   Remove from server's list of connections
    return XaESuccess;
}

XaClassInitRec XaBufferClassInit =
{
    XaNbuffer, XaNobject,
    NULL,
    XaNumber(XaBufferAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XA_NULL, XA_NULL, XA_NULL, XA_NULL, XaBufferDestroyCB
};

XaErrorCode XaCreateClassBuffer(XaConnection *conn)
{
    return (new XaClass(conn, XaAbuffer,
	    &XaBufferClassInit, XaBufferAttrInit)) ? XaESuccess : XaEFailure;
}

XaErrorCode XaBuffer::CacheFormat(XaObject *formatObject)
{
    
    XaAttributeCBData cbd;
    XaErrorCode       err;
    unsigned          value;

#ifdef DEBUG
    if (DoDebug())
	printf("XaBuffer::CacheFormat\n");
#endif
/*
 * Number of channels
 */
    cbd.name = XaAnumChannels;
    err = formatObject->GetAttribute (Conn(), &cbd);
    if (err != XaESuccess)
	return XaEFailure;
    formatCache.numChannels = (CARD32)(unsigned long)cbd.value;
/*
 * Sample Rate
 */
    cbd.name = XaAsampleRate;
    err = formatObject->GetAttribute (Conn(), &cbd);
    if (err != XaESuccess)
	return XaEFailure;
    formatCache.sampleRate = (XaTime)(unsigned long)cbd.value;
/*
 * Bits Per Sample 
 */ 
    cbd.name = XaAbitsPerSample;
    err = formatObject->GetAttribute (Conn(), &cbd);
    if (err != XaESuccess)
	return XaEFailure;
    formatCache.sampleWidth = (CARD32)(unsigned long)cbd.value;
/*
 * Encoding
 */ 
    cbd.name = XaAencoding;
    err = formatObject->GetAttribute (Conn(), &cbd);
    if (err != XaESuccess)
	return XaEFailure;
    formatCache.encoding = (XaAtom)(unsigned long)cbd.value;

    formatCache.bitsPerFrame =
			formatCache.sampleWidth * formatCache.numChannels;

#ifdef DEBUG
    if (DoDebug())
	printf("       channels=%d rate=%d bits=%d encoding=%d bits/frame=%d\n",
	    formatCache.numChannels, formatCache.sampleRate,
	    formatCache.sampleWidth, formatCache.encoding,
	    formatCache.bitsPerFrame);
#endif

    return XaESuccess;
}
