//This line lets emacs recognize this as -*- C++ -*- Code
/* $XConsortium: xasymlib.cc /main/6 1996/12/30 16:32:22 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdlib.h>
#include <string.h>

#include "xasymlib.h"
#include "xastring.h"

/* Right now, this only works for a few platforms. When this is implemented
   for more platforms, remove this define rule. */
#if defined (SVR4) || defined (__osf__) || defined (sco) 

#include <dlfcn.h>

XaErrorCode XaDynamicSymbolLibrary::getSymbol( const XaString &libName,
						 const XaString &symName,
						 void *& symbol) {

    // return values.
    XaErrorCode returnCode = XA_SUCCESS;
    symbol = NULL;

    // Open the library trying the augmented version first ....
    void *libHandle = NULL;
#ifdef LATER
    XaString *libExtension =
        XaProcEnv::getValue(XA_DEBUG_ENV, XA_LINK_LIB_KEY);
    if(libExtension) {
        // We need a copy of the string to work on.
        char *tempStr = (char*) malloc(libName.length() + 1);
        // Copy all but the .so part (this assumes .so is the extension)
        strncpy(tempStr, (const char *)libName, libName.length() - 3);
        tempStr[libName.length() - 3] = '\0';
        XaString extName = tempStr;
        extName.append(*libExtension);
        extName.append(".so");

        libHandle = dlopen(extName, RTLD_LAZY);
    }

    // ... if that didn't work try the original name ...
    if( !libHandle) {
        libHandle = dlopen(libName, RTLD_LAZY);
    }
#endif
    libHandle = dlopen(libName, RTLD_LAZY);
        
    // ... did we get something? ...
    if( libHandle == NULL) {
	// XA_SYMBOL_LIB_BAD_LIBRARY_HANDLE
        returnCode = XA_FAILURE;
    } else {
	// ... yup, so get the symbol.
	// XA_SYMBOL_LIB_BAD_LIBRARY_SYMBOL
	if(( symbol = dlsym(libHandle, symName)) == NULL) {
            returnCode = XA_FAILURE;
        } 
    }
    
    return returnCode;
}

#endif /* sun */

#ifdef hpux

#include <cxxdl.h>

XaErrorCode XaDynamicSymbolLibrary::getSymbol( const XaString &libName,
						 const XaString &symName,
						 void *& symbol) 
{

    // return values.
    XaErrorCode returnCode = XA_SUCCESS;
    symbol = NULL;

    // Open the library trying the augmented version first ....
    shl_t libHandle = NULL;
    libHandle = shl_load(libName, 
	    BIND_DEFERRED | DYNAMIC_PATH, 0L);
        
    // ... did we get something? ...
    if( libHandle == NULL) {
	// XA_SYMBOL_LIB_BAD_LIBRARY_HANDLE
        returnCode = XA_FAILURE;
    } else {
	// ... yup, so get the symbol.
	void *addr;
	if(shl_findsym(&libHandle, symName, TYPE_PROCEDURE, &addr)) {
	    // XA_SYMBOL_LIB_BAD_LIBRARY_SYMBOL
            returnCode = XA_FAILURE;
        } 
	symbol = addr;
    }
    
    return returnCode;
}

#endif /* hpux */
