//This line lets emacs recognize this as -*- C++ -*- Code
/* $XConsortium: xastring.cc /main/3 1996/12/30 16:32:15 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//------------------------------------------------------------------------
//
//  File:	XaString.cc
//  Project:	XA
//  Created:	@(#)
//  RespEngr:	Erling Wold
//  Revision:	1.40
//  Last Mod:	15:49:43, 02 Jun 1994
//
//  Description:
//		A class for generic string operations.
//	
//	
//	
//	
//------------------------------------------------------------------------
//
//
// "@(#)XaString.cc	1.40\t94/06/02 "

#include "xastring.h"
#include "collectable.h"
#include "pointer.h"
#include <stdlib.h>

#include <string.h>

//
// Constructors
//

XaString::XaString() 
{ 
    string = (char*) malloc(XA_DEFAULT_STRING_SIZE);
    allocSize = XA_DEFAULT_STRING_SIZE;
    strcpy(string, "");
}

XaString::XaString(const char* cs) 
{ 
    allocSize = strlen(cs)+1;
    string = (char*) malloc(allocSize);
    strcpy(string, cs);
}

XaString::XaString(const XaString &s) 
{ 
    allocSize = strlen(s.string)+1;
    string = (char*) malloc(allocSize);
    strcpy(string, s.string);
}

XaString::XaString(const char *cs, int N) 
{ 
    string = (char*) malloc(N+1);
    allocSize = N+1;
    if (string != 0)
    {
	string[N] = '\0';
	strncpy(string, cs, N);
    }
}

XaString::~XaString()
{
    if (string != 0)
	free(string);
}

// operator =
XaString& XaString::operator=(const XaString& s)
{
    operator=(s.string);
    return (*this);
}

XaString& XaString::operator=(const char* cs)
{
    int neededSize = strlen(cs) + 1;

    if (allocSize < neededSize)
    {
	string = (char*) realloc(string, neededSize);
	if (string == 0)
	    return(*this);	// REMIND: we are totally messed up here!
    }
    strcpy(string, cs);
    return (*this);
}

// append methods

XaErrorCode XaString::append(const XaString& s)
{
    return append(s.string);
}

XaErrorCode XaString::append(const char* cs)
{
  int neededSize = strlen(string) + strlen(cs) + 1;
  
  if (allocSize < neededSize)
    {
      string = (char*) realloc(string, neededSize);
      if (string == 0)
	return XA_OUT_OF_MEMORY;
    }
  strcat(string, cs);
  return XA_SUCCESS;
}

long XaString::length(void) const
{
    return strlen(string);
}

//
// Type conversion.
//

XaString::operator const char *() const 
{
    return (const char*) string;
}

XaCollectable* XaString::copy(void) const
{
    char *ptr = (char*) malloc(allocSize);
    strcpy(ptr, string);
    return (new XaPointer (ptr));
}

unsigned XaString::hash(void) const 
{
    unsigned h = 0;
    int i;

    for (i=0; i<strlen(string); i++)
	h ^= (unsigned) string[i];

    return h;
}

// bit wise comparison.
XaBoolean XaString::equals(const XaCollectable& str) const 
{
//
// Warning: If str is not an XaString, we're hosed.
//
    XaString &s = (XaString &)str;

    if (strcmp (string, s.string) != 0)
      return XA_FALSE;
    else
      return XA_TRUE;
}

// return XA_TRUE if this is the null string.
XaBoolean XaString::isNull() const 
{
    return (strcmp(string, "") == 0);
}

XaBoolean operator==(const XaString &str1, const XaString &str2) 
{
    return (strcmp (str1.string, str2.string) == 0);
}

XaBoolean operator!=(const XaString &str1, const XaString &str2) 
{
    return (strcmp (str1.string, str2.string) != 0);
}

XaBoolean operator==(const XaString &str1, const char *s2) 
{
    return (strcmp(str1.string, s2) == 0);
}

XaBoolean operator!=(const XaString &str1, const char *s2) 
{
    return (strcmp(str1.string, s2) != 0);
}

XaBoolean operator==(const char *s1, const XaString &str2) 
{
    return (strcmp(s1, str2.string) == 0);
}

XaBoolean operator!=(const char *s1, const XaString &str2) 
{
    return (strcmp(s1, str2.string) != 0);
}

char& XaString::operator[](int i)
{
    return string[i];
}
