/* $XConsortium: fmt_basic_test.cc /main/2 1996/12/30 16:32:07 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdlib.h>
#include <stdio.h>
#include <Xa/Xalib.h>
#include <X11/Xmd.h>
#include "connection.h"
#include "class.h"

/*
** redefine defaults - these exist separately here from the format 
** module to double-check them.
*/
#define FMT_DEFAULT_ENCODING	    XaTencodeLinear
#define FMT_DEFAULT_ENDIAN	    XaTrue
#define FMT_DEFAULT_NUM_CHANS	    1
#define FMT_DEFAULT_SAMPLE_WIDTH    8
#define FMT_DEFAULT_SAMPLE_RATE	    8000


#define INSERT_TESTS

BOOL testSetAttribute(XaConnection *conn, XaObject *fmt, XaAtom attrName, 
	XaTag type, void *newAttr)
{
    int equal;
    void    *testPtr = NULL;
    BOOL testPassed = XaTrue;
    XaErrorCode err;
    
    err = fmt->SetAttribute(conn, attrName, newAttr);
    if (!err)
    {
	err = fmt->GetAttribute(conn, attrName, testPtr);
	if (err != XaESuccess)
	{
	    printf("Err %d when setting %s.\n", err, attrName);
	    testPassed = XaFalse;
	}
	// compare values, don't get caught up in implementation
	switch(type)
	{
	case XaTatom:
	    equal = (((XaAtom) testPtr) == ((XaAtom) newAttr));
	    break;
	case XaTbool:
	    equal = (((BOOL) testPtr) == ((BOOL) newAttr));
	    break;
	case XaTcard32:
	    equal = (((CARD32) testPtr) == ((CARD32) newAttr));
	    break;
	default:
	    printf("Bad type specification (%d) for attribute %s.\n",
		   type, attrName);
	}
	if (!equal)
	{
	    printf("%s doesn't set properly, new value doesn't match.\n",
		   attrName);
	    testPassed = XaFalse;
	}
    }
    else
    {
	printf("Err %d when setting %s.\n", err, attrName);
	testPassed = XaFalse;
    }

    return testPassed;
}

BOOL
testDefaultAttrs(void *enc, void *end, void *chan,
		 void *width, void *rate)
{
    BOOL testPassed = XaTrue;
    
    if ((XaTag)enc != FMT_DEFAULT_ENCODING)
    {
	printf("Unspecified format encoding doesn't match default (%d).\n",
	       enc);
	testPassed = XaFalse;
    }
    if ((XaBoolean)end != FMT_DEFAULT_ENDIAN)
    {
	printf("Unspecified format endian doesn't match default (%d).\n",
	       (int) end);
	testPassed = XaFalse;
    }
    if ((int)chan != FMT_DEFAULT_NUM_CHANS)
    {
	printf("Unspecified format #chans doesn't match default (%d).\n",
	       chan);
	testPassed = XaFalse;
    }
    if ((int)width != FMT_DEFAULT_SAMPLE_WIDTH)
    {
	printf("Unspecified format sample width doesn't match default (%d).\n",
	       width);
	testPassed = XaFalse;
    }
    if ((int)rate != FMT_DEFAULT_SAMPLE_RATE)
    {
	printf("Unspecified format sample rate doesn't match default (%d).\n",
	       rate);
	testPassed = XaFalse;
    }
    return testPassed;
}

#ifdef INSERT_TESTS
int fmt_basic_test(XaConnection *conn)
#else
int main(int, char**)
#endif
{
    XaObject       *fmt;
    XaErrorCode    err;
    void           *temp;
    XaAtom         enc, newEnc;
    BOOL           end, newEnd;
    CARD32         chan, newChan;
    CARD32         width, newWidth;
    CARD32         rate, newRate;
    BOOL           testPassed = XaTrue;
    XaTag          dummyObjTag = 0x4001;	/*XXX*/
    XaTag          dummyNameTag = 0x4002;	/*XXX*/

    // Try to create it.
    printf("Creating format.\n");
    fmt = XaCreateObject(conn, XaTformat, dummyObjTag, dummyNameTag, NULL, 0);

    // Poll the attributes to make sure the default values
    // were set correctly.
    printf("Getting format attributes.\n");

    // First, get the attributes individually.

    printf("Getting attributes with many GetAttribute calls.\n");
    err = fmt->GetAttribute(conn, XaAformatEncoding, temp);
    if (err == XaESuccess)
    {
	enc = (XaAtom) temp;
	err = fmt->GetAttribute(conn, XaAformatEndian, temp);
    }
    if (err == XaESuccess)
    {
	end = (BOOL) temp;
	err = fmt->GetAttribute(conn, XaAformatNumChannels, temp);
    }
    if (err == XaESuccess)
    {
        chan = (CARD32) temp;
	err = fmt->GetAttribute(conn, XaAformatSampleWidth, temp);
    }
    if (err == XaESuccess)
    {
	width = (CARD32) temp;
	err = fmt->GetAttribute(conn, XaAformatSampleRate, temp);
    }
    if (err == XaESuccess)
	rate = (CARD32) temp;
    else
    {
	printf("Couldn't get format attributes (err %d).\n", err);
	testPassed = XaFalse;
    }

    printf("Comparing returned attributes.\n");
    if (testDefaultAttrs((void *)enc, (void *)end, (void *)chan, 
	    (void *)width, (void *)rate) == XaFalse)
	testPassed = XaFalse;

    // Now get the attributes as a single call to GetAttributes.

    printf("Getting attributes with one GetAttributes call.\n");
    err = fmt->GetAttributes(conn, XaAformatEncoding, temp,
			     XaAformatEndian, end,
			     XaAformatNumChannels, chan,
			     XaAformatSampleWidth, width,
			     XaAformatSampleRate, rate,
			     NULL);

    if (err == XaESuccess)
	enc = (XaAtom) temp;
    else
    {
	printf("Couldn't get attributes using GetAttributes.\n");
	testPassed = XaFalse;
    }

    printf("Comparing returned attributes.\n");
    if (testDefaultAttrs((void *)enc, (void *)end, (void *)chan, (void *)width,
	    (void *)rate) == XaFalse)
	testPassed = XaFalse;

    //
    // Now, try to set attributes on this format.
    //

    if (testSetAttribute(conn, fmt, XaAformatEncoding, XaTatom,
			  (void *)XaTencodeUlaw) == XaFalse)
	testPassed = XaFalse;

    if (testSetAttribute(conn, fmt, XaAformatEndian, XaTbool,
			  (void *)XaFalse) == XaFalse)
	testPassed = XaFalse;

    if (testSetAttribute(conn, fmt, XaAformatNumChannels, XaTcard32,
			  (void *)8888L) == XaFalse)
	testPassed = XaFalse;
    if (testSetAttribute(conn, fmt, XaAformatSampleWidth, XaTcard32,
			  (void *)5555) == XaFalse)
	testPassed = XaFalse;
    if (testSetAttribute(conn, fmt, XaAformatSampleRate, XaTcard32,
			  (void *)44050) == XaFalse)
	testPassed = XaFalse;

    // Destroy the format.
    delete fmt;

    if (testPassed)
	printf("*** Test suite PASSED. ***\n");
    else
	printf("*** Test suite FAILED. ***\n");
}
