/*
** The purpose of this test is to see in the class and object code work on
** the client side.  This test circumvents the library API for its testing.
*/

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <Xa/Xafuncs.h>
#include <Xa/atomstrings.h>
#include <Xa/atomdefs.h>
#include "class.h"
#include "object.h"
#include "serverconn.h"

extern XaCreateClassFunc XaCreateClassCore;

main (int argc, char* argv[])
{
    XaAudio	audio;
    char	errString[256];
    XaTag	tag;

    fprintf(stderr,"Creating connection.\n");
    audio = XaOpenAudio(NULL, errString, &argc, argv);

    if (!audio)
    {
	fprintf(stderr, errString);
	exit(1);
    }
    else
	fprintf(stderr, "Connection Opened\n");
    XaServerConnection *conn = (XaServerConnection *)audio;

    /* add a class */
    if (XaCreateClassCore(conn) != XaESuccess)
    {
	fprintf(stderr, "couldn't create class\n");
	exit(2);
    }
    else
	fprintf(stderr, "Class Created\n");

    /*
    ** test to see if class is in classDB
    */
    XaClass *classObject = (XaClass *)conn->ClassDB().find(XaAobject);

    if(!classObject)
    {
	fprintf(stderr, "could not find class object\n");
	exit(3);
    }

    /* create an object */
    XaObject *object = XaCreateObject(conn, XaAobject, 0x87654321, XaTnone, 
	    XA_NULL, 0);

    if(!object)
    {
	fprintf(stderr, "object not created\n");
	exit(4);
    }

    /*
    ** test to see if object is in objectDB
    */
    XaObject *objectRet = (XaObject *)conn->ObjectDB().find(0x87654321);

    if(!objectRet)
    {
	fprintf(stderr, "could not find object in DB\n");
	exit(5);
    }
    else
	fprintf(stderr, "Object created\n");

    conn->ObjectDB().remove(object->Tag());
    delete object;
    fprintf(stderr, "Object destroyed\n");
    XaCloseAudio(audio);
}
