/* $XConsortium: class_basic_test.cc /main/2 1996/12/30 16:31:57 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include "class.h"
#include "tagrange.h"

/*
** This is a test program, which currently works by linking it into the 
** server.  Do this on the link line ahead of dia/classes.cc, since it replaces
** XaCreateWellKnownClasses.
*/

XaTag XaGetNewTag()
{
    static XaTagRangeFactory factory;
    static XaTagRange *range;
    if (range == XA_NULL)
    {
	factory.Init(2048);		// XXX discard parse tags & atoms
        factory.GetTagRange(range);
    }
    return range->GetNewTag();
}

#define INSERT_TESTS
#ifdef INSERT_TESTS
extern int fmt_basic_test(XaConnection *);
#endif /* INSERT_TESTS */

extern XaDictionary XaClassDB;
extern XaCreateClassFunc XaCreateClassCore;
extern XaCreateClassFunc XaCreateClassFormat;

XaCreateWellKnownClasses(XaConnection *conn)
{
    XaAtom asuper = conn->findAtom(XaNobject, XaFalse);
    if (asuper != XaTobject)
	printf ("Bad tag: %s defined as %d, found as %d\n", 
		XaNobject, XaTobject, asuper);
    XaCreateClassCore(conn);
    XaCreateClassFormat(conn);

    printf("there are %d defined classes\n", XaClassDB.entries());
    XaObject *newFormat = 
	    XaCreateObject(conn, XaTformat, XaGetNewTag(), XaTnone, XA_NULL, 0);
    if (newFormat)
	printf("Created new format!\n");
    newFormat = 
	    XaCreateObject(conn, XaTformat, XaGetNewTag(), XaTnone, XA_NULL, 0);
    if (newFormat)
	printf("	made it again!\n");

    fmt_basic_test(conn);
    
}
