/* $XConsortium: varargs.cc /main/2 1996/12/30 16:31:34 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: varargs.cc $ $Revision: /main/2 $ (DEC) $Date: 1996/12/30 16:31:34 $
// 
#include <Xa/Xalib.h>
#include <Xa/Xaprotocol.h>
#include "serverconn.h"
#include <Xa/atomstrings.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

//
// process the varargs list putting protocol into the XaServerConnection
// protocolBuffer
//
void XaServerConnection::processVarargs(va_list argp, XaFinish *& finish)
{
    va_list	arg;
    char	*itemName;
    XaAtom 	nameAtom;


    // not necessary, prob. shouldn't be reset here.
    // protocolBuffer.Reset();
    

    while (itemName = va_arg(argp, char *))
	{
	nameAtom = findAtom(itemName, TRUE, NULL);

	switch (nameAtom)
	    {
	    case XaAarray:
	    case XaAcollectionReplace:
	    case XaAcollectionAdd:
	    case XaAcollectionSubtract:
		{
		long		length = va_arg(argp, long);
		char		*attrName = va_arg(argp, char *);
		XaArgVal	arrayPtr = va_arg(argp, XaArgVal);

		addProtoArray(nameAtom, length, attrName, arrayPtr);
		break;
		}

	    default:
		{
		processArg(nameAtom, va_arg(argp, XaArgVal), finish);
		}
	    }
    }
}

//
// Process an argList (not varargs) and write the results to the protocol
// buffer.
//
void XaServerConnection::processArgList(XaArgList arglist, XaFinish *& finish)
{
    XaArgList	argListPtr;


    argListPtr = arglist;

    while (argListPtr && argListPtr->name && argListPtr->name[0])
	{
	char	*itemName = argListPtr->name;
	XaAtom 	nameAtom = findAtom(itemName, TRUE, NULL);

	switch (nameAtom)
	    {
	    case XaAarray:
	    case XaAcollectionReplace:
	    case XaAcollectionAdd:
	    case XaAcollectionSubtract:
		{
		long	length;

		length = (long)argListPtr->value;
		argListPtr++;

		addProtoArray(nameAtom, length, argListPtr->name,
				argListPtr->value);
		}
	    default:	
		{
		processArg(nameAtom, argListPtr->value, finish);
		}
	    }
	argListPtr++;
	}
}

//
// Processes non-array type items and writes them to the protocol buffer.
//
void XaServerConnection::processArg(XaAtom name, XaArgVal value, XaFinish *& finish)
{

#define NYI fprintf(stderr, "%s item not yet implemented.\n", name);

    switch (name)
	{
        case XaAargList:
	    {
	    XaArgList arglist;

	    arglist = (XaArgList)value;
	    processArgList(arglist, finish);
	    break;
	    }
#if 0
    // XXXXXXXX  These are not yet defined
	case XaAfinish:
	    {
	    finish = (XaFinish *)value;
	    break;
	    }
	case XaAfetchArgs:
	    {
	    NYI;
	    break;
	    }
	case XaAarrayPart:
	case XaAatTime:
	case XaAafterTime:
	    {
	    NYI;
	    break;
	    }
#endif
	default:
	    // This includes XaPtype, value must be an Atom
	    {
	    // double cast to avoid a compiler warning
	    addProtoItem(name, (CARD32)(unsigned long)value);
	    }
    }
}

//
// Write a simple item name and value to the protocol buffer.
//
void XaServerConnection::addProtoItem(XaAtom name, CARD32 value)
{
    XaProtoItem	item;

    item.name = name;
    item.value = value;

    protocolBuffer.Write((char *)&item, sizeof(XaProtoItem));
}

//
// This is used to write Arrays and Collections to the protocol buffer.
// WARNING:  Assumes that array elements are sizeof(CARD32)!!
//
void XaServerConnection::addProtoArray(XaAtom name, CARD32 length, 
				char *attrName, XaArgVal arrayPtr)
{
    XaProtoArray arrayItem;

    arrayItem.arrayAtom = name;
    arrayItem.length = length;
    arrayItem.name = findAtom(attrName, TRUE, NULL);

    protocolBuffer.Write((char *)&arrayItem, sizeof(XaProtoArray));
    protocolBuffer.Write((char *)arrayPtr, length * sizeof(CARD32));
}

