/* $XConsortium: set.cc /main/2 1996/12/30 16:31:31 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: set.cc $ $Revision: /main/2 $ (DEC) $Date: 1996/12/30 16:31:31 $
// 
#include <stdarg.h>
#include <Xa/Xalib.h>
#include "serverconn.h"
#include <Xa/Xaprotocol.h>

void XaSet(XaAudio connection, XaTag object, ...)
{
    va_list	argp;

    XaServerConnection *conn = (XaServerConnection *)connection;
    
//
// Check if this object is in the client object database.
//
    XaObject *obj = (XaObject *)conn->ObjectDB().find(object);
//
// If it is, then set the attributes on the client side
//
    if (obj) {
      va_start(argp, object);
      conn->set(obj, argp);
      va_end(argp);
    }
//
// otherwise, send the message to the server.
//
    else {
      va_start(argp, object);
      ((XaServerConnection *)connection)->set(object, argp);
      va_end(argp);
    }
}

void XaServerConnection::set(XaObject *object, va_list argp)
{
    XaAttributeCBData   cbd;
    char 	       *itemName;
    void 	       *value;
    XaServerConnection *conn = (XaServerConnection *)object->Conn();

    while (itemName = va_arg(argp, char *)) {
      XaAtom nameAtom = conn->findAtom (itemName, TRUE, NULL);
      value = va_arg (argp, void *);
      cbd.name = nameAtom;
      cbd.value = value; 
      object->SetAttribute (conn, &cbd);
    }
}

void XaServerConnection::set(XaTag object, va_list argp)
{
    XaSetRequest req;
    XaFinish *finish = NULL;
    XaProtoReply *reply;

    req.minorOpcode = SET;
    req.object = object;

    protocolBuffer.Lock();
    processVarargs(argp, finish);

    // If the attribute list needs to be null-terminated --
    // addProtoItem(NULL, 0);

    sendMessage((XaProtoHeader *)&req, protocolBuffer.ProtoLength(), 
		protocolBuffer.Buffer(), finish, reply);

    protocolBuffer.Unlock();
}
