/* $XConsortium: serverconn.h /main/5 1996/12/30 16:31:28 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: serverconn.h $ $Revision: /main/5 $ (DEC) $Date: 1996/12/30 16:31:28 $
// 

#ifndef SERVERCONN_H
#define SERVERCONN_H

extern "C" {
#include <sys/types.h>
#include <string.h>
#include <stdarg.h>
#include <X11/Xmd.h>
#include <X11/ICE/ICElib.h>
#include <X11/ICE/ICEproto.h>
struct _XtransConnInfo;  // missing decl. in ICEconn.h
#include <X11/ICE/ICEmsg.h>
}

#include <Xa/Xaprotocol.h>

#include <Xa/Xalib.h>
#include <Xa/Xafuncs.h>
#include "dictionary.h"
#include "connection.h"
#include "object.h"
#include "tagrange.h"
#include "tagcounter.h"

// Client's connection to the server

class XaServerConnection : public XaProtocolConnection
{

private:

    int		authCount;
    char	*authNames[1];

    IcePoAuthProc authProcs[1];
    int		versionCount;
    IcePoVersionRec versions;
    static void pingReplyProc(IceConn, IcePointer);

    fd_set	readMask;

    XaTagCounter tagCounter;
    XaTagCounter clientSideTagCounter;
    XaBag        remoteTagRanges;

    XaTag	connectionTag;
    XaTag	serverTag;

    // Object storage
    XaScalarBag classDB;
    XaScalarBag objectDB;

    friend void XaCloseAudio(XaAudio);
    friend void XaFlush(XaAudio);
    friend void XaDestroy(XaAudio, XaTag);
    friend int XaServerConnectionNumber(XaAudio connection);
    friend void XaXtProcessEvents(XtPointer connection, int *fd, XtInputId *id);

    void processVarargs(va_list argp, XaFinish *& finish);
    void processArgList(XaArgList arglist, XaFinish *& finish);
    void processArg(XaAtom name, XaArgVal value, XaFinish *& finish);
    void addProtoItem(XaAtom name, CARD32 value);
    void addProtoArray(XaAtom name, CARD32 length,
			char *attrName, XaArgVal arrayPtr);

    // Tag handing
    XaTag NewTag(void);

    XaTag NewClientSideTag();
    virtual void ReleaseTag(XaTag tag);

    void STARTUP_EVENTprocessMsg(XaStartupEvent *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void CHANGE_EVENTprocessMsg(XaChangeEvent *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void CREATE_EVENTprocessMsg(XaCreateEvent *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void DESTROY_EVENTprocessMsg(XaDestroyEvent *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void FIND_REPLYprocessMsg(XaFindReply *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void GET_REPLYprocessMsg(XaGetReply *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void AUD_DATA_REPLYprocessMsg(XaAudioDataReply *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void PING_REPLYprocessMsg(XaPingReply *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void ERROR_REPLYprocessMsg(XaErrorReply *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);
    void ERROR_EVENTprocessMsg(XaErrorEvent *event, unsigned long length,
			      Bool swap, IceReplyWaitInfo *replyWait,
			      Bool *replyReadyRet);

public:

    XaServerConnection();
    ~XaServerConnection();

    virtual XaAtom	findAtom(char *name, XaBoolean create);

    virtual XaScalarBag &ClassDB();
    virtual XaScalarBag &ObjectDB();

    virtual XaConnection * Narrow(const char * className);

    int setup();
    static void processMsgProc(IceConn, IcePointer, int, unsigned long, Bool,
			IceReplyWaitInfo *, Bool *);
    static void errorHandler(IceConn);
    int open(char *networkIds);
    char errorBuf[128];

    int pingServer(void);

    XaArgVal sendMessage(XaProtoHeader *msgHeader,
			    int		dataLen, 
			    char	*data, 
			    XaFinish 	*finish,
			    XaProtoReply *& reply);

    void	set(XaTag object, va_list argp);
    void	set(XaObject *object, va_list argp);
    XaArgList	findObject(XaTag classId, XaFinish *finish, va_list argp);
    XaArgList	findObject(XaTag classId, XaFinish *finish, ...);
    XaAtom	findAtom(char *name, XaBoolean create, XaFinish *finish);
    CARD32      noOfAttrs(va_list argp);
    XaTag	create(ATOM classAtom, va_list argp);
    XaTag       create(ATOM classAtom, CARD32 noOfattrs, va_list argp);
    void	destroy(XaTag object);
    XaArgList	get(XaTag object, XaFinish *finish, va_list argp);
    XaArgList	get(XaTag object, XaFinish *finish, ...);
    XaArgList	get(XaObject *object, XaFinish *finish, CARD32, va_list);
    void	read(XaTag port, XaTime atTime, XaTag referenceTime,
		    Card32 minBits, Card32 maxBits,
		    char **buff, Card32 *bitsReturned, Int8 *leftPad,
		    XaFinish *finish);
    void	write(XaTag port, XaTime when, XaTag referenceTime,
		     char *data, Card32 lengthInBits, Card8 leftPad,
		     XaFinish *finish);
    void	ping(XaBoolean discard, XaFinish *finish);

    void	mainLoop();

};

struct XaReplyWaitInfo
{
    CARD32		replyID;
    XaArgVal		*returnData;
};


#endif /* SERVERCONN_H */
