/* $XConsortium: get.cc /main/2 1996/12/30 16:31:10 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: get.cc $ $Revision: /main/2 $ (DEC) $Date: 1996/12/30 16:31:10 $
// 
#include <stdarg.h>
#include <stdlib.h>
#include <assert.h>
#include <Xa/Xalib.h>
#include "serverconn.h"
#include <Xa/Xaprotocol.h>

XaArgList XaGet(XaAudio connection, XaTag object, XaFinish *finish, ...)
{
    va_list	argp;
    XaArgList	retArgList;

    XaServerConnection *conn = (XaServerConnection *)connection;

//
// Check if this object is in the client object database.
//
    XaObject *obj = (XaObject *)conn->ObjectDB().find(object);
//
// If it is, then Get the attributes from the client side
// Warning: ignoring finish callback.
//
    if (obj) {
      CARD32 noOfAttrs = 0;
      char  *itemName;

      // count the number of attrs.
      va_start(argp, finish);
      while (itemName = va_arg(argp, char *))
        noOfAttrs++;
      va_end(argp);

      // 
      va_start(argp, finish);
      retArgList = conn->get(obj, finish, noOfAttrs, argp);
      va_end(argp);
    }
//
// otherwise, get the attributes from the server
//
    else {
      va_start(argp, finish);
      retArgList = ((XaServerConnection *)connection)->get(object, finish, argp);
      va_end(argp);
    }

    return retArgList;
}

XaArgList XaServerConnection::get(XaTag object, XaFinish *finish, ...)
{
    va_list	argp;
    XaArgList	retArgList;


    va_start(argp, finish);
    retArgList = get(object, finish, argp);
    va_end(argp);

    if (finish)
      finish->finishProc(finish->clientData);

    return retArgList;
}

XaArgList XaServerConnection::get(XaTag object, XaFinish *finish, va_list argp)
{
    XaGetRequest req;
    char	*attrName;
    XaArgList	retArgList;
    XaGetReply	*reply;
    XaProtoReply *protoReply;

    req.minorOpcode = GET;
    req.object = object;
    req.n_attributes = 0;

    // Can't use processVarargs because this is a simple list of attribute
    // names.
    // processVarargs(argp, finish);

    protocolBuffer.Lock();

    while ((attrName = va_arg(argp, char *)) && attrName[0])
	{
	ATOM newAtom = findAtom(attrName, TRUE, NULL);
	req.n_attributes++;

	protocolBuffer.Write((char *)&newAtom, sizeof(ATOM));
	}

    retArgList = (XaArgList)sendMessage((XaProtoHeader *)&req,
					protocolBuffer.ProtoLength(), 
					protocolBuffer.Buffer(), finish, 
					protoReply);

    reply = (XaGetReply  *)protoReply;

    protocolBuffer.Unlock();


    return retArgList;
}

XaArgList XaServerConnection::get(XaObject *object, XaFinish *finish, 
			 	  CARD32 noOfAttrs, va_list argp)
{
    XaAttributeCBData cbd;
    XaErrorCode       err;
    XaServerConnection *conn = (XaServerConnection *)object->Conn();
    XaArgList           retArgList = new XaArgs[noOfAttrs+1];
    CARD32              count = 0;
    char	       *itemName;
  
    while (itemName = va_arg(argp, char *)) {
      XaAtom nameAtom = conn->findAtom (itemName, TRUE, NULL);
      cbd.name = nameAtom;
      err = object->GetAttribute(conn, &cbd);
      if (err == XaESuccess) {
         retArgList[count].name = itemName;
         retArgList[count].value = XaArgVal (cbd.value);
	 count++;
      }
    }
//
// Null terminate it.
//
    retArgList[count].name = NULL;
    retArgList[count].value = NULL;
    
    return retArgList;
}
