/* $XConsortium: events.cc /main/6 1996/12/30 16:31:03 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// 
// @(#)$RCSfile: events.cc $ $Revision: /main/6 $ (DEC) $Date: 1996/12/30 16:31:03 $
// 

#include "serverconn.h"
#include <Xa/Xaprotocol.h>

void XaServerConnection::processMsgProc(IceConn iceConn, IcePointer clientData, 
				    int opcode, unsigned long length, 
				    Bool swap, IceReplyWaitInfo *replyWait, 
				    Bool *replyReadyRet)
{
    XaServerConnection *thisConn = (XaServerConnection *)clientData;

    //
    // parse the reply
#ifdef DEBUG
    printf("XaServerConnection::processMsgProc called\n");
    printf(" received audio protocol opcode %d\n", opcode);
#endif


  //  This macro sets up the ICE message header with the IceGetHeader
  //  macro, copies the rest of the Xa*Header fields into the ICE buffer,
  //  and sets the message ICE message length field.

#define _XaServerConnection_ReadHeader(_opcode, _reqType) 		\
    _reqType *ptr##_opcode; 						\
    IceReadMessageHeader(iceConn, sizeof(_reqType), _reqType, ptr##_opcode); \
    if (swap)								\
	Swap32((CARD32 *)ptr##_opcode + 2, (sizeof(_reqType) - 8)/4);	\
    thisConn->_opcode##processMsg(ptr##_opcode, length, swap, replyWait, \
				replyReadyRet);


    switch (opcode)
	{
	char *data;

	case STARTUP_EVENT:
	    _XaServerConnection_ReadHeader(STARTUP_EVENT, XaStartupEvent);
	    break;

	case CHANGE_EVENT:
	    _XaServerConnection_ReadHeader(CHANGE_EVENT, XaChangeEvent);
	    break;

	case CREATE_EVENT:
	    _XaServerConnection_ReadHeader(CREATE_EVENT, XaCreateEvent);
	    break;

	case DESTROY_EVENT:
	    _XaServerConnection_ReadHeader(DESTROY_EVENT, XaDestroyEvent);
	    break;

	case FIND_REPLY:
	    _XaServerConnection_ReadHeader(FIND_REPLY, XaFindReply);
	    break;

	case GET_REPLY:
	    _XaServerConnection_ReadHeader(GET_REPLY, XaGetReply);
	    break;

	case AUD_DATA_REPLY:
	    _XaServerConnection_ReadHeader(AUD_DATA_REPLY, XaAudioDataReply);
	    break;

	case PING_REPLY:
	    _XaServerConnection_ReadHeader(PING_REPLY, XaPingReply);
	    break;

	case ERROR_REPLY:
	    _XaServerConnection_ReadHeader(ERROR_REPLY, XaErrorReply);
	    break;

	case ERROR_EVENT:
	    _XaServerConnection_ReadHeader(ERROR_EVENT, XaErrorEvent);
	    break;

	default:
	    fprintf(stderr, 
		    "XaServerConnection::processMsgProc: Unknown opcode %d\n",
		    opcode);
	}

    return;
}

void XaServerConnection::STARTUP_EVENTprocessMsg(XaStartupEvent *event,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{

    if (sizeof(XaStartupEvent) % 8)
	IceReadPad(connectionId, 8 - (sizeof(XaStartupEvent) % 8));

    // Create a local XaTagRange structure corresponding to
    // the range received from the server.
    tagCounter.SetRangeWithLength(event->tagRangeTag + 1,
				  event->tagRangeLength);

    // Record the tag for the remote tag range
    remoteTagRanges.insert(*(new XaCTag(event->tagRangeTag)));

    connectionTag = event->connection;
    serverTag = event->server;

    if (replyWait)
	{
	// Event cannot be a reply.
	*replyReadyRet = False;
	}
}



void XaServerConnection::CHANGE_EVENTprocessMsg(XaChangeEvent *event,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;

#ifdef DEBUG
    printf("CHANGE_EVENT message\n" );
#endif

    maxLen = length * 8 - (sizeof(XaChangeEvent) - sizeof(XaProtoHeader));


    if (maxLen)
	{
	int numAttr, triggerCount = 0;
	XaArgList attributes;
	TAG *triggers, *triggerPtr;

	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);

	triggers = (TAG *)buffer;
	buffer += event->triggerCount * sizeof(TAG);

	attributes = (XaArgList)parseParamList((XaProtoItem *)buffer,
		    maxLen, numAttr, True);
	
	triggerPtr = triggers;
	while (*triggerPtr && (triggerCount < event->triggerCount))
	    {
	    //
	    // find the event handlers using the trigger Tags.
	    // Call the event handlers' callbacks with the attributes.
	    //
	    triggerPtr++;
	    triggerCount++;
	    }

	protocolBuffer.Unlock();
	}


    if (replyWait)
	{
	// Event cannot be a reply.
	*replyReadyRet = False;
	}
}


void XaServerConnection::CREATE_EVENTprocessMsg(XaCreateEvent *event,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;


#ifdef DEBUG
    printf("CREATE_EVENT message\n" );
#endif

    maxLen = length * 8 - (sizeof(XaCreateEvent) - sizeof(XaProtoHeader));


    if (maxLen)
	{
	int numAttr, triggerCount = 0;
	XaArgList attributes;
	TAG *triggers, *triggerPtr;

	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);

	triggers = (TAG *)buffer;
	buffer += event->triggerCount * sizeof(TAG);

	attributes = (XaArgList)parseParamList((XaProtoItem *)buffer,
		    maxLen, numAttr, True);
	
	triggerPtr = triggers;
	while (*triggerPtr && (triggerCount < event->triggerCount))
	    {
	    //
	    // find the event handlers using the trigger Tags.
	    // Call the event handlers' callbacks with the attributes.
	    //
	    triggerPtr++;
	    triggerCount++;
	    }

	protocolBuffer.Unlock();
	}


    if (replyWait)
	{
	// Event cannot be a reply.
	*replyReadyRet = False;
	}
}


void XaServerConnection::DESTROY_EVENTprocessMsg(XaDestroyEvent *event,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;

    maxLen = length * 8 - (sizeof(XaDestroyEvent) - sizeof(XaProtoHeader));


    if (maxLen)
	{
	int numAttr, triggerCount = 0;
	XaArgList attributes;
	TAG *triggers, *triggerPtr;

	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);

	triggers = (TAG *)buffer;
	buffer += event->triggerCount * sizeof(TAG);

	attributes = (XaArgList)parseParamList((XaProtoItem *)buffer,
		    maxLen, numAttr, True);
	
	triggerPtr = triggers;
	while (*triggerPtr && (triggerCount < event->triggerCount))
	    {
	    //
	    // find the event handlers using the trigger Tags.
	    // Call the event handlers' callbacks with the attributes.
	    //
	    triggerPtr++;
	    triggerCount++;
	    }

	protocolBuffer.Unlock();
	}


    if (replyWait)
	{
	// Event cannot be a reply.
	*replyReadyRet = False;
	}
}



void XaServerConnection::FIND_REPLYprocessMsg(XaFindReply *reply,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;
    XaTag *tags;

    protocolBuffer.Lock();

    maxLen = length * 8 - (sizeof(XaFindReply) - sizeof(XaProtoHeader));

    if (maxLen)
	{
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);


	tags = (XaTag *)buffer;

	//
	//

	}


    if (replyWait)
	{
	XaReplyWaitInfo *replyInfo = (XaReplyWaitInfo *)replyWait->reply;

	if (replyInfo && (replyInfo->replyID == reply->replyID))
	    {
	    *(replyInfo->returnData) = (XaArgVal)tags;
	    replyWait->reply = reply;
	    *replyReadyRet = True;
	    protocolBuffer.Unlock();
	    return;
	    }
	else
	    {
	    *replyReadyRet = False;
	    }
	}

    // If there is an event handler registered expecting this reply,
    // find it and call it.
    // Else put it on the event queue.

    protocolBuffer.Unlock();
}


void XaServerConnection::GET_REPLYprocessMsg(XaGetReply *reply, 
				unsigned long length, Bool swap,
				IceReplyWaitInfo *replyWait, 
				Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;
    XaArgList attributes = NULL;

    maxLen = length * 8 - (sizeof(XaGetReply) - sizeof(XaProtoHeader));

    protocolBuffer.Lock();

    if (maxLen)
	{
	int	numAttr;

	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);
	attributes = (XaArgList)parseParamList((XaProtoItem *)buffer, maxLen,
						numAttr);
	}



    if (replyWait)
	{
	XaReplyWaitInfo *replyInfo = (XaReplyWaitInfo *)replyWait->reply;

	if (replyInfo && (replyInfo->replyID == reply->replyID))
	    {
	    *(replyInfo->returnData) = (XaArgVal)attributes;
	    replyWait->reply = reply;
	    *replyReadyRet = True;
	    protocolBuffer.Unlock();
	    return;
	    }
	else
	    {
	    *replyReadyRet = False;
	    }
	}

    // If there is an event handler registered expecting this reply,
    //   find it and call it.
    // Else put the reply on the event queue.

    protocolBuffer.Unlock();
}


void XaServerConnection::AUD_DATA_REPLYprocessMsg(XaAudioDataReply *reply,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer = NULL;
    int maxLen;

    maxLen = length * 8 - (sizeof(XaAudioDataReply) - sizeof(XaProtoHeader));

    protocolBuffer.Lock();

    if (maxLen)
	{
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	}



    if (replyWait)
	{
	XaReplyWaitInfo *replyInfo = (XaReplyWaitInfo *)replyWait->reply;

	if (replyInfo && (replyInfo->replyID == reply->replyID))
	    {
	    *(replyInfo->returnData) = (XaArgVal)buffer;
	    replyWait->reply = reply;
	    *replyReadyRet = True;
	    protocolBuffer.Unlock();
	    return;
	    }
	else
	    {
	    *replyReadyRet = False;
	    }
	}

    // If there is an event handler registered expecting this reply,
    //   find it and call it.
    // Else put the reply on the event queue.

    protocolBuffer.Unlock();
}

void XaServerConnection::PING_REPLYprocessMsg(XaPingReply *reply, 
				unsigned long length, Bool swap,
				IceReplyWaitInfo *replyWait, 
				Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;
    XaArgList attributes = NULL;

    // this reply has no variable length data.
    protocolBuffer.Lock();

    if (replyWait)
	{
	XaReplyWaitInfo *replyInfo = (XaReplyWaitInfo *)replyWait->reply;

	if (replyInfo && (replyInfo->replyID == reply->replyID))
	    {
	    replyWait->reply = reply;
	    *replyReadyRet = True;
	    protocolBuffer.Unlock();
	    return;
	    }
	else
	    {
	    *replyReadyRet = False;
	    }
	}

    // If there is an event handler registered expecting this reply,
    //   find it and call it.
    // Else put the reply on the event queue.

    protocolBuffer.Unlock();
}

void XaServerConnection::ERROR_REPLYprocessMsg(XaErrorReply *reply,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{

    if (sizeof(XaErrorReply) % 8)
	IceReadPad(connectionId, 8 - (sizeof(XaErrorReply) % 8));

    //
    // QUESTION:
    // Should an ErrorReply cause an error handler to be called?
    //


    if (replyWait)
	{
	XaReplyWaitInfo *replyInfo = (XaReplyWaitInfo *)replyWait->reply;

	if (replyInfo && (replyInfo->replyID == reply->replyID))
	    {
	    replyInfo->returnData = NULL;
	    replyWait->reply = reply;
	    *replyReadyRet = True;
	    return;
	    }
	else
	    {
	    *replyReadyRet = False;
	    }
	}

    // If there is an event handler registered expecting this reply,
    //   find it and call it.
    // Else put the reply on the event queue.

}


void XaServerConnection::ERROR_EVENTprocessMsg(XaErrorEvent *event,
					unsigned long length, 
					Bool swap, IceReplyWaitInfo *replyWait, 
					Bool *replyReadyRet)
{
    char *buffer;
    int maxLen;

    maxLen = length * 8 - (sizeof(XaErrorEvent) - sizeof(XaProtoHeader));


    if (maxLen)
	{
	TAG *triggers, *triggerPtr;

	protocolBuffer.Lock();
	buffer = protocolBuffer.Reserve(maxLen);

	if (IceValidIO(connectionId))
	    IceReadData(connectionId, maxLen, buffer);
	if (swap)
	    Swap32((CARD32 *)buffer, maxLen / 4);

	triggers = triggerPtr = (TAG*)buffer;

	// trigger list is null-terminated
	while (*triggerPtr)
	    {
	    //
	    // find the event handlers using the trigger Tags.
	    // Call the event handlers' callbacks with the object tag.
	    //
	    triggerPtr++;
	    }
	// Call the default error handler

	protocolBuffer.Unlock();
	}

    if (replyWait)
	{
	// Event cannot be a reply.
	*replyReadyRet = False;
	}
}
