/* $XConsortium: object.cc /main/10 1996/12/30 16:30:40 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
 * object.cc
 *
*/

//#include "xadefines.h"
#include "object.h"
#include "class.h"
#include "ctag.h"
#include "monitor.h"
#include <Xa/atomdefs.h>
#include <string.h>

#include <stdarg.h>
#include <stdio.h>



#ifdef DEBUG

#include "../../../../programs/Xaserver/dia/config.h"

static XaBoolean doit = FALSE;

static XaBoolean DoDebug ()
{
    static XaBoolean init = XaFalse;

    if (!init)
    {
	_XaConfigGetBool(".Object.debug", "", &doit);
	init++;
    }
    return doit;
}

extern "C"
{
void _XaObjectConfigReset()
{
    _XaConfigGetBool(".Object.debug", "", &doit);
}
}

/*
 * Default/Debug Callbacks.
 *
*/ 
extern "C" {
    XaBoolean d_checkCB(void * /* object */, XaAttributeCBData *attr)
    {
	if (DoDebug())
	    fprintf(stdout, "checking: \"%d\" - %d\n",
		    attr->name, attr->newValue);
	return XA_TRUE;
    }
}

extern "C" {
    void d_setCB(void * /* object */, XaAttributeCBData *attr)
    {
	if (DoDebug())
	    fprintf(stdout, "setting: \"%d\" - %d\n",
		    attr->name, attr->newValue);
    }
}
extern "C" {
    void d_getCB(void * /* object */, XaAttributeCBData *attr)
    {
	if (DoDebug())
	    fprintf(stdout, "getting: \"%d\" - %d\n",
		    attr->name, attr->value);
    }
}

extern "C" {
    XaBoolean d_validateCB(void * /* object */,
			   int count, XaAttributeCBData **attrs)
    {
	if (DoDebug())
	{
	    fprintf(stdout, "Validating %d attributes:\n", count);
	    for( int i = 0; i < count; i++)
	    {
		fprintf(stdout, "\t%d - \"%d\" - %d\n", i,
			attrs[i]->name, attrs[i]->value);
	    }
	}
	return XA_TRUE;
    }
}

#endif /* DEBUG */


extern "C" {
    XaErrorCode XaSetAttributes(void *object, XaAttributeCBData *data, 
					   CARD32 count) {
	XaObject *obj = (XaObject *)object;
	if (obj)
	  return obj->SetAttributes (obj->Conn(), data, count);
	else
	  return XaEFailure;
    }
}

extern "C" {
    XaErrorCode XaGetAttributes(void *object, XaAttributeCBData *data, 
					    CARD32 count) {
	XaObject *obj = (XaObject *)object;
        if (obj)
	  return obj->GetAttributes (obj->Conn(), data, count);
 	else
	  return XaEFailure;
   }
}

extern "C" {
    void SetAttributeSetCB (void 	      *object, 
			    XaAttributeCBData *data, 
			    XaAttributeSetCB   mySetCB) {
	XaObject *thisObj = (XaObject*)object;
        XaAttribute *attr = thisObj->find (data->name);
	if (attr)
          attr->Set (mySetCB);
    }
}

extern "C" {
    void SetAttributeGetCB (void 	      *object, 
			    XaAttributeCBData *data, 
			    XaAttributeGetCB   myGetCB) {
	XaObject *thisObj = (XaObject*)object;
        XaAttribute *attr = thisObj->find (data->name);
	if (attr)
          attr->Get (myGetCB);
    }
}

extern "C" {
    void SetAttributeCheckCB (void 	          *object, 
			      XaAttributeCBData   *data, 
			      XaAttributeCheckCB   myCheckCB) {
	XaObject *thisObj = (XaObject*)object;
        XaAttribute *attr = thisObj->find (data->name);
	if (attr)
          attr->Check (myCheckCB);
    }
}

extern "C" {
    void SetAttributeValidateCB (void 	                *object, 
			         XaAttributeValidateCB   myValidateCB) {
	XaObject *thisObj = (XaObject*)object;
	if (thisObj)
          thisObj->Validate (myValidateCB);
    }
}

XaObject::XaObject(XaConnection *c, XaClass *co, XaTag ot, XaTag cid, 
	XaTag name) : 
	conn(c), classObject(co), theTag(ot), classID(cid),
	theName(name),
#ifdef DEBUG
	validate(d_validateCB),
#endif
	implData(NULL) {}

XaObject::XaObject(XaTag ot) : theTag(ot),
#ifdef DEBUG
	validate(d_validateCB),
#endif
	implData(NULL) {}

XaObject::~XaObject() 
{ 
    XaObject *eco;

    // XXX should we send destroy events after the DestroyCB?
    // send destroy events for monitors on the object
    PullTriggers(XaAeventDestroy, 0, 0);
    // send destroy events for monitors on the class
    if (classObject && (eco = classObject->ExtClassObject()))
	eco->PullTriggers(XaAeventDestroy, 0, 0);

    classObject->DestroyCB(this); 
    attributes.clearAndDelete();
    Conn()->ObjectDB().remove(Tag());
    Conn()->ReleaseTag(Tag());
}

XaErrorCode
XaObject::SetAttribute(XaConnection *connIn, XaAttributeCBData *attr)
{
    return SetAttributes(connIn, attr, 1);
}

XaErrorCode XaObject::SetAttributes(XaConnection *connIn, 
				    XaAttributeCBData *attrs,
				    CARD32 count)
{

    XaErrorCode e = XaESuccess;
    int		i;

    // Get the attribute objects for each name,
    // and put the value into the new value
    // filed of the CBData struct.
    //
    // Also a CBData structs newValue is only
    // meaningful within the context of
    // this routine. Don't try and do anything
    // tricky with it later on. Even though
    // it's been set here, it should be treated
    // as meaningless, in particular because
    // a failure in any of the loops below
    // doesn't imply any clean up.
    //
    // TODO: jdr 11/26/95 This will get UGLY
    // if we don't replace the attribute names
    // with Tags. Right now a strcpy is done
    // right here on each findValue
    XaBag setThese;
    XaAttribute *attr;

    // Iterate through the attrs structs
    for (i = 0; i < count; i++) {
      attr = (XaAttribute*)attributes.find(attrs[i].name);
      if (!attr) 
	return XaEFailure;   // Couldn't find the requested attribute.
	
      if (attrs[i].name == XaAarray ||  // check type or attr->attribute.name ?
	  attrs[i].name == XaAcollectionReplace ||
	  attrs[i].name == XaAcollectionAdd ||
	  attrs[i].name == XaAcollectionSubtract) { 
	XaArray *oldArrayPtr = (XaArray *)attr->attribute.newValue;
	//
 	// Free old elements in XaArray and 
 	// then free the XaArray ptr itself.
	//
	if (oldArrayPtr->elements)  // free this also??
	  delete (oldArrayPtr->elements);
	if (attr->attribute.newValue)
	  delete (attr->attribute.newValue);

	// Supposed to only copy data if there is already
	// an existing collection (or value != NULL), but value
	// is a void * ptr and could have an actual value of 0 (zero).
	// so let's always copy the data for these two cases.
	//
	if (attrs[i].name == XaAcollectionAdd ||
	    attrs[i].name == XaAcollectionSubtract) {
          //
          // Make copies of array for XaAcollectionAdd/Subtract.
          //
	  XaArray *arrayItem = new XaArray;
          XaArray *arrayPtr = (XaArray *)attrs[i].value;
          CARD32  *array = new CARD32[arrayPtr->length];
        
          arrayItem->arrayAtom = attrs[i].name;
          arrayItem->length = arrayPtr->length;
          arrayItem->name = arrayPtr->name;
          arrayItem->elements = array;
          memcpy (array, arrayPtr->elements, sizeof (CARD32) * arrayPtr->length);
	  // Set new array ptr to newValue
 	  attr->attribute.newValue = arrayItem;
 	}
	else	
          // Set array pointer to newValue in attribute
          attr->attribute.newValue = attrs[i].value;
      }
      else {  // CARD32 values, set newValue in attribute
        attr->attribute.newValue = attrs[i].value;
      }
      // Insert updated attribute
      if( !setThese.insert(*attr)) 
	  return XaEFailure; // This is an out of memory failure.
    }

    // Foreach of the attributes do a type check ...
    int noOfAttr = setThese.entries();
    XaAttributeCBData **attrCBStructs = new XaAttributeCBData*[noOfAttr];
    int attrCounter = 0;
    XaBagIterator atts(setThese);
    while(attr = (XaAttribute*)atts()) {

	// There should be a function here, but check to be safe.
	e = attr->classAttr->TypeCheck(this, attr->attribute.value);
	if (e != XaESuccess) {
    	  delete attrCBStructs;
          return e;
	}
	XaAttributeCheckCB checkFunc = attr->Check();
	if( checkFunc) {
	    if( !checkFunc(this, &attr->attribute)) {
		// Type check failed, all done.
		e = XaEFailure;
    		delete attrCBStructs;
    		return e;
	    }
	}

	// While we're looping through we might as
	// well build up the array of CBData structs
	// we'll need for th validate.
	attrCBStructs[attrCounter++] = &attr->attribute;
    }

    // ... now, if there is one defined, call the validate function
    // with the array of CBData structs ....
    XaAttributeValidateCB validateFunc;
    if( validateFunc = Validate()) {
	if( !validateFunc(this, noOfAttr, attrCBStructs)) {
	    e = XaEFailure;
    	    delete attrCBStructs;
            return e;
	}
    }
    e = classObject->CheckCB(this, attrCBStructs, noOfAttr); // class validate
    if (e != XaESuccess) {
      delete attrCBStructs;
      return e;
    }

    // XXX do we send monitor events before or after the setCB?
    PullTriggers(XaAeventChange, attrCBStructs, noOfAttr);

    // ... O.K. checked and validated so:
    // - do the set CB
    // - then set the old value to the new value in the
    //   struct to keeping our cache consistant.
    classObject->SetCB(this, attrCBStructs, noOfAttr);	// class set first
    atts.reset();
    while(attr = (XaAttribute *)atts()) {
	XaAttributeCBData *cbdata = &attr->attribute;
	XaAttributeSetCB setFunc;
	if( setFunc = attr->Set()) {
	    setFunc(this, cbdata);
	}
	// update the old value with the new one.
	cbdata->value = cbdata->newValue;
    }
    return e;
    
}

/*
 * - Call the per attribute get function if it's there
 * - update the local chache if a change was made.
 * - return the cached value.
 * Note: For arrays, the value returned is a copied pointer
 *       so do not destroy the memory value in the returned cbdata.
*/
XaErrorCode XaObject::localGetAttr(XaAttributeCBData *data) {

    XaErrorCode e = XaESuccess;

    XaAttribute *attr;
    XaAttributeCBData *cbData;
    attr = (XaAttribute*)attributes.find(data->name);
    if (attr) {
	cbData = &attr->attribute;
	XaAttributeGetCB getFunc = attr->Get();
	if( getFunc) {
	    cbData->newValue = cbData->value;
	    getFunc(this, cbData);
	    // Update the cache.
	    if (cbData->newValue != cbData->value)
		cbData->value = cbData->newValue;
	}
	// return the value.
	data->value = cbData->value;
    } else {
	// Couldn't find the requested attribute.
	data->value = NULL;
	e = XaEFailure;
    }

    return e;
}

/* Get a single named attribute. */
XaErrorCode
XaObject::GetAttribute(XaConnection *connIn, XaAttributeCBData *attr)
{ 
    return (localGetAttr(attr)); 
}

/*
 * Run through each of the pairs and return the current
 * attribute value in the second element of the pair.
 * The return will be set to NULL the name is NOT a valid
 * attribute.
 * GetAttribute will return FAILURE if ANY of names
 * was incorrect. However all VALID names will have
 * the current value returned.
*/ 
XaErrorCode XaObject::GetAttributes(XaConnection *connIn, XaAttributeCBData *attrs,
				    CARD32 count)
{
    XaErrorCode e = XaESuccess;
    int  	i;

    // Spin through the name values and call the get function
    // if there is one, else just fill in the cached value.
    for (i = 0; i < count; i++) {
      if (localGetAttr (&attrs[i]) == XaEFailure)
	return XaEFailure;
    }

    return e;
}

/* Copy all of the names into the new bag. */
XaBag *XaObject::GetAttributeNames(void) const {

    XaBag *names = new XaBag;
    XaBagIterator attributesI(attributes);
    XaObject *attr;
    while(attr = (XaObject *)attributesI()) {
	XaCTag *newName = new XaCTag(attr->theTag);
	names->insert(*newName);
    }

    return names;
}

XaErrorCode XaObject::AddAttribute(XaTag name, XaClassAttribute *classAttr, 
	XaTag type, void *defaultValue) {

    XaAttribute *attr = new XaAttribute(name, classAttr, defaultValue, type);
    if( !attr || !attributes.insert(*attr)) {
	return XaEFailure;
    }

    return XaESuccess;
}

XaErrorCode XaObject::AddAttribute(XaTag name, XaAttribute *attr) {
    return (attributes.insert(*attr)) ? XaESuccess : XaEFailure;
}

XaErrorCode XaObject::RemoveAttribute(XaTag name) {
    attributes.removeAndDestroy(name);
    return XaESuccess;
}

/* Callback fetch or change */

XaAttributeSetCB 
XaObject::AttributeSetCB(XaTag name, XaAttributeSetCB newCB)
{
    XaAttribute *attr = AtomToAttribute(name);
    return (attr) ? attr->Set(newCB) : (XaAttributeSetCB)NULL;
}

XaAttributeGetCB 
XaObject::AttributeGetCB(XaTag name, XaAttributeGetCB newCB)
{
    XaAttribute *attr = AtomToAttribute(name);
    return (attr) ? attr->Get(newCB) : (XaAttributeGetCB)NULL;
}

XaAttributeCheckCB 
XaObject::AttributeCheckCB(XaTag name, XaAttributeCheckCB newCB)
{
    XaAttribute *attr = AtomToAttribute(name);
    return (attr) ? attr->Check(newCB) : (XaAttributeCheckCB)NULL;
}

/* Class operations */

XaBoolean XaObject::ClassMatch(XaTag type) { 
    return (classObject->Match(type)); 
}

/*
 * Collectability
 *
*/
unsigned XaObject::hash(void) const { return (unsigned)theTag; }

/* All instances are unique. */
XaBoolean XaObject::equals(const XaCollectable&p) const {
    return theTag == ((XaObject *)&p)->theTag;
}

XaAttribute *
XaObject::find(XaTag name)
{
    return (XaAttribute*)attributes.find(name);
//    XaAttribute *attr;
//    XaCTag nameTag(name);

//    attr = (XaAttribute*)attributes.find(name);
//    if (attr) 
//	return attr;
//    else 
//	return NULL;
}


XaBoolean
XaObject::PullTriggers(XaAtom typeOccurred, XaAttributeCBData **attrCBStructs,
		       CARD32 noOfAttr)
{
    XaBoolean sentEvent = XaFalse;
    XaScalarBagIterator monitorIterator(monitors);
    XaMonitor *monitor;

    // Pull the trigger on each monitor, which may send an event
    while (monitor = (XaMonitor *)monitorIterator())
    {
      sentEvent |= monitor->Trigger(this, typeOccurred, attrCBStructs,
				    noOfAttr);
    }

    return(sentEvent);
}


XaErrorCode
XaObject::AddMonitor(XaTag monTag)
{
    XaCTag *ctag = new XaCTag(monTag);
    if (!monitors.insert(*ctag)) 
      return XaEFailure; // This is an out of memory failure.
    else
      return XaESuccess;
}

XaErrorCode
XaObject::RemoveMonitor(XaTag monTag)
{
    monitors.removeAndDestroy(monTag);
    return XaESuccess;
}


/*
 * Attributes
 *
*/ 
XaAttribute::XaAttribute(XaTag n, XaClassAttribute *ca, void *v,
			 XaTag t, XaAttributeSetCB sCB,
			 XaAttributeGetCB gCB, XaAttributeCheckCB cCB) :
                         classAttr(ca), setCB(sCB), getCB(gCB), checkCB(cCB) {

    attribute.name = n;
    attribute.value = v;
    attribute.type = t;

#ifdef DEBUG
    /* These should not be set, this is for debugging */
    setCB = d_setCB;
    getCB = d_getCB;
    checkCB = d_checkCB;
#endif
    
}
			 
XaAttribute::~XaAttribute() {

    //TODO: jdr 11/26/95
    // Need to figure out how to delete the "value"
    // in a CBData struct.
    // Rquires "delete" functions indexed by type XaTags.
    
}
 
/* Collectability */

unsigned XaAttribute::hash(void) const {
    return (unsigned)attribute.name;
}

XaBoolean XaAttribute::equals(const XaCollectable &o) const {
    XaAttribute &a = (XaAttribute &)o;
    return (a.attribute.name == attribute.name) &&
	(a.attribute.value == a.attribute.value);
}

