/*This line lets emacs recognize this as -*- C++ -*- Code */
/* $XConsortium: aifffile.c /main/3 1996/12/30 16:29:53 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*------------------------------------------------------------------------
//
//  File:       XaFileIO.cc
//  Project:    XA
//
//  Description:
//
//------------------------------------------------------------------------
*/
/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 */
#include <math.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <Xa/atomdefs.h>
#include "filedefs.h"
#include "errors.h"
#include "cobject.h"
#include "filedefs.h"
#include "errors.h"

/* Read long, big-endian: little end first. 68000/386 style. */
unsigned long
rblong (int fd)
{
	unsigned char uc, uc2, uc3, uc4;
	read (fd, &uc, 1);
	read (fd, &uc2, 1);
	read (fd, &uc3, 1);
	read (fd, &uc4, 1);
	return ((long)uc << 24) | ((long)uc2 << 16) | ((long)uc3 << 8) | (long)uc4;
}

/* Read short, big-endian: little end first. 68000/386 style. */
unsigned short
rbshort(int fd)
{
	unsigned char uc, uc2;
	read (fd, &uc2, 1);
	read (fd, &uc, 1);
	return (uc2 << 8) | uc;
}

/* Write long, big-endian: big end first. 68000/SPARC style. */
unsigned long
wblong(int fd, unsigned long ul)
{
        unsigned char datum[4];

	datum[0] = (ul >> 24) & 0xff;
	datum[1] = (ul >> 16) & 0xff;
	datum[2] = (ul >> 8) & 0xff;
	datum[3] = (ul) & 0xff;
	if (write (fd, &datum, 4) != 4)
	  return 0;
	else
	  return 1;
}

/* Write short, big-endian: big end first. 68000/SPARC style. */
unsigned short
wbshort(int fd, unsigned short us)
{
        unsigned char datum[2];

	datum[0] = (us >> 8);
	datum[1] = us;
	if (write (fd, &datum, 2) != 2)
	  return 0;
	else
	  return 1;
}

/*
 * C O N V E R T   F R O M   I E E E   E X T E N D E D  
 */

/* 
 * Copyright (C) 1988-1991 Apple Computer, Inc.
 * All rights reserved.
 *
 * Machine-independent I/O routines for IEEE floating-point numbers.
 *
 * NaN's and infinities are converted to HUGE_VAL or HUGE, which
 * happens to be infinity on IEEE machines.  Unfortunately, it is
 * impossible to preserve NaN's in a machine-independent way.
 * Infinities are, however, preserved on IEEE machines.
 *
 * These routines have been tested on the following machines:
 *    Apple Macintosh, MPW 3.1 C compiler
 *    Apple Macintosh, THINK C compiler
 *    Silicon Graphics IRIS, MIPS compiler
 *    Cray X/MP and Y/MP
 *    Digital Equipment VAX
 *
 *
 * Implemented by Malcolm Slaney and Ken Turkowski.
 *
 * Malcolm Slaney contributions during 1988-1990 include big- and little-
 * endian file I/O, conversion to and from Motorola's extended 80-bit
 * floating-point format, and conversions to and from IEEE single-
 * precision floating-point format.
 *
 * In 1991, Ken Turkowski implemented the conversions to and from
 * IEEE double-precision format, added more precision to the extended
 * conversions, and accommodated conversions involving +/- infinity,
 * NaN's, and denormalized numbers.
 */

/****************************************************************
 * Extended precision IEEE floating-point conversion routine.
 ****************************************************************/
# define UnsignedToFloat(u)         (((double)((long)(u - 2147483647L - 1))) + 2147483648.0)
#define HUGE        ((float)3.40282346638528860e+38)


double ConvertFromIeeeExtended(unsigned char *bytes)
{
    double    f;
    int    expon;
    unsigned long hiMant, loMant;
    
    expon = ((bytes[0] & 0x7F) << 8) | (bytes[1] & 0xFF);
    hiMant    =    ((unsigned long)(bytes[2] & 0xFF) << 24)
            |    ((unsigned long)(bytes[3] & 0xFF) << 16)
            |    ((unsigned long)(bytes[4] & 0xFF) << 8)
            |    ((unsigned long)(bytes[5] & 0xFF));
    loMant    =    ((unsigned long)(bytes[6] & 0xFF) << 24)
            |    ((unsigned long)(bytes[7] & 0xFF) << 16)
            |    ((unsigned long)(bytes[8] & 0xFF) << 8)
            |    ((unsigned long)(bytes[9] & 0xFF));

    if (expon == 0 && hiMant == 0 && loMant == 0) {
        f = 0;
    }
    else {
        if (expon == 0x7FFF) {    /* Infinity or NaN */
            f = HUGE;
        }
        else {
            expon -= 16383;
            f  = ldexp(UnsignedToFloat(hiMant), expon-=31);
            f += ldexp(UnsignedToFloat(loMant), expon-=32);
        }
    }

    if (bytes[0] & 0x80)
        return -f;
    else
        return f;
}

/*
 * C O N V E R T   T O   I E E E   E X T E N D E D
 */

/* Copyright (C) 1988-1991 Apple Computer, Inc.
 * All rights reserved.
 *
 * Machine-independent I/O routines for IEEE floating-point numbers.
 *
 * NaN's and infinities are converted to HUGE_VAL or HUGE, which
 * happens to be infinity on IEEE machines.  Unfortunately, it is
 * impossible to preserve NaN's in a machine-independent way.
 * Infinities are, however, preserved on IEEE machines.
 *
 * These routines have been tested on the following machines:
 *    Apple Macintosh, MPW 3.1 C compiler
 *    Apple Macintosh, THINK C compiler
 *    Silicon Graphics IRIS, MIPS compiler
 *    Cray X/MP and Y/MP
 *    Digital Equipment VAX
 *
 *
 * Implemented by Malcolm Slaney and Ken Turkowski.
 *
 * Malcolm Slaney contributions during 1988-1990 include big- and little-
 * endian file I/O, conversion to and from Motorola's extended 80-bit
 * floating-point format, and conversions to and from IEEE single-
 * precision floating-point format.
 *
 * In 1991, Ken Turkowski implemented the conversions to and from
 * IEEE double-precision format, added more precision to the extended
 * conversions, and accommodated conversions involving +/- infinity,
 * NaN's, and denormalized numbers.
 */

# define FloatToUnsigned(f)      ((unsigned long)(((long)(f - 2147483648.0)) + 2147483647L) + 1)

void
ConvertToIeeeExtended(double num, char *bytes)
{
    int    sign;
    int expon;
    double fMant, fsMant;
    unsigned long hiMant, loMant;

    if (num < 0) {
        sign = 0x8000;
        num *= -1;
    } else {
        sign = 0;
    }

    if (num == 0) {
        expon = 0; hiMant = 0; loMant = 0;
    }
    else {
        fMant = frexp(num, &expon);
        if ((expon > 16384) || !(fMant < 1)) {    /* Infinity or NaN */
            expon = sign|0x7FFF; hiMant = 0; loMant = 0; /* infinity */
        }
        else {    /* Finite */
            expon += 16382;
            if (expon < 0) {    /* denormalized */
                fMant = ldexp(fMant, expon);
                expon = 0;
            }
            expon |= sign;
            fMant = ldexp(fMant, 32);          
            fsMant = floor(fMant); 
            hiMant = FloatToUnsigned(fsMant);
            fMant = ldexp(fMant - fsMant, 32); 
            fsMant = floor(fMant); 
            loMant = FloatToUnsigned(fsMant);
        }
    }
    
    bytes[0] = expon >> 8;
    bytes[1] = expon;
    bytes[2] = hiMant >> 24;
    bytes[3] = hiMant >> 16;
    bytes[4] = hiMant >> 8;
    bytes[5] = hiMant;
    bytes[6] = loMant >> 24;
    bytes[7] = loMant >> 16;
    bytes[8] = loMant >> 8;
    bytes[9] = loMant;
}


double read_ieee_extended(int fd)
{
	char buf[10];
	if (read(fd, buf, 10) != 10)
	  return 0.0;
	return ConvertFromIeeeExtended((unsigned char *)buf);
}

void
write_ieee_extended(int fd, double x)
{
	char buf[10];
	ConvertToIeeeExtended(x, buf);
	(void) write(fd, buf, 10);
}


static int
decode_aiff_header (int fd, Audio_hdr *hdr)
{
    unsigned char   buf[sizeof (BUFSIZ)];
    unsigned long   totalsize;
    unsigned long   chunksize;
    unsigned long   blocksize = 0;
    unsigned long   offset;
    unsigned long   frames;
    int             bits;
    unsigned        nread = 0;
    int             channels;
    double          rate;
    int             nbytes;
    char            c;

    /*
    // Make some assumptions.
    */
    hdr->endian = XaAendianBig;
    hdr->samples_per_unit = 1;
    hdr->encoding = XaAencodeLinear;
    /*    
    // FORM chunk
    // Magic number
    */
    nbytes = read (fd, (char *)buf, 4);  nread += 4;
    if (nbytes != 4 || strncmp ("FORM", (char *)buf, 4))
      return 0;
    
    /*
    // total size
    */
    totalsize = rblong (fd); nread += 4;
    
    /*    
    // Read another magic number.
    */
    nbytes = read (fd, (char *)buf, 4);  nread += 4;
    if (nbytes != 4 || strncmp ("AIFF", (char *)buf, 4))
      return 0;
    
    /*
    // Skip everything but the COMM chunk and the SSND chunk.
    // The SSND chunk must be the last in the file.
    */
    while (1) {
      nbytes = read (fd, buf, 4);  nread += 4;
      if (nbytes != 4)
	return 0;
      
      if (strncmp ((char *)buf, "COMM", 4) == 0) {
	/* COMM chunk */
	chunksize = rblong (fd); nread += 4;
	if (chunksize != 18)
	  return 0;
	hdr->channels = rbshort (fd); nread += 2;
	frames = rblong (fd); nread += 4;
	bits = rbshort (fd); nread += 2;
	hdr->sample_rate = (unsigned)read_ieee_extended (fd); nread += 10; /*? */
      }  
      else if (strncmp ((char *)buf, "SSND", 4) == 0) {
	/* SSND chunk */
	chunksize = rblong (fd); nread += 4;
	offset = rblong (fd);    nread += 4;
	blocksize = rblong (fd); nread += 4;
	break;
      }
      else {
	chunksize = rblong (fd); nread += 4;
	while ((long) (--chunksize) >= 0) {
	  nbytes = read (fd, &c, 1);  nread += 1;
	    if (nbytes != 1)
	      return 0;
	}
      }
    }

    /*
    // SSND chunk just read
    */
    if (blocksize != 0)
      return 0;

    while ((long) (--offset) >= 0) {
      nbytes = read (fd, &c, 1); nread += 1;
      if (nbytes != 1)
	return 0;    
    }
	 
    switch (bits) {
    case 8:
      hdr->bytes_per_unit = 1;
      break;
    case 16:
      hdr->bytes_per_unit = 2;
      break;
    default:
      return 0;  /* unsupported sample size in Aiff header. */
      break;
    }

    hdr->hdr_size = nread;
    hdr->data_size = totalsize + 8 - nread;

    return 1;
}      

static int
encode_aiff_header (int fd, Audio_hdr *hdr)
{
    int   hsize = 
		8 /*COMM hdr*/ + 18 /*COMM chunk*/ +
		8 /*SSND hdr*/ + 12 /*SSND chunk*/;
    int   bits = hdr->bytes_per_unit * 8;
    long  nframes;  

    write (fd, "FORM", 4);  /* IFF header */

    nframes = 0x7f000000 / (hdr->bytes_per_unit * hdr->channels);
    wblong (fd, hdr->data_size + 82 + 8); /* file size */
    write (fd, "AIFF", 4);  /* file type *

    /*
    // COMM chunk -- describes encoding (and #frames)
    */
    write (fd, "COMM", 4);
    wblong (fd, (long)18);                 /* COMM chunk size */
    wbshort (fd, hdr->channels);           /* channels */
    wbshort (fd, nframes);                 /* number of frames */
    wblong (fd, bits);                     /* sample width, in bits */
    write_ieee_extended (fd, (double)hdr->sample_rate);
    /*
    // SSND chunk -- describes data
    */
    write (fd, "SSND", 4);
    wblong(fd, 8 + nframes * hdr->channels * hdr->bytes_per_unit); /* data size */
    wblong(fd, (long) 0); /* offset */
    wblong(fd, (long) 0); /* block size */

    return 1;

}
 
static XaErrorCode 
aiffInit(int fd, void *file, XaTag fileMode)
{
    Audio_hdr          hdr;  
    int                status;
    XaAttributeCBData  cbd;
    XaErrorCode        error;

/*
// If file was opened for reading, read in header and
// set properties.
// If file was opened for writing, write out header
// based on current properties set.
*/
    switch (fileMode) {
    case XaAopenForRead:
      /*
      // Decode aiff properties into header
      */
      if (!decode_aiff_header (fd, &hdr))
	return XA_FAILURE;
      
      /*
      // Store the aiff properties
      */
      cbd.name = XaAendian;
      cbd.value = (void *)hdr.endian;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAsampleRate;
      cbd.value = (void *)hdr.sample_rate;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAsamplesPerUnit;
      cbd.value = (void *)hdr.samples_per_unit;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAbitsPerSample;
      cbd.value =  (void *)(hdr.bytes_per_unit * 8);
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAnumChannels;
      cbd.value = (void *)hdr.channels;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAencoding;
      cbd.value = (void *)hdr.encoding;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAdataSize;
      cbd.value = (void *)hdr.data_size;
      error = XaSetAttributes (file, &cbd, 1);

      cbd.name = XaAheaderSize;
      cbd.value = (void *)hdr.hdr_size;
      error = XaSetAttributes (file, &cbd, 1);
      break;

    case XaAopenForWrite:
      /*
      // Get the properties for aiff header.
      */
      cbd.name = XaAsampleRate;
      error = XaGetAttributes (file, &cbd, 1);
      if (error != XaESuccess)
        return XA_FAILURE;
      else
        hdr.sample_rate = (unsigned)cbd.value;

      cbd.name = XaAencoding;
      error = XaGetAttributes (file, &cbd, 1);
      if (error != XaESuccess)
        return XA_FAILURE;
      else
        hdr.encoding = (unsigned)cbd.value;

      cbd.name = XaAnumChannels;
      error = XaGetAttributes (file, &cbd, 1);
      if (error != XaESuccess)
        return XA_FAILURE;
      else
        hdr.channels = (unsigned)cbd.value;

      cbd.name = XaAdataSize;
      error = XaGetAttributes (file, &cbd, 1);
      if (error != XaESuccess)
        return XA_FAILURE;
      else
        hdr.data_size = (unsigned)cbd.value;

      cbd.name = XaAbitsPerSample;
      error = XaGetAttributes (file, &cbd, 1);
      if (error != XaESuccess)
        return XA_FAILURE;
      else
        hdr.bytes_per_unit = (unsigned)cbd.value/8;

      /*
      // Write out aiff header
      */
      if (!encode_aiff_header (fd, &hdr))
	return XA_FAILURE;

      break;

    default:
      break;
    }

    return XA_SUCCESS;
}

fileInit (int fd, void *file)
{
    XaAttributeCBData  cbd;
    XaErrorCode        error;
    XaTag              fileMode;

    cbd.name = XaAfileMode;
    error = XaGetAttributes (file, &cbd, 1);
    if (error != XaESuccess)
      return XA_FAILURE;
    else
      fileMode = (unsigned)cbd.value;

    return aiffInit(fd, file, fileMode);
}

