/* $XConsortium: fileio.h /main/4 1996/12/30 16:29:51 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include "atomstrings.h"
#include "dictionary.h"
#include "filedefs.h"
#include "buffer.h"

typedef XaErrorCode (*XaFileInitFunc)(int fd, void *file);

class XaFile : public XaBuffer {

public:

    /* Constructor/Destructors
    */
    XaFile(const char *path, 
	   const char *format = NULL, 
 	   XaTag fileMode = XaAopenForRead);
    XaFile(XaConnection *, XaClass *, XaTag, XaTag, XaTag);

    ~XaFile();

    /*
     * Create/Destroy Callbacks for the XA Oject  model.
    */
    static XaErrorCode FileCreateCB(XaObject* ,
                                    XaAttributeCBData * data, CARD32 count);
    static XaErrorCode FileDestroyCB(XaObject*);
    
    /* Opens the file, loads in the dynamic symbol for this format
     * and decodes the header.
     * If file is opened for writing, the header will be written out.
     * The fp will always point to beginning of the data.
     */
    XaErrorCode Open(const char *path, 
	             const char *format = NULL, 
                     XaTag fileMode = XaAopenForRead);

    /* Closes the file
     */
    virtual XaErrorCode Close(void);
    
    /* Called after file opened for reading.
    *  Returns the number of bytes read.
    */
    XaErrorCode Read(XaTime atTime, XaTag refClock, 
		     XaInternalBuffer *&buffer, CARD32 bitsToRead, 
		     CARD8 &leftPad, CARD32 &bitsRead, XaTime &deviceTime);

    /* Called after file opened for writing.
    *  Returns the number of bytes written.
    */
    XaErrorCode Write(XaTime atTime, XaTag refClock,
		      XaInternalBuffer &buffer,
		      CARD32 bitsToWrite, CARD8 leftPad,
		      CARD32 &bitsWritten, XaTime &deviceTime);


    /* Resets internal pointers so that reads/writes start to
     * work from of the beginning of the data again.
    */
    XaErrorCode reset();

    /*
     * Set the file pointer to the specified sample.
     */
    XaErrorCode set(CARD32 sampleNumber);
    
    /* Returns a bag of supported formats
     */
    static XaBag &formats();

    /*
     * Returns whether or not this format is supported.
     */
    static XaBoolean formatSupported(const char *format);

protected:

    int fd;				// file descriptor

private:

    XaFileInitFunc findInitFunction (const char *format);  // load in init() function

    static XaDictionary *funcs;		// list of init() funcs.

    XaErrorCode init(const char *format);

};


