//This line lets emacs recognize this as -*- C++ -*- Code
/* $XConsortium: fileio.cc /main/6 1996/12/30 16:29:47 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//------------------------------------------------------------------------
//
//  File:       XaFileIO.cc
//  Project:    XA
//
//  Description:
//
//------------------------------------------------------------------------
//
/*
 * Copyright (c) 1995, by Sun Microsystems, Inc.
 */
  
// "@(#)XaFileIO.cc 1.13 95/12/05 Sun Microsystems, Inc."

#include "xadefines.h"
#include "fileio.h"
#include "class.h"
#include "au.h"
#include "dictionary.h"
#include "xasymlib.h"
#include "pointer.h"
#include "xastring.h"
#include "filedefs.h"
#include "intbuffer.h"
#include <stdio.h>
#include <string.h>
#ifndef USL
#include <malloc.h>
#endif
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef sco
#define MAXPATHLEN 1024
#endif

XaDictionary *XaFile::funcs = NULL;		// list of init funcs.

static XaDictionary *supported;     		// list of supported formats.

#define DEFAULT_SAMPLE_RATE  8000

#define AUDIO_SUN_FORMAT   "Sun"
#define AUDIO_WAV_FORMAT   "Wav"
#define AUDIO_AIFF_FORMAT  "Aiff"

XaAttrInitRec XaFileAttrInit[] =
{
    {
        XaNpathName,            XaNtag,
                                XaValid,
                                (void *)NULL,
                                XaMODE_CSG
    },
    {
    
        XaNfileMode,            XaNtag,
                                XaValid,
                                (void *)XaAopenForRead,
                                XaMODE_CSG
    },
    {
        XaNendian,              XaNtag,
                                XaValid,
                                (void *)XaAendianBig,
                                XaMODE_CSG
    },
    {
    
        XaNsampleRate,          XaNcard32,
                                XaValid,
                                (void *)DEFAULT_SAMPLE_RATE,
                                XaMODE_CSG
    },
    {
        XaNsamplesPerUnit,      XaNcard32,
                                XaValid,
                                (void *)1,
                                XaMODE_CSG
    },
    {
    
        XaNbitsPerSample,       XaNcard32,
                                XaValid,
                                (void *)8,
                                XaMODE_CSG
    },
    { 
        XaNnumChannels,         XaNcard32,
                                XaValid,
                                (void *)1,
                                XaMODE_CSG
    },
    {
    
        XaNencoding,            XaNatom,
                                XaValid,
                                (void *)XaAencodeUlaw,
                                XaMODE_CSG
    },
    { 
        XaNdataSize,            XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
    
        XaNheaderSize,          XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
    
        XaNcurrentSample,       XaNcard32,
                                XaValid,
                                (void *)0,
                                XaMODE_CSG,
    }
};


XaFile::XaFile(const char *path, const char *format, XaTag fileMode) : 
	XaBuffer (0, 0, 0, 0, 0), fd(-1)
{
   if (XaFile::Open (path, format, XaAopenForRead) != XaESuccess) {
     XaFile::Close();
   }

}

XaFile::XaFile(XaConnection *c, XaClass *cl, XaTag t1, XaTag t2, XaTag t3) : 
	XaBuffer (c, cl, t1, t2, t3), fd(-1)
{

}

XaFile::~XaFile()
{
    if (fd > 0) {
      close (fd);
      fd = -1;
   }
}

XaFileInitFunc
XaFile::findInitFunction (const char *format)
{
    XaFileInitFunc  func;
    XaErrorCode     error;
    XaString       *key;
    XaPointer      *ptr;
    void	   *val;

//
// First check to see if we even support
// this format.
//
    if (XaFile::formatSupported (format) == XaFalse) 
      return NULL;
//
// Create the dictionary of function pointers, if not
// done so.
//
    if (funcs == NULL) 
      funcs = new XaDictionary;
//
// Find init() function in the funcs list.
//
    key = new XaString (format);
    val = funcs->findValue (*key);
    delete (key);

//
// Load in init() function, if not already loaded.
//
    if (val == NULL) {    // not loaded yet.
      char  libName[MAXPATHLEN];

      // Get the *.so file name to load in.
      //
      key = new XaString (format);
      val = supported->findValue (*key);
      delete (key);
  
      if (val == NULL) 
	return NULL;

      //ptr = (XaPointer *)val;
      //void *v = (void *)*ptr;
      sprintf (libName, "%s", (char *)val);
   
      error = XaDynamicSymbolLibrary::getSymbol (libName, "fileInit", 
	    (void *&)func);
      if (error != XaESuccess || func == NULL)
        return NULL;

      //
      // Store the function pointer in 'funcs' for next time
      //
      XaString *key = new XaString (format);
      ptr = (XaPointer *)funcs->insertKeyAndValue (*key, (void *)func);
    }
    else {
      func = (XaFileInitFunc) val;
    }

    return func;
    
}

XaErrorCode 
XaFile::init(const char *format)
{
    XaFileInitFunc func;
//
// Get init() function
//
    func = findInitFunction (format);
//
// Call the init() function for this format.
//
    if (func)
      return (func (fd, (void *)this));
    else
      return XaEFailure;
}

//
// Type file by content.
// Buffer is passed in.
//
static char *
findFormatByContent(char *buf, int bufsize)
{
    unsigned long  au_magic;
    char          *format;

//
// Check if .au file.
//
    if (bufsize >= 4) {
	DECODE_LONG (buf, &au_magic);
	if (au_magic == AU_SUN_MAGIC ||
	    au_magic == AU_SUN_INV_MAGIC ||
	    au_magic == AU_DEC_MAGIC ||
	    au_magic == AU_DEC_INV_MAGIC) {
	    return (strdup (AUDIO_SUN_FORMAT));
	}
    }
//
// Check if .wav file
//
    if (bufsize >= 12) {
	char *bufPtr = buf;
	if (strncmp ("RIFF", bufPtr, 4) == 0) {
	    bufPtr += 4; // data_size
	    bufPtr += 4; // another magic number here.
	    if (strncmp ("WAVE", bufPtr, 4) == 0)
		return (strdup (AUDIO_WAV_FORMAT));
	}
    }
//
// Check if .aiff file
//
    if (bufsize >= 12) {
	char *bufPtr = buf;
	if (strncmp("FORM", buf, 4) == 0) {
	    bufPtr += 4;  // total size
	    bufPtr += 4;  // another magic number
	    if (strncmp ("AIFF", bufPtr, 4) == 0)
		return (strdup (AUDIO_AIFF_FORMAT));
	}
    }
		
    return NULL;
}

//
// Returns file format string.
// Using char * for format name instead of #defines for extensibility.
// Adding a format string to a config file rather than
// adding a #define to a *h file and recompiling.
// Note: The caller should free the returned string when done.
//
static char *
findFormat (const char *path)
{
    int   len = 0;
    char *format;
    char buf[64];
    int  bufsize;

    if (path)
      len = strlen (path);

    // .wav extension    
    if (len >= 4 && path[len-4] == '.' && path[len-3] == 'w' &&
	path[len-2] == 'a' && path[len-1] == 'v') {
      format = strdup (AUDIO_WAV_FORMAT);
    }

    // .aiff extension
    else if (len >= 5  && path[len-5] == '.' && path[len-4] == 'a' &&
	     path[len-3] == 'i' && path[len-2] == 'f' &&
	     path[len-1] == 'f') {
      format = strdup (AUDIO_AIFF_FORMAT);
    }

    // .au extension
    else if (len >= 3 && path[len-3] == '.' && path[len-2] == 'a' &&
	     path[len-1] == 'u') {
      format = strdup (AUDIO_SUN_FORMAT);
    }

    // .aud extension
    else if (len >= 3 && path[len-4] == '.' && path[len-3] == 'a' &&
	     path[len-2] == 'u' && path[len-1] == 'd' ) {
      format = strdup (AUDIO_SUN_FORMAT);
    }
#ifdef LATER
// Do this later because file->Open needs
// to use the amended path.
//
    // .Z extension
    // uncompress the .Z file and type by content.
    else if (len >= 2 && path[len-2] == '.' && path[len-1] == 'Z') {
	char pbuf[MAXPATHLEN];
	char tmpbuf[PIPE_BUF];
	int  path_len = strlen(path);
        sprintf (pbuf, "/usr/bin/zcat %s", path);  // Note: is this portable??
        FILE *pfd = popen (pbuf, "r");
	if (pfd == NULL)
	    return NULL;
	bufsize = fread (buf, 1, sizeof (buf), pfd);
	/*
	 * Drain the pipe before closing.
	 */
	while (fgets (tmpbuf, sizeof (tmpbuf), pfd));
	pclose (pfd);

	format = findFormatByContent (buf, bufsize);
    }
#endif
    // else try typing file by content
    // read in first 64 bytes or so and type it.
    else {
	FILE *f;
	if ((f = fopen(path, "r")) != 0) {
	    bufsize = fread (buf, 1, sizeof(buf), f);
	    fclose(f);
	}
	else return NULL;
	format = findFormatByContent (buf, bufsize);
    }

    return format;

}

XaErrorCode 
XaFile::Open(const char *path, const char *format, XaTag fileMode)
{
    char   *actualFormat;

//
// If format not passwed in, try to determine the format type.
// so that we know what .so file to load in.
//
    if (format == NULL) {
	
      if ((actualFormat = findFormat (path)) == NULL)
	return XaEFailure;
    }
    else
      actualFormat = strdup (format);

    if (fileMode == XaAopenForRead) {
    
      // Open the file (O_NONBLOCK in case pathname is a device)
      fd = open (path, O_RDONLY | O_NONBLOCK);
      if (fd < 0)
        return XaEFailure;
    
    // Read in the properties
    if (init(actualFormat) == XaEFailure)
      return XaEFailure;
    }
    else if (fileMode == XaAopenForWrite) {
    
      // Open the file for writing.
      fd = open (path, O_CREAT | O_WRONLY | O_TRUNC | O_NONBLOCK, 0644);
      if (fd < 0)
        return XaEFailure;
    
      // Write out the header based on current set properties
      if (init(actualFormat) == XaEFailure)
        return XaEFailure;
    }

    free (actualFormat);

    return XaESuccess;
}

XaErrorCode XaFile::Close()
{
    int status = 0;

    if (fd > 0) {
      status = close (fd);
      fd = -1;
    }

    if (status > 0)
      return XaESuccess;
    else
      return XaEFailure;
}

XaErrorCode
XaFile::Read(XaTime atTime, XaTag refClock, XaInternalBuffer *&buffer,
             CARD32 bitsToRead, CARD8 &leftPad, CARD32 &bitsRead,
	     XaTime &deviceTime)
{
//
// Warning: This needs to be fixed to use time values.
//
   void *buff = buffer->GetBuffer();
   int   nread;

   nread = read (fd, buff, bitsToRead/8);
   if (nread != -1) {
     bitsRead = nread * 8;
     return XaESuccess;
   }
   else 
     return XaEFailure;
}

XaErrorCode
XaFile::Write(XaTime atTime, XaTag refClock, XaInternalBuffer &buffer,
              CARD32 bitsToWrite, CARD8 leftPad, CARD32 &bitsWritten,
	      XaTime &deviceTime)
{
    
//
// Warning: This needs to be fixed to use time values.
//
   void *buff = buffer.GetBuffer();
   int   nwritten;

   nwritten = write (fd, buff, bitsToWrite/8);
   if (nwritten != -1) {
     bitsWritten = nwritten * 8;
     return XaESuccess;
   }
   else 
     return XaEFailure;
}

XaErrorCode XaFile::reset()
{
    off_t       	offset;
    XaErrorCode 	err;
    XaAttributeCBData   attr;
//
// Get the header size attribute.
//
    attr.name = XaAheaderSize;
    err = this->GetAttribute(this->Conn(), &attr);  
//
// Seek to end of the header or beginning of data.
//
    err = this->GetAttribute (this->Conn(), &attr);
    if (err == XaESuccess) { 
      offset = (off_t)attr.value;
      if (offset > 0)
        lseek (fd, offset, SEEK_SET);
    }
    else  // HEADER_SIZE not set.
      lseek (fd, 0, SEEK_SET);

    return XaESuccess;
    
}

XaErrorCode XaFile::set(CARD32 sampleNumber)
{
    off_t       	offset;
    XaErrorCode 	err;
    XaAttributeCBData   attr;
    CARD32		headerSize = 0;
    CARD32		samplesPerUnit = 1;
    CARD32		bitsPerSample = 8;
//
// Get the header size.
//
    attr.name = XaAheaderSize;
    err = this->GetAttribute(this->Conn(), &attr);  
    if (err == XaESuccess)
      headerSize = (CARD32) attr.value;
//
// Get the bitsPerSample
//
    attr.name = XaAbitsPerSample;
    err = this->GetAttribute(this->Conn(), &attr);  
    if (err == XaESuccess)
      bitsPerSample = (CARD32) attr.value;
    
    offset = (off_t) (headerSize + ((bitsPerSample/8) * sampleNumber));

    lseek (fd, offset, SEEK_SET);

    return XaESuccess;

}

static void
readSupportedFormats()
{
    char       buf[MAXPATHLEN];
    char       format[512];
    char       symbol[512];
    char      *xa_home;
    FILE      *fp = NULL;
    XaString  *key, *val;
    XaPointer *ptr;

    if (supported == NULL) 
      supported = new XaDictionary;
    else
      return;

    xa_home = getenv ("XAHOME");
    if (xa_home) { 
      sprintf (buf, "%s/XaFormats", xa_home);
      fp = fopen (buf, "r");
    }

    if (fp != NULL) {
      fgets (buf, MAXPATHLEN-1, fp);
      while (!feof (fp)) {
	// ignore comments
        if (buf[0] == '#') {
          fgets (buf, MAXPATHLEN-1, fp);
	  continue;
   	}
 	sscanf (buf, "%s %s", format, symbol);

	key = new XaString (format);
        ptr = (XaPointer *)supported->insertKeyAndValue (*key, strdup (symbol));
        fgets (buf, MAXPATHLEN-1, fp);
      }
    }

//
// Hard code these for now
//
    else {
      char *value;

#ifdef hpux
#    define LIB_WAV	"libwavfile.sl"
#    define LIB_SUN	"libsunfile.sl"
#    define LIB_AIFF	"libaifffile.sl"
#else
#    define LIB_WAV	"libwavfile.so"
#    define LIB_SUN	"libsunfile.so"
#    define LIB_AIFF	"libaifffile.so"
#endif	/* hpux */

      key = new XaString (AUDIO_WAV_FORMAT);
      value = strdup (LIB_WAV);
      ptr = (XaPointer *)supported->insertKeyAndValue (*key, value);

      key = new XaString (AUDIO_SUN_FORMAT);
      value = strdup (LIB_SUN);
      ptr = (XaPointer *)supported->insertKeyAndValue (*key, value);

      key = new XaString (AUDIO_AIFF_FORMAT);
      value = strdup (LIB_AIFF);
      ptr = (XaPointer *)supported->insertKeyAndValue (*key, value);

    }

}

XaBoolean
XaFile::formatSupported (const char *format)
{
    XaBoolean  ret_value = XaFalse;
    XaString  *key;
    void      *val;
//
// Read in the list of supported formats.
//
    readSupportedFormats();

//
//
//
    key = new XaString (format);
    val = supported->findValue (*key);
    delete (key);

    if (val != NULL) 
      return XaTrue;
    else 
      return XaFalse;
}

XaBag &XaFile::formats()
{
//
// Read the support formats into a dictionary.
// where the key is the audio format and the
// value is the "*.so" file.
//
    readSupportedFormats ();

//
// Iterate through the dictionary
// and put the file formats into a bag.
//
    XaBag  *b = new XaBag;
 
    XaDictionary d = *supported;
    XaDictionaryIterator it(d);
    XaString *key;
    while(key = (XaString *)it()) {
        b->insert(*key);
    }
 
    return  *b;
}

XaErrorCode XaFile::FileDestroyCB(XaObject *obj)
{
    //XXX Some cleanup goes here:
    //XXX   Nuke created objects
    //XXX   Remove from server's list of connections
    return XaESuccess;
}

static void
pathNameSetCB (void *obj, XaAttributeCBData *cbd) 
{
   XaFile *file = (XaFile *)obj;
   XaAttributeCBData attr;
   char *path = (char *)cbd->newValue;
   char *format;
   XaErrorCode  err;

//
// Try to determine the format type so that we know
// which .so file to load in.
//
   if ((format = findFormat (path)) == NULL)
     return;
//
// Get the fileMode flag
//
   attr.name = XaAfileMode;
   err = file->GetAttribute(file->Conn(), &attr);  
   if (err != XaESuccess)
     return;
//
// 
//
   if (file->Open (path, format, (XaTag)attr.value) != XaESuccess) {
     file->Close();
   }

   free (format);
}


static void
currentSampleSetCB (void *obj, XaAttributeCBData *cbd) 
{
   XaFile *file = (XaFile *)obj;
   char *format;
   XaErrorCode  err;
   XaAttributeCBData attr;

//
// If value == 0, then reset the
// file to the beginning of the data.
//
   if (cbd->newValue == 0) {
     file->reset();
   }

//
// set file pointer to header + current sample.
//
   else {
     file->set((CARD32)cbd->newValue);
   }

}

XaErrorCode
XaFile::FileCreateCB (XaObject *obj, XaAttributeCBData * data, CARD32 count)
{

    XaFile   	     *file = (XaFile *)obj;
    XaConnection      *conn = file->Conn();
    XaAttributeCBData  cbd;
    XaErrorCode	      err;

/* 
 * Set a pathName set callback
 */
    XaAttribute *attr = (XaAttribute *)file->attributes.find (XaApathName);
    if (attr) {
      attr->Set(pathNameSetCB);
      err = XaESuccess;
    }
    else
      return XaEFailure;

/* 
 * Set a currentSample set callback
 */
    attr = (XaAttribute *)file->attributes.find (XaAcurrentSample);
    if (attr) {
      attr->Set(currentSampleSetCB);
      err = XaESuccess;
    }
    else
      return XaEFailure;

    return err;
}

void *FileClassCreate(void *conn, void *c, XaTag t1, XaTag t2, XaTag t3) {
	return (void*) new XaFile((XaConnection*)conn, (XaClass*)c,
	                    t1, t2, t3);
}

XaClassInitRec XaFileClassInit =
{
    XaNfile, XaNobject,
    // pointer to constructor that takes Xaobject constructor args.    
    FileClassCreate, 
    XaNumber(XaFileAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XaFile::FileCreateCB, XA_NULL, XA_NULL, XA_NULL, XaFile::FileDestroyCB 
};

XaErrorCode XaCreateClassFile(XaConnection *conn)
{
    return (new XaClass(conn, XaAfile,
	    &XaFileClassInit, XaFileAttrInit)) ? XaESuccess : XaEFailure;
}

