//This line lets emacs recognize this as -*- C++ -*- Code
/* $XConsortium: dictionary.h /main/2 1996/12/30 16:29:38 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/


//	"@(#)XaDictionary.h	1.27\t94/06/21  "

#ifndef XA_DICTIONARY_H
#define XA_DICTIONARY_H

#include "xadefines.h"
#include "collectable.h"
#include "bag.h"

//
//  ------------------------------------------
//  Supporting type definitions
//  ------------------------------------------
//

class XaDictionary : public XaBag
{
  public:

    // 
    // --------- Constructors / destructor
    // 

    // Generic constructor. (numBuckets) indicates how many
    // hashing buckets to start with.
    XaDictionary(unsigned numBuckets = XA_DEFAULT_COLLECTION_SIZE);

    // Copy constructor copies, then get()s new references
    // for every element in the dictionary.
    XaDictionary(const XaDictionary& another);

    virtual ~XaDictionary(void);

    //
    // --------- Object insertion and removal
    //

    // Returns the key which equals to (targetKey), or NULL if no key
    // matching (*target) exists in the dictionary.
    virtual XaCollectable *       find(const XaCollectable& targetKey) const;
    
    // Returns the key which equals to (*targetKey), or NULL if no key
    // matching (*target) exists in the dictionary. The matching value
    // is put into (*valueResult).
    virtual XaCollectable *       findKeyAndValue(const XaCollectable& targetKey,
						  void *&valueResult);

    // Return the value associated with the key which equals to (targetKey).
    // Returns NULL if no entry by that key exists in the dictionary.
    virtual void *                findValue(const XaCollectable& targetKey) const;

    // Same as findValue() above, but replaces the dictionary value
    // with that in (*newValue). The returned value is not released,
    // the reference which had belonged to the dictionary now belongs
    // to the calling routine.
    virtual void *                findValue(const XaCollectable& targetKey,
				            void *newValue);

    // Insert (newKey) and (newValue) in the dictionary. Returns (newKey)
    // if successful, NULL if the key already existed in the dictionary.
    virtual XaCollectable *       insertKeyAndValue(XaCollectable& newKey,
						    void *newValue);
    
    // Return the number of times (0 or 1) that (*targetKey) occurs in
    // the dictionary.
    virtual unsigned    occurrencesOf(const XaCollectable& targetKey) const;

    // Returns a new'd bag that has all of the keys in it.
    // Note: This bag contains pointers to the underlying XaStrings
    // stored in here. DO NOT CHANGE these unless you want to change
    // the keys in the dictionary as well.
    virtual XaBag      *getKeys();
    
    // Remove the Key-Value pair returning the key and object.
    virtual void*       remove(const XaCollectable& targetKey,
			       XaCollectable *&key);

    // Remove the Key-Value and return the value.
    virtual void*       remove(const XaCollectable &targetKey);

    // Remove the key-value pair and delete the key. 
    virtual void        removeAndDestroy(const XaCollectable &targetKey);
    
    // Remove the Key-Value pair and delete the key, return the value.
    virtual void        removeAndDestroy(const XaCollectable& targetKey,
					 void *&value);

    // Remove all objects in this collection, releasing them as we go.
    virtual void        clear(void);
    
    //
    // ---------- Xa / collectability methods
    //

//    virtual unsigned 	hash(void) const;
#ifdef LATER
    virtual XaBoolean     equals(const XaCollectable& anObject) const;
#endif

    // 
    // --------- Copy support
    // 
#ifdef LATER
    // Deepen a shallow copy of this object.
    virtual XaErrorCode    	deepenShallowCopy(void);
#endif

    //By default to a shallow copy.
    virtual XaDictionary&      operator=(const XaDictionary&);

  protected:
    // returns the index of the named key or an empty spot if no such key
    // exists. 
    unsigned		findIndexOf(const XaCollectable& targetKey) const;

  private:
    friend class        XaDictionaryIterator;

    // multiplicative hash function to convert key to hash index
    unsigned		multHash(const XaCollectable& targetKey) const;

    // this is the collection of values for the key-value pairs
    XaBag		values;     // array of values

};

class XaDictionaryIterator : public XaBagIterator
{
  public:
    // 
    // --------- Constructors / destructors
    //

                        XaDictionaryIterator(const XaDictionary& theDict);
                        ~XaDictionaryIterator();

    //
    // --------- Iteration and contained object operations
    //
    
    // Find the next key-value pair in the dictionary whose key equals
    // to (target). Returns the key if such a pair exists, or NULL
    // if a matching key-value pair does not live in the dictionary.
    virtual XaCollectable*        findNext(const XaCollectable& target);

    // Remove the current key-value pair from the dictionary.
    virtual void*        remove(void);

    // Return the value at the current iterator position.
    virtual void*        value(void) const;

    // Replace the value at the current iterator position with (newValue).
    // Returns the old value.
    virtual void*        value(void*& newValue) const;

  private:
    XaDictionary*   	pDict;
};

#endif /*XA_DICTIONARY_H*/
