/* $XConsortium: connection.cc /main/6 1996/12/30 16:29:25 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// 
// @(#)$RCSfile: connection.cc $ $Revision: /main/6 $ (DEC) $Date: 1996/12/30 16:29:25 $
// 

//
// Client
//
#include "connection.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdio.h>

#define DEBUG_ON
static FILE * debug_out = stderr;

#ifdef DEBUG_ON
static int _debug = 1;
#define DEBUG if(_debug)
#else
#define DEBUG if(0)
#endif

XaConnection::XaConnection()
{
    vendorString = "X Audio SI";
    releaseString = "X0.0";
    externalObj = XaTnone;
}

#define COMB 0x00FF00FF

void XaConnection::Swap32(CARD32 *pdata, int length)
{
    CARD32 data;
    while (length--)
    {
	/* swap a long */
	data = *pdata;
	data = (data & COMB) << 8 | (data >> 8) & COMB;
	*pdata++ = data << 16 | data >> 16;
    }
}


static int DEFAULT_BUFFSIZE = 256;

XaProtoBuffer::XaProtoBuffer()
{
    lockLevel = -1; // no locks
    stackSize = 2; // unlikely to need more than this
    
    bufSize = (int *)malloc(stackSize * sizeof(int));
    bufferStack = (char **)malloc(stackSize * sizeof(char *));

    // Build the first buffer.
    // use malloc() so we can realloc()
    bufSize[0] = DEFAULT_BUFFSIZE;
    bufferStack[0] = (char *)malloc(DEFAULT_BUFFSIZE);

    // Zero the rest of the stack
    int i;
    for (i=1; i<stackSize; i++)
    {
	bufferStack[i] = NULL;
	bufSize[i] = 0;
    }

    bufPtr = (char **)malloc(stackSize * sizeof(char *));
    protoLength = (int *)malloc(stackSize * sizeof(int *));
}


XaProtoBuffer::~XaProtoBuffer()
{
    // Free up the buffers we've allocated.
    int i;
    for (i=0; i<stackSize; i++)
    {
	if (bufferStack[i])
	    free(bufferStack[i]);
    }
    
    // and the housekeeping stuff.
    free(bufferStack);
    free(bufSize);
    free(bufPtr);
    free(protoLength);
}

void XaProtoBuffer::Grow(int size)
{
    assert(lockLevel >= 0);

    if (size <= bufSize[lockLevel])
	return;
    while (bufSize[lockLevel] < size)
	bufSize[lockLevel] <<= 1;
    bufferStack[lockLevel] = (char *)realloc(bufferStack[lockLevel], 
						bufSize[lockLevel]);
    assert(bufferStack[lockLevel] != NULL);
    bufPtr[lockLevel] = bufferStack[lockLevel] + protoLength[lockLevel];
}

void XaProtoBuffer::GrowStack()
{
    //Add an element to the stack(s)
    stackSize++;

    bufSize = (int *)realloc((void *)bufSize, stackSize * sizeof(int));
    bufferStack = (char **)realloc((void *)bufferStack,
				    stackSize * sizeof(char *));
    bufPtr = (char **)realloc((void *)bufPtr, stackSize * sizeof(char *));
    protoLength = (int *)realloc((void *)protoLength, 
				stackSize * sizeof(int *));


    // Zero that new element.
    bufSize[stackSize -1] = 0;
    bufferStack[stackSize -1] = NULL;
    bufPtr[stackSize -1] = NULL;
    protoLength[stackSize -1] = 0;
}

void XaProtoBuffer::Lock()
{
    lockLevel++;
    
    // Make sure we have space if we need it.
    if (lockLevel > (stackSize - 1))
	GrowStack();

    assert(lockLevel <= stackSize - 1);

    // Allocate a new buffer if it's required.
    if (!bufferStack[lockLevel])
    {
	bufferStack[lockLevel] = (char *)malloc(DEFAULT_BUFFSIZE);
	bufSize[lockLevel] = DEFAULT_BUFFSIZE;
    }

    Reset();
}

void XaProtoBuffer::Unlock()
{
    lockLevel--;

    assert(lockLevel >= -1);
}

void XaProtoBuffer::Write(char *data, int length)
{
    assert(lockLevel >= 0);

    Grow(protoLength[lockLevel] + length);
    memcpy(bufPtr[lockLevel], data, length);
    bufPtr[lockLevel] += length;
    protoLength[lockLevel] += length;
}

char * XaProtoBuffer::Reserve(int length)
{
    char *retPtr = bufPtr[lockLevel];

    Grow(protoLength[lockLevel] + length);
    bufPtr[lockLevel] += length;
    protoLength[lockLevel] += length;

    return retPtr;
}

void XaProtoBuffer::Reset()
{
    protoLength[lockLevel] = 0;
    bufPtr[lockLevel] = bufferStack[lockLevel];

    // Should  this do more?  Recognize structured parsed protocol and free
    // pointer-type values?
}
