//This line lets emacs recognize this as -*- C++ -*- Code //
/* $XConsortium: collectable.h /main/2 1996/12/30 16:29:21 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//
// Mix in class for adding collectability behavior.

#ifndef XA_COLLECTABLE_H
#define XA_COLLECTABLE_H

//
//  ------------------------------------------
//  Macros / header file includes
//  ------------------------------------------
//

#include "xadefines.h"

class XaCollectable
{
  public:

    // --------- Constructors / destructors
    XaCollectable(void){};

    // Virtual destructor
    virtual 	    	~XaCollectable(void){};

    // Constructor support routines.

    // calls the copy constructor by default
    //    virtual XaCollectable* 	copy() const = 0;

    // Compare (this) to another object. Return values:
    //	    -1 if (this) is less than (anObject)
    //	    0 if (this) and (anObject) are equal
    //	    1 if (this) is greater than (anObject)
    //  virtual int	   compare(const XaCollectable & anObject) const = 0;

    // Return XA_TRUE if (this) is value-equal to (anObject),
    // false otherwise.
    virtual XaBoolean	equals(const XaCollectable & anObject) const = 0;

    // Return a unique hash value for this object.
    virtual unsigned	hash(void) const = 0;

  private:
    // 
    // 
    // Copy constructor. 

    XaCollectable(const XaCollectable& another) {}; 

};

#endif /*XA_COLLECTABLE_H*/
