/* This line lets emacs recognize this as -*- C -*- Code */
/* $XConsortium: cdefines.h /main/3 1996/12/30 16:29:18 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log$
 * Revision 1.1.1.3  1995/11/29  19:21:18  Peter_Derr
 * 	save intermediate work
 *
 * Revision 1.1.1.2  1995/11/21  15:35:49  Peter_Derr
 * 	dictionary and fileio code from Sun
 * 
 * $EndLog$
 */
/*
 * @(#)$RCSfile: cdefines.h $ $Revision: /main/3 $ (DEC) $Date: 1996/12/30 16:29:18 $
 */
/*
 * Copyright (c) 1993, by Sun Microsystems, Inc.
 * 
 * Description:
 *   Basic XA types, constants, and macros that work in C.
 *   The C++ specfic defines are in XaDefines.h
 * 
 */
/*
*/

#ifndef XA_CDEFINES_H
#define XA_CDEFINES_H

#include <sys/types.h>

/* 
 * ------------------------------------------
 * Macros
 * ------------------------------------------
 */ 

/* Generic NULL. Could be used as more than an int, so leave a macro. */
#ifndef NULL
#define NULL	0
#endif

/* 
 * ------------------------------------------
 * Constants
 * ------------------------------------------
 */ 

#define XA_TRUE 1
#define XA_FALSE 0

/* This definition is used as the type for number ID's used to refer to
   a specific class */
typedef unsigned short XaClassType;

/*
 * REMIND: czei 1/25/93
 * 
 * I changed the DEFAULT_QUEUE_SIZE global int to be a define statement, 
 * because it meant that you can't make multiple object files compiled 
 * with XA into a library.  (Every .o things it created a global int 
 * called DEFAULT_QUEUE_SIZE.)
 */
#define XA_DEFAULT_QUEUE_SIZE 32768

/* Less than, equal, and greater than constants for compare() methods */
enum 
{
    XA_COMPARE_LESS_THAN = (int) -1, 
    XA_COMPARE_EQUAL = (int) 0,
    XA_COMPARE_GREATER_THAN = (int) 1
};

/* Enum to define endian nature */
typedef enum XaEndianType 
{
    XA_UNDEFINED_ENDIAN = -1,
    XA_BIG_ENDIAN = 0,
    XA_LITTLE_ENDIAN = 1
} XaEndianType;

/* enum to distinguish input ports from output ports */
typedef enum XaPortType
{
    XA_INPUT = 0,
    XA_OUTPUT = 1
} XaPortType;

/* Known encoding values for XaFormats */
#define XA_ENCODING_UNKNOWN        "XaFormat:Unknown"
#define XA_ENCODING_DVI            "XaFormatSampled:DVI"
#define XA_ENCODING_G721           "XaFormatSampled:G.721"
#define XA_ENCODING_G723           "XaFormatSampled:G.723"
#define XA_ENCODING_ULAW           "XaFormatSampled:uLaw"
#define XA_ENCODING_ALAW           "XaFormatSampled:ALaw"
#define XA_ENCODING_LINEAR         "XaFormatSampled:Linear"

/* For basic data manipulation */
#define Xa_bits_per_byte 8

/* 64-bit integers. */

#ifdef LONG64 /* from Xmd.h */
typedef unsigned long XaUnsignedLongLong;
typedef long XaSignedLongLong;
#else

typedef struct 
{
    unsigned long high;
    unsigned long low;
} XaUnsignedLongLong;

typedef struct 
{
    long high;
    long low;
} XaSignedLongLong;

#endif

/* type of value in an XaMagnitude */
typedef enum
{
    XA_VALUE_IS_DOUBLE,
    XA_VALUE_IS_LONG
}
XaMagnitudeType;

/* mode of an XaNode object */
typedef enum
{
    XA_NODE_PRE_INITIALIZED,
    XA_NODE_INITIALIZED,
    XA_NODE_RUNNING,
    XA_NODE_STOPPED,
    XA_NODE_EXITING,
    XA_NODE_ABORTED
}
XaNodeStatus;

/* mode of an XaMemory object */
typedef enum
{
    XA_MEMORY_RECORD,
    XA_MEMORY_PLAY
}
XaMemoryMode;

/* enum to distinguish kinds of wire processors */
typedef enum XaWireProcType
{
    XA_WIRE_INPUT = 0,
    XA_WIRE_OUTPUT = 1,
    XA_WIRE_BIDIRECTIONAL = 2
} XaWireProcType;


#endif /* XA_CDEFINES_H */
