/* $XConsortium: atom.h /main/3 1996/12/30 16:29:05 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// atom
// 
// Atoms are Tags that point to strings.
// They live in a special tag space all on there own.
//
#ifndef _ATOM_H
#define _ATOM_H

#include "xadefines.h"
#include "dictionary.h"
#include "xastring.h"
#include <stdio.h>

// You basic atom dictionary.
class XaAtomCache {

public:

    // Builds the atoms out of a textfile which
    // includes atoms strings and tagvalues.
    XaAtomCache();
    ~XaAtomCache();
    
    // Call to get the predefined atoms.
    XaErrorCode Init();

    // Puts an Atom/String into the Cache.
    // it makes a copy of the string.
    XaErrorCode AddAtom(XaAtom a, const char *s);

    XaBoolean StringExists(const char *);
    XaBoolean ValidAtom(XaAtom a);
    
    // You have to copy out the string if you want
    // to keep it around, returns NULL if
    // it can't find one.
    const char *StringByAtom(XaAtom a);
    // XaTnone, if it can't find it.
    XaAtom AtomByString(const char *);

    void printOn(FILE *);
    
protected:
    XaDictionary byString;
    XaDictionary byAtom;
};




#endif

