/* $XConsortium: atom.cc /main/4 1996/12/30 16:29:03 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

// atom.cc
//
// AtomStore & AtomCache
//

#include "atom.h"
#include "ctag.h"
#include <Xa/atomdefs.h>
#include "connection.h"

// Function to generate predefined atoms.
// This is generated by the program akeatoms.
// into the file initatoms.cc
XaErrorCode InitializeCache(XaAtomCache &a);

XaAtomCache::XaAtomCache() {}

XaErrorCode XaAtomCache::Init() {
  return InitializeCache(*this);
}

XaAtomCache::~XaAtomCache() {

  // Deletes the keys in the dictionary.
//  byAtom.clearAndDelete;
//  byString.clearAndDelete;
}

XaErrorCode XaAtomCache::AddAtom(XaAtom a, const char *s) {
  
    // Make the tag and string collectable.
    XaCTag *ctag = new XaCTag(a);
    XaString *str = new XaString(s);
    if( !ctag || !str) {
      delete ctag;
      delete str;
      return XaEFailure;
     }
	
    // Yes, yes this is bigger than
    // it ought to be. But I'm not
    // sure yet which tradeoff to make
    // and we're not duplicating data values
    // here just the the tables that hold
    // the values, and the vtables.
    if( (byString.insertKeyAndValue(*str, ctag) == NULL)) {
        delete ctag;
	delete str;
	return XaEFailure;
    }
    if(byAtom.insertKeyAndValue(*ctag, str) == NULL) {
	// clean up.
	byString.remove(*str);
	delete ctag;
	delete str;
	return XaEFailure;
    }

    return XaESuccess;
}

XaBoolean XaAtomCache::ValidAtom(XaAtom a) {
  XaCTag t(a);
  return (byAtom.occurrencesOf(t) == 0) ? XaFalse : XaTrue;
}

XaBoolean XaAtomCache::StringExists(const char *cs) {
  XaString s(cs);
  return (byString.occurrencesOf(s) == 0) ? XaFalse : XaTrue;
}

XaAtom XaAtomCache::AtomByString(const char *cs) {
    XaString s(cs);
    XaCTag *ctag = (XaCTag*)byString.findValue(s);

    return (ctag == NULL) ? XaTnone : (XaAtom)(XaTag)*ctag;
}

const char *XaAtomCache::StringByAtom(XaAtom a) {

    XaCTag t(a);
    XaString *s = (XaString*)byAtom.findValue(t);
    
    return (s == NULL) ? (const char *)NULL : (const char *)*s;
}

void XaAtomCache::printOn(FILE *out) {

    fprintf(out, "Atom Dictionary\n");
    XaDictionaryIterator dI(byAtom);
    XaCTag *ct;
    XaString *s;
    while( (ct = (XaCTag*)dI()) != NULL) {
	s = (XaString*)dI.value();
	const char *str = (const char*)*s;
	fprintf(out, "%u\t\t\"%s\"\n",
		(XaTag)*ct, str);
    }
}

