/* $XConsortium: Xaprotocol.h /main/3 1996/12/30 16:29:00 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/* 
 * Copyright (c) 1996 Digital Equipment Corporation
 * 
 * Digital Equipment Corporation makes no representations about
 * the suitability of this Software for any purpose.  The Software
 * is provided "as is" without express or implied warranty.
 *
 * HISTORY
 * 
 * @(#)$RCSfile: Xaprotocol.h $ $Revision: /main/3 $ (DEC) $Date: 1996/12/30 16:29:00 $
 */

#ifndef XAPROTOCOL_H
#define XAPROTOCOL_H

/* #include <X11/ICE/ICEproto.h> */
#include <X11/Xmd.h>

typedef CARD32 TAG;

typedef TAG ATOM;

typedef TAG BUFFER;

typedef INT32 TIME;


#define XA_PROTOCOL_NAME "X_Consortium_Audio"


struct XaProtoItem
{
    ATOM	name;
    CARD32	value;
};

struct XaProtoArrayPart
{
    ATOM	arrayPartAtom;
    CARD32	offset;
    CARD32	length;
    ATOM	name;
    /* CARD32	elements; */
};

struct XaProtoArray
{
    ATOM	arrayAtom;
    CARD32	length;		/* number of elements */
    ATOM	name;
    /* CARD32	elements; */
};

struct XaProtoType
{
    ATOM	typeAtom;
    ATOM	source_type;
};

/*
 * This is identical to XaProtoArray except that it has the 'elements'
 * field.  It's useful in parsing protocol parameter lists.
*/
struct XaArray
{
    ATOM	arrayAtom;
    CARD32	length;		/* number of elements */
    ATOM	name;
    CARD32	*elements;
};
/*
 * libXa counts on XaProtoArray and XaProtoCollection being the same.
 *
 * struct XaProtoCollection
 *     {
 *     ATOM	collectionAtom; // XaPcollection{Replace|Add|Subtract} //
 *     CARD32	numItems;
 *     ATOM	name;
 *     // CARD32	values; // start of set of values //
 *     };
 */

typedef struct XaProtoArray XaProtoCollection;


/* Request and Event opcodes */

#define FINDATOM	1
#define CREATE		2
#define DESTROY		3
#define SET		4
#define GET		5
#define WRITE		6
#define READ		7
#define FINDOBJECT	8
#define PING		9

#define STARTUP_EVENT	32
#define CHANGE_EVENT	33
#define CREATE_EVENT	34
#define DESTROY_EVENT	35
#define TAG_REPLY	36
#define FIND_REPLY	TAG_REPLY
#define ATTRIBUTE_REPLY	37
#define GET_REPLY	ATTRIBUTE_REPLY
#define AUD_DATA_REPLY	38
#define PING_REPLY	39

#define ERROR_REPLY	64
#define ERROR_EVENT	65



/* from ICEproto.h
 *
 * typedef struct {
 *     CARD8       majorOpcode;
 *     CARD8       minorOpcode;
 *     CARD8       data[2];
 *     CARD32      length B32;
 * } iceMsg;
 */

/* This must exactly match the iceMsg */

struct XaProtoHeader
{
    CARD8       majorOpcode;
    CARD8       minorOpcode;
    CARD8       data[2];
    CARD32      length B32;
};

#define _XaProtoHeader \
    CARD8       majorOpcode; \
    CARD8       minorOpcode; \
    CARD8       data[2]; \
    CARD32      length B32;


/*
 * This is intended to match the beginning of every request that expects a
 * reply.
 */
struct XaRequestWithReply
{
    _XaProtoHeader
    CARD32	reply_id;
};


struct XaFindAtomRequest
{
    /* _XaProtoHeader */
    CARD8       majorOpcode;
    CARD8       minorOpcode;
    BOOL        create;
    CARD8       unused;
    CARD32      length B32;
    /* end of ICE header */
    CARD32	reply_id;
    /* STRING8	name;  variable length NULL terminated string */
};

struct XaFindObjectRequest
{
    _XaProtoHeader
    CARD32	reply_id;
    TAG		classId;
    /* XaProtoItem	items; // start of LISTofITEM */
};


struct XaCreateRequest
{
    _XaProtoHeader
    TAG			id;
    ATOM		classId;
    /* XaProtoItem	items; // start of LISTofITEM */
};

struct XaDestroyRequest
{
    _XaProtoHeader
    TAG			object;
};

struct XaSetRequest
{
    _XaProtoHeader
    TAG			object;
    /* XaProtoItem	items; // start of LISTofITEM */
};

struct XaGetRequest
{
    _XaProtoHeader
    CARD32		reply_id;
    TAG			object;
    CARD32		n_attributes;
    /* ATOM		ret_attributes; // start of LISTofATOM */
};

struct XaWriteRequest
{
    _XaProtoHeader
    TAG			object;
    TIME		when;
    TAG			time_ref;
    CARD32		bit_length; /* length in bits */
    CARD8		leftPad[4];
    TAG			trigger;
    /* BYTE		data[4]; // arbitrary size, determined from bit_length*/
};

struct XaReadRequest
{
    _XaProtoHeader
    CARD32		reply_id;
    TAG			object;
    TIME		when;
    TAG			time_ref;
    CARD32		min_bits; /* length in bits */
    CARD32		max_bits; /* length in bits */
};

struct XaPingRequest
{
    _XaProtoHeader
    CARD32		reply_id;
    CARD32		pad;
};

/*
 * ====== Events and Replies =======
 */


struct XaProtoReply
{
    _XaProtoHeader
    CARD32		replyID;
};

struct XaStartupEvent
{
    _XaProtoHeader
    TAG			connection;
    TAG			server;
    TAG			tagRangeTag;
    CARD32		tagRangeLength;
};

struct XaChangeEvent
{
    _XaProtoHeader
    TAG			object;
    CARD32		triggerCount;
    /* TAG[c]		trigger; */
    /* LISTofITEM	params;  */
};

/*
 * XaChangeEvent, XaCreateEvent, and XaDestroyEvent have the same contents
 * but they are NOT the same event.
 */
typedef struct XaChangeEvent XaCreateEvent;
typedef struct XaChangeEvent XaDestroyEvent;

struct XaTagReply
{
    _XaProtoHeader
    CARD32		replyID;
    /* LISTofTAG	object_tags; */
};
/* FindReply == TagReply */
typedef struct XaTagReply XaFindReply;

struct XaAttributeReply
{
    _XaProtoHeader
    CARD32		replyID;
    /* LISTofITEM	params; */
};
/* XaGetReply == XaAttributeReply */
typedef struct XaAttributeReply XaGetReply;

struct XaAudioDataReply
{
    _XaProtoHeader
    CARD32		replyID;
    TIME		startTime;
    TIME		endTime;
    TAG			refTime;
    CARD32		numBits;
    CARD32		leftPad;
    /* CARD8[c]		audioData; */
};

struct XaPingReply
{
    _XaProtoHeader
    CARD32		replyID;
    CARD32		pad;
};

struct XaErrorReply
{
    _XaProtoHeader
    CARD32		replyID;
    CARD8		errorCode;
};

struct XaErrorEvent
{
    _XaProtoHeader
    TAG			object;
    CARD8		errorCode;
    CARD8		pad[3];
    /* TAG[c]		trigger; */
};

#endif /* XAPROTOCOL_H */
