package provide events 1.0

# Events.tcl
# handle system and user added events.
#
# and event is described in the following manner
#
# LEVEL:EVENT:CHANNEL:NICK|USERHOST:ACTION
#
# where 
#
#	LEVEL = users level in user list (if not in list the level = 0)
#
#	EVENT = the event that was triggered
#
#	CHANNEL = the channel the event was triggered on  or "*"
#
#	NICK|USERHOST = the nickname or userhost or "*" that triggered the event
#
#	ACTION = zipper irc command to execute


proc irc_event {ircevent ircchan ircuser target} {
	global eventlist
	global userlist
	global myuserhost
	global nick


	set ircevent [string tolower $ircevent]
	set ircchan [string tolower $ircchan]
	set ircuser [string tolower $ircuser]
	set me [string tolower $nick]
	set level [get_level $ircuser]
	if [is_me $ircuser] { return }
	foreach item $eventlist {
	 	set list [split $item ":"]
		set evlevel [lindex $list 0]
		set evevent [lindex $list 1]
		set evchannel [lindex $list 2]
		set evuser [lindex $list 3]
		set evaction [lindex $list 4]

		set evchannel [string tolower $evchannel]
		set evevent [string tolower $evevent]
		set evuser [string tolower $evuser]

		if ![string compare $ircevent $evevent] {
		if [string match $evuser $ircuser] {
			if [string match $evchannel $ircchan] {
				if [expr $level >= $evlevel] {

					set l [split $evaction ";"]
					foreach command $l {
						substitute $ircuser $ircchan $target
						fake_user_in $command
					}
				}
			}

		}
		}

	}

}
