package provide clicks 1.0


proc leave_chan_button {w} {
        global winlist
        global esvrSock

}                               

proc open_irc_connection {} {
# open the connection to the IRC server...
global esvrSock
global server
global port
global serveractive
global username
global hostname
global realname
global nick
global notify

set nicklogin "NICK $nick"
set userlogin "USER $username $hostname $server :$realname"


send_to_window server "\002\0035,8Connecting to IRC server $server:$port...\n\n"
set esvrSock ""
set esvrSock [socket $server $port]

# Setup monitoring on the socket so that when there is data to be 
# read the proc "read_sock" is called
fileevent $esvrSock readable [list read_sock $esvrSock]

# configure channel modes
# ensure the socket is line buffered so we can get a line of text 
# at a time (Cos thats what the server expects)...
# Depending on your needs you may also want this unbuffered so 
# you don't block in reading a chunk larger than has been fed 
#  into the socket
fconfigure $esvrSock  -buffering line


puts $esvrSock $nicklogin
puts $esvrSock $userlogin
set serveractive 1
wm title .zipperserver "$nick on server $server  port: $port"
.zipperserver.controls.connect configure -state disabled
.zipperserver.controls.disconnect configure -state normal


puts $esvrSock "ISON $notify"
check_notify
}                     


proc modify_notify {} {
        global notify

        if [winfo exists ".zipperpernotify"] {
                raise .zipperpernotify
                focus .zipperpernotify.box.list

        } else {
          new_pers_notify
        }

        .zipperpernotify.box.list delete 0 end
	set notify [lsort  -command customsort $notify] 
        foreach name $notify {
                .zipperpernotify.box.list insert end $name

        }

}


proc notify_add {} {

        global notify

        set name [.zipperpernotify.box.name get]
        fake_user_in "/notify $name"
        .zipperpernotify.box.name delete 0 end

        .zipperpernotify.box.list delete 0 end
        foreach name $notify {
                .zipperpernotify.box.list insert end $name

        }
}
proc notify_del {} {

        global notify

        set name [.zipperpernotify.box.list get active]
        fake_user_in "/notify $name"

        .zipperpernotify.box.list delete 0 end
        foreach name $notify {
                .zipperpernotify.box.list insert end $name

        }
}                 
proc modify_channels {} {
        global channels

        if [winfo exists ".zipperperchan"] {
                raise .zipperperchan
                focus .zipperperchan.box.list

        } else {
          new_pers_channel
        }

        .zipperperchan.box.list delete 0 end
	set channels [lsort -command customsort $channels]
        foreach name $channels {
                .zipperperchan.box.list insert end $name

        }

}

proc modify_events {} {
        global eventlist

        if [winfo exists ".zipperevents"] {
                raise .zipperevents
                focus .zipperevents.box.list

        } else {
          new_event_list
        }

        .zipperevents.box.list delete 0 end
	set eventlist [lsort -command customsort $eventlist]
        foreach name $eventlist {
                .zipperevents.box.list insert end $name

        }

}     
proc modify_ctcps {} {
        global ctcp_message

        if [winfo exists ".zipperctcps"] {
                raise .zipperctcps
                focus .zipperctcps.box.list

        } else {
          new_ctcp_list
        }

        .zipperctcps.box.list delete 0 end
	set ctcp_message [lsort  -command customsort $ctcp_message] 
        foreach name $ctcp_message {
                .zipperctcps.box.list insert end $name

        }
	
}

proc modify_users {} {
        global userlist

        if [winfo exists ".zipperusers"] {
                raise .zipperusers
                focus .zipperusers.box.list

        } else {
          new_user_list
        }

        .zipperusers.box.list delete 0 end
	set userlist [lsort -command customsort $userlist]
        foreach name $userlist {
                .zipperusers.box.list insert end $name

        }

}          
              
proc channel_add {} {

        set name [.zipperperchan.box.name get]
        .zipperperchan.box.list insert end $name

}
proc channel_del {} {

        .zipperperchan.box.list delete active
}
proc channel_join {} {

        set channel [.zipperperchan.box.list get active]
        fake_user_in "/join $channel"
}
proc channel_names {} {

        set channel [.zipperperchan.box.list get active]
        fake_user_in "/names $channel"
}

proc channel_done {} {
        global channels

        set channels ""

        set chanlist [.zipperperchan.box.list get 0 end]
        foreach chan $chanlist {
                set channels [linsert $channels end $chan]
        }
        fake_user_in "/save channels"
        destroy .zipperperchan
}                               

proc modify_servers {} {
        global servers

        if [winfo exists ".zipperperserv"] {
                raise .zipperperserv
                focus .zipperperserv.box.list

        } else {
          new_pers_server
        }

        .zipperperserv.box.list delete 0 end
	set servers [lsort -command customsort $servers]
        foreach name $servers {
                .zipperperserv.box.list insert end $name

        }

}
proc server_add {} {
	set name ""
	set port ""

        set name [.zipperperserv.box.name get]
	set port [.zipperperserv.box.port get]
	
	if ![string compare $name ""] {
		return
	}
	if ![string compare $port ""] {
		set port 6667
	}

	set name "$name:$port"	
        .zipperperserv.box.list insert end $name

}
proc server_del {} {

        .zipperperserv.box.list delete active
}
proc server_connect {} {

        set serv [.zipperperserv.box.list get active]
        set tmplist [split $serv ":"]
        set serv [lindex $tmplist 0]
        set sport [lindex $tmplist 1]

        fake_user_in "/disconnect"
        fake_user_in "/server $serv $sport"
}
proc server_done {} {
        global servers

        set servers ""

        set servlist [.zipperperserv.box.list get 0 end]
        foreach serv $servlist {
                set servers [linsert $servers end $serv]
        }
        fake_user_in "/save servers"
        destroy .zipperperserv
}   

proc modify_ignore {} {
        global ignore
        if [winfo exists ".zipperperig"] {
                raise .zipperperig
                focus .zipperperig.box.list

        } else {
          new_pers_ignore
        }

        .zipperperig.box.list delete 0 end
	set ignore [lsort -command customsort $ignore]
        foreach name $ignore {
                .zipperperig.box.list insert end $name

        }

}
proc ignore_add {} {

        set name [.zipperperig.box.name get]
        .zipperperig.box.list insert end $name

}
proc ignore_del {} {

        .zipperperig.box.list delete active
}
proc ignore_upd {} {
	global ignoreindex
	
	if [expr $ignoreindex < 0 ] {return}
	.zipperperig.box.list delete $ignoreindex $ignoreindex
	ignore_add
	set ignoreindex -1



}
proc ignore_done {} {
        global ignore
        set ignore ""

        set iglist [.zipperperig.box.list get 0 end]
        foreach ig $iglist {
                set ignore [linsert $ignore end $ig]
        }
        fake_user_in "/save ignore"
        destroy .zipperperig
}


proc user_add {} {

	set name ""
	set level 0

        set name [.zipperusers.box.name get]
	set level [.zipperusers.box.level get]
	set options [.zipperusers.box.options get]
	if ![string compare $name ""] {
		return
	}
	if ![string compare $level ""] {
		set level 0
	}

	set name "$level:$name:$options"	
        .zipperusers.box.list insert end $name

}
proc user_del {} {

        .zipperusers.box.list delete active
}

proc user_upd {} {
	global userindex
	if [expr $userindex < 0 ] {return}
	.zipperusers.box.list delete $userindex $userindex
	user_add
	set userindex -1

}
proc user_done {} {
        global userlist
        set userlist ""

        set ulist [.zipperusers.box.list get 0 end]
        foreach user $ulist {
                set userlist [linsert $userlist end $user]
        }
        fake_user_in "/save users"
        destroy .zipperusers
}                          

proc ctcp_add {} {
	set level ""
	set type ""
	set nick ""
	set channel ""
	set action ""

        set level [.zipperctcps.f1.level get]
        set type [string toupper [.zipperctcps.f1.type get]]
        set nick [.zipperctcps.f1.nick get]
        set channel [.zipperctcps.f1.channel get]
        set action [.zipperctcps.f1.action get]

	if ![string compare $level ""] {
		set level 0
	}
	if ![string compare $type ""] {
		return
	}
	if ![string compare $nick ""] {
		set nick "*"
	}
	if ![string compare $channel ""] {
		set channel "*"
	}
	if ![string compare $action ""] {
		return
	}


	set name "$level:$type:$nick:$channel:$action"
        .zipperctcps.box.list insert end $name

}
proc ctcp_del {} {

        .zipperctcps.box.list delete active
}
proc ctcp_upd {} {

	global ctcpindex
	if [expr $ctcpindex < 0 ] {return}
	.zipperctcps.box.list delete $ctcpindex $ctcpindex
	ctcp_add
	set ctcpindex -1
}

proc ctcp_done {} {
        global ctcp_message
        set ctcp_message ""

        set elist [.zipperctcps.box.list get 0 end]
        foreach ctcp $elist {
                set ctcp_message [linsert $ctcp_message end $ctcp]
        }
        fake_user_in "/save ctcp"
        destroy .zipperctcps
}                                              
proc event_add {} {
	set level ""
	set type ""
	set nick ""
	set chan ""
	set action ""

        set level [.zipperevents.f1.level get]
        set type [string toupper [.zipperevents.f1.type get]]
        set nick [.zipperevents.f1.nick get]
        set chan [.zipperevents.f1.channel get]
        set action [.zipperevents.f1.action get]

	if ![string compare $level ""] {
		set level 0
	}
	if ![string compare $type ""] {
		return
	}
	if ![string compare $nick ""] {
		set nick "*"
	}
	if ![string compare $chan ""] {
		set chan "*"
	}
	if ![string compare $action ""] {
		return
	}


	set name "$level:$type:$nick:$chan:$action"
        .zipperevents.box.list insert end $name

}
proc event_del {} {

        .zipperevents.box.list delete active
}
proc event_upd {} {
	global eventindex
	if [expr $eventindex <  0 ] {return}
	.zipperevents.box.list delete $eventindex $eventindex
	event_add
	set eventindex -1
}
proc event_done {} {
        global eventlist
        set eventlist ""

        set elist [.zipperevents.box.list get 0 end]
        foreach event $elist {
                set eventlist [linsert $eventlist end $event]
        }
        fake_user_in "/save events"
        destroy .zipperevents
}



proc load_ignore_edit {} {
	set w .zipperperig.box.list	
	set z .zipperperig.box
	set x [$w get active]
	set x [split $x ":"]
	set name [lindex  $x  0] 

	$z.name delete 0 end
	$z.name insert end $name

}
proc load_ctcp_edit {} {
	set w .zipperctcps.box.list	
	set z .zipperctcps.f1
	set x [$w get active]
	set x [split $x ":"]
	set level [lindex $x 0]
	set type  [lindex  $x  1] 
	set nick [lindex  $x  2] 
	set channel [lindex  $x  3] 
	set action [lindex $x 4] 

	$z.level delete 0 end
	$z.level insert end $level	

	$z.type delete 0 end
	$z.type insert end $type

	$z.nick delete 0 end
	$z.nick insert end $nick	

	$z.channel delete 0 end
	$z.channel insert end $channel

	$z.action delete 0 end
	$z.action insert end $action	
}
proc load_event_edit {} {
	set w .zipperevents.box.list	
	set z .zipperevents.f1
	set x [$w get active]
	set x [split $x ":"]
	set level [lindex $x 0]
	set type  [lindex  $x  1] 
	set nick [lindex  $x  2] 
	set channel [lindex $x 3] 
	set action [lindex $x 4] 

	$z.level delete 0 end
	$z.level insert end $level	

	$z.type delete 0 end
	$z.type insert end $type

	$z.nick delete 0 end
	$z.nick insert end $nick	

	$z.channel delete 0 end
	$z.channel insert end $channel	

	$z.action delete 0 end
	$z.action insert end $action	
}
proc load_user_edit {} {
	set w .zipperusers.box.list	
	set z .zipperusers.box
	set x [$w get active]
	set x [split $x ":"]
	set level [lindex $x 0]
	set nick [lindex  $x  1] 

	$z.level delete 0 end
	$z.level insert end $level	

	$z.name delete 0 end
	$z.name insert end $nick	

}


proc unban_button {} {

	set w .zipperbanlist
	
	set chan [$w.bans.channel cget -text]
	set ban [$w.bans.list get active]

	fake_user_in "/mode $chan -b $ban"
	$w.bans.list del 0 end
	fake_user_in "/mode $chan +b"	
}
