/*
 *  RoloSaveOkCB()  - ok button CB routine for save dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   29-Jan-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"

void RoloSaveOkCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data;
XtPointer
    call_data;
{
    char
        *s = (char *) NULL;
    
    int
        rc = 0;

    s = XmTextGetString (GsaverTextW);

    if ((int) strlen (s) != 0)
    {
        rc = OpenAndSaveFile (s);
        if (rc == 0)
        {
            if (GsaveAsing == False)
            {
                if (GsaveAndExit == True)
                {
                    (void) unlink (GtempFilename);
                    exit(1);
                }
            }
            else
            {
                /*
                ** we already did a Save As..
                */
                GwroteToTempfile = False;
                GrolodexModified = False;
            }
            XtUnmanageChild (widget);
            SetCautionCursorState (w_special[MAINWINDOW_W],False);
        }
        else
            WriteStatus (1, rolomessageTextW,
                "Could not save Cards!");
    }
    else
        WriteStatus (1, rolomessageTextW, 
            "No filename provided..Cards Not saved!");
    if (s != (char *) NULL)
        (void) free ((char *) s);

}
