/*
 *  MailCB()    - callback routine for mail dialog buttons
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Nov-94   first cut
 */


#include "xhead.h"
#include "defines.h"

#include "xymrolo.h"

void MailCB (widget,  client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{

    switch((int) client_data)
    {
        case 0: /* sign */
        {
            AddSignature();
            break;
        }

        case 1: /* send mail */
        {
            SendMail();
            break;
        }

        case 2: /* include file */
        {
            if (!XtIsManaged(GfileincD))
            {
                XtManageChild (GfileincD);
                SetCautionCursorState (w_special[MAINWINDOW_W], True);
                SetCautionCursorState (w_special[MAIL_FORMD_W], True);
            }
            break;
        }

        case 3: /* dismiss dialog */
        {
            XtUnmanageChild (w_special[MAIL_FORMD_W]);
            SetCautionCursorState (w_special[MAINWINDOW_W], False);
            break;
        }
        
    }
}
