/*
 *  CreateDialogs() -  create various dialogs for Yrolo
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   31-Mar-95   first cut
 */

#include "xhead.h"
#include "xymrolo.h"

void CreateDialogs (parent)
Widget
    parent;
{
    /*
    ** create the message dialog
    */
    GerrorDialogW = CreateMessageDialog (parent, "Error",
        XmDIALOG_ERROR, 1, 0, 1);
    /*
    ** create the help dialog
    */
    (void) CreateHelpDialog (parent);

    /*
    ** Create Info dialog
    */
    (void) CreateRolodexInfoD (parent);

    /*
    ** create the about dialog
    */
    (void) CreateAboutDialog (parent);

    /*
    ** create the save dialog
    */
    (void) CreateSaveRoloD (parent);

    /*
    ** create the edit dialog
    */
    (void) CreateEditDialog (parent);

    /*
    ** create the file selection dialog
    */
    (void) CreateFileOpenDialog (parent);

    /*
    ** create the mail dialog
    */
    (void) CreateMailDialog (parent);

    /*
    ** create Search option dialog
    */
    (void) CreateSearchOptionD (parent);

    /*
    ** create the warning dialog ..ask for saving rolodex
    */
    (void) CreateAskSaveDialogW (parent);


    /*
    ** create the include file selection dialog
    */
    (void) CreateIncludeFileOpenD (w_special[MAIL_FORMD_W]);

    /*
    ** create the search output list widget
    */
    (void) CreateSearchOutputDiaog (parent);

    /*
    ** create print dialog
    */
    (void) CreatePrintDialog (parent);
}
