/******************************************************************************
 * $RCSfile: Menu.c,v $   $Revision: 1.2 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static list layoutentries = NULL;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    Create_layoutentries(Widget);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    CreateXWhoMenu(Widget parent,
		   xwhowidget w,
		   int col,
		   int line)
{
	Widget menushell, entry;

	w->widget = XtVaCreateManagedWidget("xwhoMenuButton",
					    menuButtonWidgetClass, parent,
					    XtNlabel, w->label, NULL);
	XpTableChildConfig(w->widget, col, line, w->columns, 1, FORMOPT);

	menushell = XtCreatePopupShell("menu", simpleMenuWidgetClass,
				       XtParent(w->widget), NULL, 0);


	Create_layoutentries(menushell);

	entry = XtVaCreateManagedWidget("xwhoMenuEntry",
					smeBSBObjectClass, menushell,
					XtNlabel, "Quit", NULL);
	XtAddCallback(entry, XtNcallback, Quit, NULL);
}


/*----------------------------------------------------------------------------*/
void
    Add_layoutentries(string layout_tag)
{
	string entry = NULL;

	StrTrueReAlloc(&entry, layout_tag);
	AddTrueNewSorted_list((list*)&layoutentries, entry,
			      (int(*)(void*,void*))strcmp);
}


/*----------------------------------------------------------------------------*/
static void
    Create_layoutentries(Widget parent)
{
	list l;
	Widget entry;

	for (l = layoutentries; ! Empty_list(l); l = Next_list(l)) {
		string layout_tag = First_list(l);

		entry = XtVaCreateManagedWidget("xwhoMenuEntry",
						smeBSBObjectClass, parent,
						XtNlabel, layout_tag, NULL);
		XtAddCallback(entry, XtNcallback,
			      (XtCallbackProc)CreateLayout, NULL);
	}
}
