/******************************************************************************
 * $RCSfile: sys.h,v $   $Revision: 1.9 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#ifndef _MISC_SYS_H
#define _MISC_SYS_H


#include <stdio.h>
#include <unistd.h>
#include <pwd.h>
#include <utmp.h>
#include <sys/types.h>
#include <sys/param.h>
#ifndef ultrix
#  include <sys/socket.h>
#  include <netdb.h>
#endif
#include <netinet/in.h>
#include <X11/Xlib.h>
	/* XDisplayString() */

#include <misc/str.h>

#ifndef MAXHOSTNAMELEN
#  define MAXHOSTNAMELEN 64
#endif

#ifndef UTMP_FILE
#  define UTMP_FILE "/etc/utmp"
#endif

#if defined(sun) || defined(ultrix)
#  define ut_user ut_name
#endif

struct UTmp {
	char user[9];
	char tty[13];
	char host[MAXHOSTNAMELEN + 1];
};


extern char*  /* name of the host, the process is running on (static buffer) */
    GetHostname();


extern struct hostent *  /* a structure describing the host */
    GetHostByName(char*  /* name or alias of a host */
		  );


extern char*  /* full name of the host, the process is
	       * running on (static buffer) */
    GetFullHostname();


extern int  /* does the host exist? */
    TestHostname(char*  /* name or alias of a host */
		 );


extern char*  /* full name of the host  or  NULL (no such host)
	       * (static buffer) */
    GetHostnameByName(char*  /* hostname */
		      );


extern int  /* is the host reachable via net */
    PingHost(char*  /* name or alias of a host */
	     );


extern char*  /* full name of the host (static buffer) */
    GetDisplayHostname(Display*  /* X-display */
		       );


extern char*  /* login name of the caller (static buffer) */
    GetLogin();

extern char*  /* real name of a user */
    GetRealName(char*  /* the user */
		);

extern void
    UTmpName(const char*);

extern struct UTmp *
    GetUTEnt();

extern void
    EndUTEnt();


#endif	 /* _MISC_SYS_H */
