/******************************************************************************
 * $RCSfile: str.h,v $   $Revision: 1.4 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#ifndef _MISC_STR_H
#define _MISC_STR_H


#include <string.h>
#ifdef SVR4
#  define bzero(s,size)     memset(s,0,size)
#  define bcmp(s1,s2,size)  memcmp(s1,s2,size)
#  define bcopy(s1,s2,size) memcmp(s2,s1,size)
#else
#  include <strings.h>
#endif /* SVR4 */
#include <misc/mem.h>
	/* TrueReAlloc() */


/*----------------------------------------------------------------------------*
 * typedefs
 *----------------------------------------------------------------------------*/

typedef char *string;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern void
StrTrueReAlloc(
   string *,			/* pointer to the old string, or NULL */
   const char *			/* initialisation for the string */
);				/* Erzeugt den String aus einem alten String
				 * und besetzt ihn vor */


extern void
StrTrueAppend(
   string *,			/* String */
   char				/* ein Zeichen, das an den String angeh"angt
				 * werden soll */
);


extern void
StrTrueCat(
   string *,			/* String */
   char *			/* soll an den String angeh"angt werden */
);


extern void
StrSplit(
   string *,			/* substring before the split-character */
   string *,			/* substring after the split-character */
   char *,			/* string to split */
   char *			/* split-characters */
);				/* splits a string in a part before a
				 * split-character and a part after it. if a
				 * pointer to the substring is NULL this part
				 * will be ignored */


extern int
StrMatch(
   char *,			/* string to match against pattern */
   char *			/* pattern (extended regular expression) */
);				/* returns 1 if the string matches the pattern,
				 * else 0 */


extern void
StrFree(
   string *
);


#endif	 /* _MISC_STR_H */
