/******************************************************************************
 * $RCSfile: str.c,v $   $Revision: 1.5 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/


#include "str.h"
#ifdef SVR4
#  include <stdlib.h>
#  include <libgen.h>
#endif
#if defined(hpux) || defined(linux)
#  include <regex.h>
#endif


/*----------------------------------------------------------------------------*/
void
StrTrueReAlloc(
   string *strptr,
   const char *init
)
{
	if (init == NULL) {
		*strptr = (string)TrueReAlloc((void *)*strptr,
							1, sizeof (char));
		(*strptr)[0] = '\0';
	}
	else {
		*strptr = (string)TrueReAlloc((void *)*strptr,
						strlen(init) + 1, sizeof(char));
		strcpy((char *)*strptr, init);
	}
}


/*----------------------------------------------------------------------------*/
void
StrTrueAppend(
   string *strptr,
   char addc
)
{
	int len = *strptr == NULL ? 0 : strlen(*strptr);

	*strptr = (string)TrueReAlloc((void *)*strptr, len + 2, sizeof(char));

	(*strptr)[len] = addc;
	(*strptr)[len + 1] = '\0';
}


/*----------------------------------------------------------------------------*/
void
    StrTrueCat(string* strptr,
	       char* addstr)
{
	if (*strptr == NULL)
	    StrTrueReAlloc(strptr, addstr);
	else {
		*strptr = (string)
		    TrueReAlloc((void*)*strptr,
				strlen((char*)*strptr) + strlen(addstr) + 1,
				sizeof(char));
		strcat((char*)*strptr, addstr);
	}
}


/*----------------------------------------------------------------------------*/
void
StrSplit(
   string *str_before,
   string *str_after,
   char *str,
   char *split
)
{
	string buf = NULL;
	char *s, *sp;
	int found = 0;

	StrTrueReAlloc(&buf, str);
	for (s = (char *)buf; (*s != '\0') && !found; s++) {
		for (sp = split; (*sp != '\0') && !found; sp++) {
			if (*s == *sp)
				found = 1;
		}
	}
	if (found) {
		*(s-1) = '\0';
		if (str_after != NULL)
			StrTrueReAlloc(str_after, s);
	}
	else {
		if (str_after != NULL)
			StrTrueReAlloc(str_after, "");
	}
	if (str_before != NULL)
		StrTrueReAlloc(str_before, (char *)buf);
	StrFree(&buf);
}


/*----------------------------------------------------------------------------*/
int
StrMatch(
   char *str,
   char *pattern
)
{
#ifdef hpux
	int ret;
	regex_t re;

	if (regcomp(&re, pattern, REG_EXTENDED | REG_NOSUB)  !=  0)
		Error(-1, "regcomp() failed");
	ret = regexec(&re, str, (size_t)0, NULL, 0);
	regfree(&re);
	if (ret != 0)
		return (0);
	else
		return (1);
#else
#  ifdef SVR4
	char* ret;
	char* re;

	if ((re = regcmp(pattern, NULL)) == NULL)
	    Error(-1, "regcmp(): incorrect argument \"%s\"", pattern);
	ret = regex(re, str);
	free(re);
	if (ret == NULL)
	    return (0);
	else
	    return (1);
#  else
	int ret;
	char* error_msg;

	if ((error_msg = (char*)re_comp(pattern)) != NULL)
	    Error(-1, "re_comp(): %s", error_msg);
	if ((ret = re_exec(str)) < 0)
	    Error(-1, "re_exec(): internal error");
	return (ret);
#  endif /* SVR4 */
#endif /* hpux */
}


/*----------------------------------------------------------------------------*/
void
StrFree(
   string* str
)
{
	Free((void**)str);
}
