/******************************************************************************
 * $RCSfile: error.h,v $   $Revision: 1.2 $
 * Copyright (C) 1993  A.Michael.Leliveld@Informatik.TU-Muenchen.De
 ******************************************************************************/

#ifndef _MISC_ERROR_H
#define _MISC_ERROR_H


#include <stdio.h>
#include <unistd.h>
#ifdef sun
#  include <varargs.h>
#else
#  include <stdarg.h>
#endif
#include <time.h>

#include <misc/str.h>


#define ERROR -1
#define OK    0


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

extern FILE *errout, *debugout;
extern char *programname;
extern int debugflag;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern void
Error(
   int,				/* ExitCode */
   char *,			/* format of message */
   ...				/* variable arglist */
);

extern void
Warning(
   char *,			/* format of message */
   ...				/* variable arglist */
);

extern void
DebugMsg(
   char *,			/* name of the output-file  or  NULL */
   char *,			/* function name */
   char *,			/* format of message */
   ...				/* variable arglist */
);				/* print a formated message to debugout, if
				 * debugflag != 0 */

extern void
MsgToFile(
   char *,			/* file name */
   char *,			/* format of message */
   ...				/* variable arglist */
);


#endif	 /* _MISC_ERROR_H */
