#!/bin/awk
# SCCS_data: @(#) nsb.awk 1.4 92/03/17 16:01:59
# 
# Eat lines which look like cpp file syncronization lines (# number "file")
# and collpse multiple blank lines so only one blank line is printed.
#
# Intended to be used as a postprocessing filter following cpp which leaves
# blank lines whenever it sees a cpp directive or a C comment.
#
BEGIN				{ prevBlankLine = 0 }

$1 == "#" && $2 ~ /^[0-9]+$/ 	{ prevBlankLine++ ; next }

NF == 0				{ if (!prevBlankLine)
				  { prevBlankLine++ ; print }
				  next
				}

				{ prevBlankLine = 0 ; print }
