/* xtea - distribute beverages and other resources over the network
 *
 * Copyright (c) 1994 Henning Spruth (spruth@regent.e-technik.tu-muenchen.de)
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/tcp.h>

#include "alloc.h"
#include "sockio.h"

/* ********************************* get_short() **************************
 * 
 * Receive a 16-bit value from the net.
 *
*/
int get_short(int s, int *ret)
{
  unsigned char byte1,byte2;

  if(read(s,&byte1,1)<=0)
  { perror("read");
    return 1;
  }
  if(read(s,&byte2,1)<=0)
  { perror("read");
    return 1;
  }
  *ret=byte1*256+byte2;
  return 0;
}


/* ******************************* get_string() **************************
 * 
 * Receive a string from the net.
 *
*/
int get_string(int s, char **c)
{
  int len;
  char *str;
  int rcvd=0;
  int ret;
  if(get_short(s,&len)) return 1;
  str = myalloc(len+1);
  if(!str) return 1;
  while(rcvd<len)
  { ret=read(s,str+rcvd,len-rcvd);
    if(ret<=0)
    { perror("read");
      return 1;
    }
    rcvd += ret;
  }
  if(len>0 && str[len-1]=='\n') len--;
  str[len]='\0';
  *c=str;
  return 0;
}


/* ****************************** put_short() ******************************
 *
 * Put a 16-bit value on the net.
 *
*/
int put_short(int s, int data)
{
  short wr_data;
  wr_data=htons((short)data);
  if(write(s,&wr_data,2)<=0)
  { perror("write");
    return 1;
  }
  return 0;
}


/* ******************************** put_string() ***************************
 *
 * Put a string on the net.
 *
*/
int put_string(int s, char *str)
{
  int len;
  len=strlen(str);
  put_short(s,len);
  if(len>0)
  {
    if(write(s,str,len)<=0)
    {
      perror("write");
      return 1;
    }
  }
  return 0;
}
