/* xtea - distribute beverages and other resources over the network
 *
 * Copyright (c) 1994 Henning Spruth (spruth@regent.e-technik.tu-muenchen.de)
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>

#include "version.h"
#include "sockio.h"
#include "message.h"

int mastersocket;

/* ************************************ fatal_error() ***********************
 *
 * Fatal error handler.
 *
*/
void fatal_error(int code)
{
  fprintf(stderr,"Fatal error - aborting\n");
  exit(code);
}


int main()
{
  int n,sock,mastersocket;
  char buf[200];
  struct sockaddr_in sockdata;
  char *s;

  printf("\nxtea query utility version %s:\n",XTEA_VERSION);
  if(init_listen(0,&mastersocket))
    fatal_error(1);

  if(start_servermessage(QUERYSTATUS,&sock))
  {
    sprintf(buf,"Can't connect to xtead on host %s",XTEASERVER);
    perror(buf);
    fatal_error(1);
  }
  if(gethostname(buf,sizeof(buf)-1)<0)
  { perror("gethostname");
    fatal_error(1);
  }
  put_string(sock,buf);

  n=sizeof(sockdata);
  if(getsockname(mastersocket,(struct sockaddr *) &sockdata,&n))
  {
    perror("getsockname");
    fatal_error(1);
  }
  sprintf(buf,"%d",htons(sockdata.sin_port));
  put_string(sock,buf);
  put_string(sock,"END");

  sock=accept(mastersocket,(struct sockaddr *) &sockdata,&n);
  
  get_string(sock,&s);
  while(strcmp(s,"END")!=0)
  {
    printf("%s\n",s);
    free(s);
    get_string(sock,&s);
  }
  free(s);
  close(sock);
  close(mastersocket);
  return 0;
}
